/**
 * This file is part of the Meeds project (https://meeds.io/).
 *
 * Copyright (C) 2020 - 2025 Meeds Association contact@meeds.io
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */
package org.gatein.pc.test.portlet.jsr286.ext.dispatcher;

import org.gatein.pc.test.unit.PortletTestCase;
import org.gatein.pc.test.unit.PortletTestContext;
import org.gatein.pc.test.unit.Assertion;
import org.gatein.pc.test.unit.annotations.TestCase;
import org.gatein.pc.test.unit.actions.PortletRenderTestAction;
import org.gatein.pc.test.unit.web.UTP1;
import org.gatein.pc.test.unit.protocol.response.Response;
import org.gatein.pc.test.unit.protocol.response.EndTestResponse;
import static org.gatein.pc.test.unit.Assert.*;
import org.gatein.pc.test.unit.protocol.response.InvokeGetResponse;

import javax.portlet.Portlet;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.PortletException;
import javax.portlet.PortletRequestDispatcher;
import java.io.IOException;
import java.io.PrintWriter;

@TestCase({
   Assertion.EXT_DISPATCHER_2
   })
public class Content
{
   public Content(PortletTestCase seq)
   {
      seq.bindAction(0, UTP1.RENDER_JOIN_POINT, new PortletRenderTestAction()
      {
         protected Response run(Portlet portlet, RenderRequest request, RenderResponse response, PortletTestContext context) throws PortletException, IOException
         {
            response.setContentType("text/html");
            PrintWriter writer = response.getWriter();
            writer.print("@ShouldNotBePresent@");

            //
            PortletRequestDispatcher prd = request.getPortletSession().getPortletContext().getRequestDispatcher("/ForwardedRequestContentServlet");
            assertNotNull(prd);
            prd.forward(request, response);

            //
            assertTrue(response.isCommitted());

            //
            return new InvokeGetResponse(response.createRenderURL().toString());
         }
      });
      seq.bindAction(1, UTP1.RENDER_JOIN_POINT, new PortletRenderTestAction()
      {
         protected Response run(Portlet portlet, RenderRequest request, RenderResponse response, PortletTestContext context) throws PortletException, IOException
         {
            byte[] bytes = context.getResponseBody();
            String s = new String(bytes);
            assertFalse("Page " + s + " should not contain the string @ShouldNotBePresent@", s.contains("@ShouldNotBePresent@"));
            assertTrue("Page " + s + " should contain the string @ForwardedRequestContent@", s.contains("@ForwardedRequestContent@"));

            //
            response.setContentType("text/html");
            PrintWriter writer = response.getWriter();
            writer.print("@ShouldNotBePresent@");

            //
            PortletRequestDispatcher prd = request.getPortletSession().getPortletContext().getNamedDispatcher("ForwardedNamedContentServlet");
            assertNotNull(prd);
            prd.forward(request, response);

            //
            assertTrue(response.isCommitted());

            //
            return new InvokeGetResponse(response.createRenderURL().toString());
         }
      });
      seq.bindAction(2, UTP1.RENDER_JOIN_POINT, new PortletRenderTestAction()
      {
         protected Response run(Portlet portlet, RenderRequest request, RenderResponse response, PortletTestContext context) throws PortletException, IOException
         {
            byte[] bytes = context.getResponseBody();
            String s = new String(bytes);
            assertFalse("Page " + s + " should not contain the string @ShouldNotBePresent@", s.contains("@ShouldNotBePresent@"));
            assertTrue("Page " + s + " should contain the string @NamedRequestContent@", s.contains("@ForwardedNamedContent@"));

            //
            response.setContentType("text/html");
            PrintWriter writer = response.getWriter();
            writer.print("@BeforeIncludeRequestContent@");

            //
            PortletRequestDispatcher prd = request.getPortletSession().getPortletContext().getRequestDispatcher("/IncludedRequestContentServlet");
            assertNotNull(prd);
            prd.include(request, response);

            //
            assertFalse(response.isCommitted());
            writer.print("@AfterIncludeRequestContent@");

            //
            return new InvokeGetResponse(response.createRenderURL().toString());
         }
      });
      seq.bindAction(3, UTP1.RENDER_JOIN_POINT, new PortletRenderTestAction()
      {
         protected Response run(Portlet portlet, RenderRequest request, RenderResponse response, PortletTestContext context) throws PortletException, IOException
         {
            byte[] bytes = context.getResponseBody();
            String s = new String(bytes);
            String t = "@BeforeIncludeRequestContent@@IncludedRequestContent@@AfterIncludeRequestContent@";
            assertTrue("Page " + s + " should contain the string " + t, s.contains(t));

            //
            response.setContentType("text/html");
            PrintWriter writer = response.getWriter();
            writer.print("@BeforeIncludeNamedContent@");

            //
            PortletRequestDispatcher prd = request.getPortletSession().getPortletContext().getNamedDispatcher("IncludedNamedContentServlet");
            assertNotNull(prd);
            prd.include(request, response);

            //
            assertFalse(response.isCommitted());
            writer.print("@AfterIncludeNamedContent@");

            //
            return new InvokeGetResponse(response.createRenderURL().toString());
         }
      });
      seq.bindAction(4, UTP1.RENDER_JOIN_POINT, new PortletRenderTestAction()
      {
         protected Response run(Portlet portlet, RenderRequest request, RenderResponse response, PortletTestContext context) throws PortletException, IOException
         {
            byte[] bytes = context.getResponseBody();
            String s = new String(bytes);
            String t = "@BeforeIncludeNamedContent@@IncludedNamedContent@@AfterIncludeNamedContent@";
            assertTrue("Page " + s + " should contain the string " + t, s.contains(t));

            //
            return new EndTestResponse();
         }
      });
   }
}
