/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.test.portlet.jsr286.ext.portletrequests;

import java.io.IOException;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.EventRequest;
import javax.portlet.EventResponse;
import javax.portlet.Portlet;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import org.gatein.pc.test.unit.Assert;
import org.gatein.pc.test.unit.Assertion;
import org.gatein.pc.test.unit.PortletTestCase;
import org.gatein.pc.test.unit.PortletTestContext;
import org.gatein.pc.test.unit.TestAction;
import org.gatein.pc.test.unit.actions.PortletActionTestAction;
import org.gatein.pc.test.unit.actions.PortletEventTestAction;
import org.gatein.pc.test.unit.actions.PortletRenderTestAction;
import org.gatein.pc.test.unit.actions.PortletResourceTestAction;
import org.gatein.pc.test.unit.annotations.TestCase;
import org.gatein.pc.test.unit.protocol.response.EndTestResponse;
import org.gatein.pc.test.unit.protocol.response.InvokeGetResponse;
import org.gatein.pc.test.unit.protocol.response.Response;
import org.gatein.pc.test.unit.web.UTP5;

@TestCase(value={Assertion.EXT_PORTLET_REQUESTS_8})
public class ReadCookie {
    public ReadCookie(PortletTestCase seq) {
        seq.bindAction(0, UTP5.RENDER_JOIN_POINT, (TestAction)new PortletRenderTestAction(this){

            protected Response run(Portlet portlet, RenderRequest request, RenderResponse response, PortletTestContext context) throws PortletException, IOException {
                Map cookieMap = this.createCookieMap((PortletRequest)request);
                Assert.assertFalse((boolean)cookieMap.containsKey("foo"));
                Assert.assertFalse((boolean)cookieMap.containsKey("bar"));
                InvokeGetResponse get = new InvokeGetResponse(response.createRenderURL().toString());
                get.addHeader("Cookie", "foo=foo_value1; bar=bar_value2");
                return get;
            }
        });
        seq.bindAction(1, UTP5.RENDER_JOIN_POINT, (TestAction)new PortletRenderTestAction(this){

            protected Response run(Portlet portlet, RenderRequest request, RenderResponse response, PortletTestContext context) throws PortletException, IOException {
                Map cookieMap = this.createCookieMap((PortletRequest)request);
                Assert.assertEquals((Object)"foo_value1", cookieMap.get("foo"));
                Assert.assertEquals((Object)"bar_value2", cookieMap.get("bar"));
                InvokeGetResponse get = new InvokeGetResponse(response.createActionURL().toString());
                get.addHeader("Cookie", "foo=foo_value3; bar=bar_value4");
                return get;
            }
        });
        seq.bindAction(2, UTP5.ACTION_JOIN_POINT, (TestAction)new PortletActionTestAction(this){

            protected void run(Portlet portlet, ActionRequest request, ActionResponse response, PortletTestContext context) throws PortletException, IOException {
                Map cookieMap = this.createCookieMap((PortletRequest)request);
                Assert.assertEquals((Object)"foo_value3", cookieMap.get("foo"));
                Assert.assertEquals((Object)"bar_value4", cookieMap.get("bar"));
                response.setEvent("Event", null);
            }
        });
        seq.bindAction(2, UTP5.EVENT_JOIN_POINT, (TestAction)new PortletEventTestAction(this){

            protected void run(Portlet portlet, EventRequest request, EventResponse response, PortletTestContext context) throws PortletException, IOException {
                Map cookieMap = this.createCookieMap((PortletRequest)request);
                Assert.assertEquals((Object)"foo_value3", cookieMap.get("foo"));
                Assert.assertEquals((Object)"bar_value4", cookieMap.get("bar"));
            }
        });
        seq.bindAction(2, UTP5.RENDER_JOIN_POINT, (TestAction)new PortletRenderTestAction(this){

            protected Response run(Portlet portlet, RenderRequest request, RenderResponse response, PortletTestContext context) throws PortletException, IOException {
                InvokeGetResponse get = new InvokeGetResponse(response.createResourceURL().toString());
                get.addHeader("Cookie", "foo=foo_value5; bar=bar_value6");
                return get;
            }
        });
        seq.bindAction(3, UTP5.RESOURCE_JOIN_POINT, (TestAction)new PortletResourceTestAction(this){

            protected Response run(Portlet portlet, ResourceRequest request, ResourceResponse response, PortletTestContext context) throws PortletException, IOException {
                Map cookieMap = this.createCookieMap((PortletRequest)request);
                Assert.assertEquals((Object)"foo_value5", cookieMap.get("foo"));
                Assert.assertEquals((Object)"bar_value6", cookieMap.get("bar"));
                return new EndTestResponse();
            }
        });
    }
}

