/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.test.unit;

import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Properties;
import org.gatein.pc.api.spi.ServerContext;
import org.gatein.pc.test.TestPortletApplicationDeployer;
import org.gatein.pc.test.unit.PortletTestCase;

public class PortletTestServlet
extends HttpServlet {
    private static HashMap<String, PortletTestCase> testSuite;
    public static final ThreadLocal<ServerContext.Callable> callback;

    public static PortletTestCase getTestCase(String testName) {
        if (testName == null) {
            throw new IllegalArgumentException("Test name can't be null");
        }
        return testSuite != null ? testSuite.get(testName) : null;
    }

    public void init() throws ServletException {
        ServletContext ctx = this.getServletContext();
        InputStream in = ctx.getResourceAsStream("/WEB-INF/suite.properties");
        if (in != null) {
            try {
                HashMap<String, PortletTestCase> suite = new HashMap<String, PortletTestCase>();
                Properties props = new Properties();
                props.load(in);
                for (Object key : props.keySet()) {
                    ClassLoader loader = ctx.getClassLoader();
                    Class<?> clazz = loader.loadClass(key.toString());
                    Constructor<?> ctor = clazz.getConstructor(PortletTestCase.class);
                    String testCaseName = clazz.getSimpleName();
                    PortletTestCase portletTestCase = new PortletTestCase(testCaseName, ctx);
                    ctor.newInstance(portletTestCase);
                    suite.put(testCaseName, portletTestCase);
                }
                testSuite = suite;
            }
            catch (Exception e) {
                throw new ServletException((Throwable)e);
            }
        }
        TestPortletApplicationDeployer.deploy(ctx);
    }

    public void destroy() {
        TestPortletApplicationDeployer.undeploy(this.getServletContext());
        super.destroy();
    }

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        ServerContext.Callable cb = callback.get();
        if (cb != null) {
            cb.call(this.getServletContext(), req, resp);
        }
    }

    static {
        callback = new ThreadLocal();
    }
}

