/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.test.portlet.jsr168.ext.expiringcache;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import javax.portlet.Portlet;
import javax.portlet.PortletException;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.gatein.common.util.Tools;
import org.gatein.pc.test.unit.Assert;
import org.gatein.pc.test.unit.Assertion;
import org.gatein.pc.test.unit.Failure;
import org.gatein.pc.test.unit.PortletTestCase;
import org.gatein.pc.test.unit.PortletTestContext;
import org.gatein.pc.test.unit.TestAction;
import org.gatein.pc.test.unit.actions.PortletRenderTestAction;
import org.gatein.pc.test.unit.annotations.TestCase;
import org.gatein.pc.test.unit.protocol.response.EndTestResponse;
import org.gatein.pc.test.unit.protocol.response.FailureResponse;
import org.gatein.pc.test.unit.protocol.response.InvokeGetResponse;
import org.gatein.pc.test.unit.protocol.response.Response;
import org.gatein.pc.test.unit.web.UTP10;
import org.gatein.pc.test.unit.web.UTP11;

@TestCase(value={Assertion.EXT_EXPIRING_CACHE_3})
public class ExpiringCache {
    final Set calls = new HashSet();
    String url;

    public ExpiringCache(PortletTestCase seq) {
        seq.bindAction(0, UTP10.RENDER_JOIN_POINT, (TestAction)new PortletRenderTestAction(){

            protected Response run(Portlet portlet, RenderRequest request, RenderResponse response, PortletTestContext context) throws IOException, PortletException {
                ExpiringCache.this.calls.add("0");
                ExpiringCache.this.url = response.createRenderURL().toString();
                return new InvokeGetResponse(ExpiringCache.this.url);
            }
        });
        seq.bindAction(1, UTP10.RENDER_JOIN_POINT, (TestAction)new PortletRenderTestAction(){

            protected Response run(Portlet portlet, RenderRequest request, RenderResponse response, PortletTestContext context) throws IOException, PortletException {
                ExpiringCache.this.calls.add("1");
                return null;
            }
        });
        seq.bindAction(1, UTP11.RENDER_JOIN_POINT, (TestAction)new PortletRenderTestAction(){

            protected Response run(Portlet portlet, RenderRequest request, RenderResponse response, PortletTestContext context) throws IOException, PortletException {
                return new InvokeGetResponse(ExpiringCache.this.url);
            }
        });
        seq.bindAction(2, UTP10.RENDER_JOIN_POINT, (TestAction)new PortletRenderTestAction(this){

            protected Response run(Portlet portlet, RenderRequest request, RenderResponse response, PortletTestContext context) throws IOException, PortletException {
                response.setProperty("portlet.expiration-cache", "0");
                return null;
            }
        });
        seq.bindAction(2, UTP11.RENDER_JOIN_POINT, (TestAction)new PortletRenderTestAction(){

            protected Response run(Portlet portlet, RenderRequest request, RenderResponse response, PortletTestContext context) throws IOException, PortletException {
                try {
                    Assert.assertFalse((boolean)ExpiringCache.this.calls.contains("1"));
                    Thread.sleep(5000L);
                    return new InvokeGetResponse(ExpiringCache.this.url);
                }
                catch (InterruptedException e) {
                    return new FailureResponse(Failure.createFailure((Throwable)e));
                }
            }
        });
        seq.bindAction(3, UTP10.RENDER_JOIN_POINT, (TestAction)new PortletRenderTestAction(){

            protected Response run(Portlet portlet, RenderRequest request, RenderResponse response, PortletTestContext context) throws IOException, PortletException {
                ExpiringCache.this.calls.add("3");
                PortletURL tmp = response.createRenderURL();
                tmp.setParameter("abc", "def");
                ExpiringCache.this.url = tmp.toString();
                return new InvokeGetResponse(ExpiringCache.this.url);
            }
        });
        seq.bindAction(4, UTP10.RENDER_JOIN_POINT, (TestAction)new PortletRenderTestAction(){

            protected Response run(Portlet portlet, RenderRequest request, RenderResponse response, PortletTestContext context) throws IOException, PortletException {
                ExpiringCache.this.calls.add("4");
                return new InvokeGetResponse(ExpiringCache.this.url);
            }
        });
        seq.bindAction(5, UTP10.RENDER_JOIN_POINT, (TestAction)new PortletRenderTestAction(){

            protected Response run(Portlet portlet, RenderRequest request, RenderResponse response, PortletTestContext context) throws IOException, PortletException {
                ExpiringCache.this.calls.add("5");
                return null;
            }
        });
        seq.bindAction(5, UTP11.RENDER_JOIN_POINT, (TestAction)new PortletRenderTestAction(){

            protected Response run(Portlet portlet, RenderRequest request, RenderResponse response, PortletTestContext context) throws IOException, PortletException {
                return new InvokeGetResponse(ExpiringCache.this.url);
            }
        });
        seq.bindAction(6, UTP10.RENDER_JOIN_POINT, (TestAction)new PortletRenderTestAction(this){

            protected Response run(Portlet portlet, RenderRequest request, RenderResponse response, PortletTestContext context) throws IOException, PortletException {
                response.setProperty("portlet.expiration-cache", "0");
                return null;
            }
        });
        seq.bindAction(6, UTP11.RENDER_JOIN_POINT, (TestAction)new PortletRenderTestAction(){

            protected Response run(Portlet portlet, RenderRequest request, RenderResponse response, PortletTestContext context) throws IOException, PortletException {
                try {
                    Assert.assertFalse((boolean)ExpiringCache.this.calls.contains("5"));
                    Thread.sleep(5000L);
                    return new InvokeGetResponse(ExpiringCache.this.url);
                }
                catch (InterruptedException e) {
                    return new FailureResponse(Failure.createFailure((Throwable)e));
                }
            }
        });
        seq.bindAction(7, UTP10.RENDER_JOIN_POINT, (TestAction)new PortletRenderTestAction(){

            protected Response run(Portlet portlet, RenderRequest request, RenderResponse response, PortletTestContext context) throws IOException, PortletException {
                ExpiringCache.this.calls.add("7");
                Set expected = Tools.toSet((Object[])new String[]{"0", "3", "4", "7"});
                Assert.assertEquals((Object)expected, (Object)ExpiringCache.this.calls);
                return new EndTestResponse();
            }
        });
    }
}

