/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.test.controller.unit;

import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Collection;
import org.gatein.common.io.Serialization;
import org.gatein.pc.api.Portlet;
import org.gatein.pc.api.PortletContext;
import org.gatein.pc.api.PortletInvoker;
import org.gatein.pc.api.PortletInvokerException;
import org.gatein.pc.api.invocation.PortletInvocation;
import org.gatein.pc.api.invocation.response.PortletInvocationResponse;
import org.gatein.pc.api.spi.PortletInvocationContext;
import org.gatein.pc.api.spi.ServerContext;
import org.gatein.pc.controller.event.EventControllerContext;
import org.gatein.pc.controller.impl.AbstractControllerContext;
import org.gatein.pc.controller.impl.event.EventControllerContextImpl;
import org.gatein.pc.controller.impl.state.StateControllerContextImpl;
import org.gatein.pc.controller.state.PageNavigationalState;
import org.gatein.pc.controller.state.StateControllerContext;
import org.gatein.pc.portlet.impl.spi.AbstractServerContext;
import org.gatein.pc.test.controller.unit.ControllerPortletInvocationContext;
import org.gatein.pc.test.controller.unit.PageNavigationalStateSerialization;
import org.gatein.pc.test.unit.PortletTestServlet;

public class PortletControllerContextImpl
extends AbstractControllerContext {
    private final PortletInvoker portletInvoker;
    private final EventControllerContext eventControllerContext;
    private final StateControllerContext stateControllerContext;
    private final Serialization<PageNavigationalState> serialization;

    public PortletControllerContextImpl(HttpServletRequest req, HttpServletResponse resp, ServletContext servletContext) throws IOException, ClassNotFoundException {
        super(req, resp);
        this.portletInvoker = (PortletInvoker)servletContext.getAttribute("ConsumerPortletInvoker");
        this.eventControllerContext = new EventControllerContextImpl(this.portletInvoker);
        this.stateControllerContext = new StateControllerContextImpl();
        this.serialization = new PageNavigationalStateSerialization(this.stateControllerContext);
    }

    public PortletInvoker getPortletInvoker() {
        return this.portletInvoker;
    }

    protected Portlet getPortlet(String windowId) throws PortletInvokerException {
        return this.portletInvoker.getPortlet(PortletContext.createPortletContext((String)windowId));
    }

    public StateControllerContext getStateControllerContext() {
        return this.stateControllerContext;
    }

    public PortletInvocationResponse invoke(PortletInvocation invocation) throws PortletInvokerException {
        invocation.setServerContext((ServerContext)new AbstractServerContext(this.getClientRequest(), this.getClientResponse()){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void dispatch(ServletContext target, HttpServletRequest request, HttpServletResponse response, ServerContext.Callable callable) throws Exception {
                RequestDispatcher dispatcher = target.getRequestDispatcher("/portlet");
                PortletTestServlet.callback.set(callable);
                try {
                    dispatcher.include((ServletRequest)PortletControllerContextImpl.this.getClientRequest(), (ServletResponse)PortletControllerContextImpl.this.getClientResponse());
                }
                finally {
                    PortletTestServlet.callback.set(null);
                }
            }
        });
        return this.portletInvoker.invoke(invocation);
    }

    public EventControllerContext getEventControllerContext() {
        return this.eventControllerContext;
    }

    public Collection<Portlet> getPortlets() throws PortletInvokerException {
        return this.portletInvoker.getPortlets();
    }

    public PortletInvocationContext createPortletInvocationContext(String windowId, PageNavigationalState pageNavigationalState) {
        return new ControllerPortletInvocationContext(this.serialization, this.req, this.resp, windowId, pageNavigationalState);
    }

    public Serialization<PageNavigationalState> getPageNavigationalStateSerialization() {
        return this.serialization;
    }
}

