/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.test.portlet.jsr168.ext.portletrequests;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.Portlet;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.gatein.common.util.Tools;
import org.gatein.pc.test.unit.Assert;
import org.gatein.pc.test.unit.Assertion;
import org.gatein.pc.test.unit.PortletTestCase;
import org.gatein.pc.test.unit.PortletTestContext;
import org.gatein.pc.test.unit.TestAction;
import org.gatein.pc.test.unit.actions.PortletActionTestAction;
import org.gatein.pc.test.unit.actions.PortletRenderTestAction;
import org.gatein.pc.test.unit.annotations.TestCase;
import org.gatein.pc.test.unit.protocol.response.EndTestResponse;
import org.gatein.pc.test.unit.protocol.response.InvokeGetResponse;
import org.gatein.pc.test.unit.protocol.response.Response;
import org.gatein.pc.test.unit.web.UTP1;

@TestCase(value={Assertion.EXT_PORTLET_REQUESTS_7})
public class RequestParameter {
    public RequestParameter(PortletTestCase seq) {
        seq.bindAction(0, UTP1.RENDER_JOIN_POINT, (TestAction)new PortletRenderTestAction(this){

            protected Response run(Portlet portlet, RenderRequest request, RenderResponse response, PortletTestContext context) {
                PortletURL url = response.createActionURL();
                url.setParameter("foo1", "bar1");
                url.setParameter("foo2", new String[]{"bar2_1", "bar2_2"});
                return new InvokeGetResponse(url.toString());
            }
        });
        seq.bindAction(1, UTP1.ACTION_JOIN_POINT, (TestAction)new PortletActionTestAction(this){

            protected void run(Portlet portlet, ActionRequest request, ActionResponse response, PortletTestContext context) {
                HashMap<String, Set> expectedParameterMap = new HashMap<String, Set>();
                expectedParameterMap.put("foo1", Tools.toSet((Object[])new String[]{"bar1"}));
                expectedParameterMap.put("foo2", Tools.toSet((Object[])new String[]{"bar2_1", "bar2_2"}));
                HashMap parameterMap = new HashMap(request.getParameterMap());
                for (Map.Entry entry : parameterMap.entrySet()) {
                    Object[] values = (String[])entry.getValue();
                    entry.setValue(Tools.toSet((Object[])values));
                }
                Assert.assertEquals(expectedParameterMap, parameterMap);
                Set enumeration = Tools.toSet((Enumeration)request.getParameterNames());
                Set set = Tools.toSet((Object[])new Object[]{"foo1", "foo2"});
                Assert.assertEquals((Object)set, (Object)enumeration);
            }
        });
        seq.bindAction(1, UTP1.RENDER_JOIN_POINT, (TestAction)new PortletRenderTestAction(this){

            protected Response run(Portlet portlet, RenderRequest request, RenderResponse response, PortletTestContext context) {
                return new EndTestResponse();
            }
        });
    }
}

