/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.test.portlet.jsr286.tck.dispatcher;

import jakarta.servlet.Servlet;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.EventRequest;
import javax.portlet.EventResponse;
import javax.portlet.Portlet;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import org.gatein.common.util.Tools;
import org.gatein.pc.api.LifeCyclePhase;
import org.gatein.pc.test.unit.Assert;
import org.gatein.pc.test.unit.PortletTestCase;
import org.gatein.pc.test.unit.PortletTestContext;
import org.gatein.pc.test.unit.TestAction;
import org.gatein.pc.test.unit.actions.PortletActionTestAction;
import org.gatein.pc.test.unit.actions.PortletEventTestAction;
import org.gatein.pc.test.unit.actions.PortletRenderTestAction;
import org.gatein.pc.test.unit.actions.PortletResourceTestAction;
import org.gatein.pc.test.unit.actions.ServletServiceTestAction;
import org.gatein.pc.test.unit.protocol.response.EndTestResponse;
import org.gatein.pc.test.unit.protocol.response.InvokeGetResponse;
import org.gatein.pc.test.unit.protocol.response.Response;
import org.gatein.pc.test.unit.web.AbstractUniversalTestPortlet;
import org.gatein.pc.test.unit.web.UTP1;
import org.gatein.pc.test.unit.web.UTS1;

public abstract class DispatchedContainerAttributes {
    private final Map<String, String> expectedAttributes;
    private final Map<String, String> expectedInfos;
    private final Map<String, Object> collectedAttributes;
    private final Map<String, Object> collectedInfos;
    ServletServiceTestAction service = new ServletServiceTestAction(){

        protected Response run(Servlet servlet, HttpServletRequest request, HttpServletResponse response, PortletTestContext context) throws ServletException, IOException {
            Set attributeNames = Tools.toSet((Enumeration)request.getAttributeNames());
            DispatchedContainerAttributes.this.collectedAttributes.clear();
            for (String name : DispatchedContainerAttributes.this.expectedAttributes.keySet()) {
                if (!attributeNames.contains(name)) continue;
                Object value = request.getAttribute(name);
                DispatchedContainerAttributes.this.collectedAttributes.put(name, value);
            }
            DispatchedContainerAttributes.this.collectedInfos.clear();
            DispatchedContainerAttributes.this.collectedInfos.put("path_info", request.getPathInfo());
            DispatchedContainerAttributes.this.collectedInfos.put("context_path", request.getContextPath());
            DispatchedContainerAttributes.this.collectedInfos.put("query_string", request.getQueryString());
            DispatchedContainerAttributes.this.collectedInfos.put("servlet_path", request.getServletPath());
            DispatchedContainerAttributes.this.collectedInfos.put("request_uri", request.getRequestURI());
            return null;
        }
    };

    public DispatchedContainerAttributes(PortletTestCase seq, Map<String, String> expectedAttributes) {
        this(seq, expectedAttributes, new HashMap<String, String>());
    }

    public DispatchedContainerAttributes(PortletTestCase seq, Map<String, String> expectedAttributes, Map<String, String> expectedInfos) {
        this.expectedAttributes = expectedAttributes;
        this.expectedInfos = expectedInfos;
        this.collectedAttributes = new HashMap<String, Object>();
        this.collectedInfos = new HashMap<String, Object>();
        seq.bindAction(0, UTP1.RENDER_JOIN_POINT, (TestAction)new PortletRenderTestAction(this){

            protected Response run(Portlet portlet, RenderRequest request, RenderResponse response, PortletTestContext context) throws IOException, PortletException {
                return new InvokeGetResponse(response.createActionURL().toString());
            }
        });
        seq.bindAction(1, UTP1.ACTION_JOIN_POINT, (TestAction)new PortletActionTestAction(){

            protected void run(Portlet portlet, ActionRequest request, ActionResponse response, PortletTestContext context) throws PortletException, IOException {
                if (DispatchedContainerAttributes.this.performTest(LifeCyclePhase.ACTION)) {
                    DispatchedContainerAttributes.this.doTest(portlet, (PortletRequest)request, (PortletResponse)response);
                }
                response.setEvent("Event", null);
            }
        });
        seq.bindAction(1, UTP1.EVENT_JOIN_POINT, (TestAction)new PortletEventTestAction(){

            protected void run(Portlet portlet, EventRequest request, EventResponse response, PortletTestContext context) throws PortletException, IOException {
                if (DispatchedContainerAttributes.this.performTest(LifeCyclePhase.EVENT)) {
                    DispatchedContainerAttributes.this.doTest(portlet, (PortletRequest)request, (PortletResponse)response);
                }
            }
        });
        seq.bindAction(1, UTP1.RENDER_JOIN_POINT, (TestAction)new PortletRenderTestAction(){

            protected Response run(Portlet portlet, RenderRequest request, RenderResponse response, PortletTestContext context) throws IOException, PortletException {
                if (DispatchedContainerAttributes.this.performTest(LifeCyclePhase.RENDER)) {
                    DispatchedContainerAttributes.this.doTest(portlet, (PortletRequest)request, (PortletResponse)response);
                }
                return new InvokeGetResponse(response.createResourceURL().toString());
            }
        });
        seq.bindAction(1, UTS1.SERVICE_JOIN_POINT, (TestAction)this.service);
        seq.bindAction(2, UTP1.RESOURCE_JOIN_POINT, (TestAction)new PortletResourceTestAction(){

            protected Response run(Portlet portlet, ResourceRequest request, ResourceResponse response, PortletTestContext context) throws PortletException, IOException {
                if (DispatchedContainerAttributes.this.performTest(LifeCyclePhase.RESOURCE)) {
                    DispatchedContainerAttributes.this.doTest(portlet, (PortletRequest)request, (PortletResponse)response);
                }
                return new EndTestResponse();
            }
        });
        seq.bindAction(2, UTS1.SERVICE_JOIN_POINT, (TestAction)this.service);
    }

    protected abstract void dispatch(PortletRequest var1, PortletResponse var2, PortletContext var3) throws IOException, PortletException;

    protected boolean performTest(LifeCyclePhase phase) {
        return true;
    }

    private void doTest(Portlet portlet, PortletRequest request, PortletResponse response) throws PortletException, IOException {
        Object collectedValue;
        String expectedValue;
        PortletContext portletContext = ((AbstractUniversalTestPortlet)portlet).getPortletContext();
        this.dispatch(request, response, portletContext);
        for (Map.Entry<String, String> entry : this.expectedAttributes.entrySet()) {
            String name = entry.getKey();
            expectedValue = entry.getValue();
            if (expectedValue == null) {
                if (!this.collectedAttributes.containsKey(name)) continue;
                Assert.fail((String)("The actual map " + String.valueOf(this.collectedAttributes) + " should not contain the name " + name));
                continue;
            }
            if (this.collectedAttributes.containsKey(name)) {
                collectedValue = this.collectedAttributes.get(name);
                Assert.assertEquals((String)("Was expecting a value " + expectedValue + " for key " + name + " but had instead " + String.valueOf(collectedValue)), (Object)expectedValue, (Object)collectedValue);
                continue;
            }
            Assert.fail((String)("The actual map " + String.valueOf(this.collectedAttributes) + " should contain the name " + name));
        }
        for (Map.Entry<String, String> entry : this.expectedInfos.entrySet()) {
            String key = entry.getKey();
            expectedValue = entry.getValue();
            collectedValue = this.collectedInfos.get(key);
            Assert.assertEquals((String)("Was expecting a value " + expectedValue + " for key " + key + " but had instead " + String.valueOf(collectedValue)), (Object)expectedValue, (Object)collectedValue);
        }
    }
}

