/**
 * This file is part of the Meeds project (https://meeds.io/).
 *
 * Copyright (C) 2020 - 2025 Meeds Association contact@meeds.io
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */
package org.gatein.pc.test.controller.tck;

import org.gatein.pc.api.spi.PortletInvocationContext;
import org.gatein.pc.controller.impl.AbstractControllerContext;
import org.gatein.pc.api.Portlet;
import org.gatein.pc.api.PortletInvokerException;
import org.gatein.pc.api.PortletInvoker;
import org.gatein.pc.api.PortletContext;
import org.gatein.pc.controller.event.EventControllerContext;
import org.gatein.pc.test.controller.unit.ControllerPortletInvocationContext;
import org.gatein.pc.controller.state.PageNavigationalState;
import org.gatein.pc.controller.state.StateControllerContext;
import org.gatein.pc.controller.impl.state.StateControllerContextImpl;
import org.gatein.pc.controller.impl.event.EventControllerContextImpl;
import org.gatein.pc.api.invocation.response.PortletInvocationResponse;
import org.gatein.pc.api.invocation.PortletInvocation;
import org.gatein.common.io.Serialization;
import org.gatein.pc.test.controller.unit.PageNavigationalStateSerialization;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.ServletContext;
import java.io.IOException;
import java.util.Set;

public class TCKPortletControllerContext extends AbstractControllerContext
{

   /** . */
   private final PortletInvoker portletInvoker;

   /** . */
   private final StateControllerContextImpl stateControllerContext;

   /** . */
   private final EventControllerContext eventControllerContext;

   /** . */
   private final Serialization<PageNavigationalState> serialization;

   public TCKPortletControllerContext(
      HttpServletRequest req,
      HttpServletResponse resp,
      ServletContext servletContext) throws IOException
   {
      super(req, resp);

      //
      this.portletInvoker = (PortletInvoker)servletContext.getAttribute("ConsumerPortletInvoker");
      this.stateControllerContext = new StateControllerContextImpl();
      this.eventControllerContext = new EventControllerContextImpl(portletInvoker);
      this.serialization = new PageNavigationalStateSerialization(stateControllerContext);
   }

   public PortletInvoker getPortletInvoker()
   {
      return portletInvoker;
   }

   public Set<Portlet> getPortlets() throws PortletInvokerException
   {
      return portletInvoker.getPortlets();
   }

   protected Portlet getPortlet(String windowId) throws PortletInvokerException
   {
      return portletInvoker.getPortlet(PortletContext.createPortletContext(windowId));
   }

   protected PortletInvocationResponse invoke(PortletInvocation invocation) throws PortletInvokerException
   {
      return portletInvoker.invoke(invocation);
   }

   public PortletInvocationContext createPortletInvocationContext(String windowId, PageNavigationalState pageNavigationalState)
   {
      return new ControllerPortletInvocationContext(serialization, req, resp, windowId, pageNavigationalState);
   }

   public EventControllerContext getEventControllerContext()
   {
      return eventControllerContext;
   }

   public StateControllerContext getStateControllerContext()
   {
      return stateControllerContext;
   }

   public Serialization<PageNavigationalState> getPageNavigationalStateSerialization()
   {
      return serialization;
   }
}
