/**
 * This file is part of the Meeds project (https://meeds.io/).
 *
 * Copyright (C) 2020 - 2025 Meeds Association contact@meeds.io
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */
package org.gatein.pc.test.portlet.jsr286.ext.dispatcher;

import org.gatein.pc.test.unit.PortletTestCase;
import org.gatein.pc.test.unit.PortletTestContext;
import org.gatein.pc.test.unit.Assertion;
import org.gatein.pc.test.unit.actions.PortletRenderTestAction;
import org.gatein.pc.test.unit.web.UTP1;
import org.gatein.common.util.Tools;
import org.gatein.pc.test.unit.annotations.TestCase;
import org.gatein.pc.test.unit.protocol.response.Response;
import org.gatein.pc.test.unit.protocol.response.EndTestResponse;
import static org.gatein.pc.test.unit.Assert.assertNotNull;
import static org.gatein.pc.test.unit.Assert.assertEquals;
import org.gatein.pc.test.unit.protocol.response.InvokeGetResponse;

import javax.portlet.Portlet;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.PortletException;
import javax.portlet.PortletRequestDispatcher;
import java.io.IOException;
import java.util.Collections;

@TestCase({
   Assertion.EXT_DISPATCHER_4
   })
public class Filters
{
   public Filters(PortletTestCase seq)
   {
      seq.bindAction(0, UTP1.RENDER_JOIN_POINT, new PortletRenderTestAction()
      {
         protected Response run(Portlet portlet, RenderRequest request, RenderResponse response, PortletTestContext context) throws IOException, PortletException
         {
            PortletRequestDispatcher prd = request.getPortletSession().getPortletContext().getRequestDispatcher("/noop");
            assertNotNull(prd);
            ServletFilter.ids.clear();
            prd.include(request, response);
            assertEquals(Tools.toSet("INCLUDE_URL_PATTERN_FILTER", "INCLUDE_NAMED_FILTER"), ServletFilter.ids);

            //
            return new InvokeGetResponse(response.createRenderURL().toString());
         }
      });
      seq.bindAction(1, UTP1.RENDER_JOIN_POINT, new PortletRenderTestAction()
      {
         protected Response run(Portlet portlet, RenderRequest request, RenderResponse response, PortletTestContext context) throws IOException, PortletException
         {
            PortletRequestDispatcher prd = request.getPortletSession().getPortletContext().getNamedDispatcher("NoopServlet");
            assertNotNull(prd);
            ServletFilter.ids.clear();
            prd.include(request, response);
            assertEquals(Collections.singleton("INCLUDE_NAMED_FILTER"), ServletFilter.ids);

            //
            return new InvokeGetResponse(response.createRenderURL().toString());
         }
      });
      seq.bindAction(2, UTP1.RENDER_JOIN_POINT, new PortletRenderTestAction()
      {
         protected Response run(Portlet portlet, RenderRequest request, RenderResponse response, PortletTestContext context) throws IOException, PortletException
         {
            PortletRequestDispatcher prd = request.getPortletSession().getPortletContext().getRequestDispatcher("/noop");
            assertNotNull(prd);
            ServletFilter.ids.clear();
            prd.forward(request, response);
            assertEquals(Tools.toSet("INCLUDE_URL_PATTERN_FILTER", "INCLUDE_NAMED_FILTER"), ServletFilter.ids);

            //
            return new InvokeGetResponse(response.createRenderURL().toString());
         }
      });
      seq.bindAction(3, UTP1.RENDER_JOIN_POINT, new PortletRenderTestAction()
      {
         protected Response run(Portlet portlet, RenderRequest request, RenderResponse response, PortletTestContext context) throws IOException, PortletException
         {
            PortletRequestDispatcher prd = request.getPortletSession().getPortletContext().getNamedDispatcher("NoopServlet");
            assertNotNull(prd);
            ServletFilter.ids.clear();
            prd.forward(request, response);
            assertEquals(Collections.singleton("INCLUDE_NAMED_FILTER"), ServletFilter.ids);

            //
            return new EndTestResponse();
         }
      });
   }
}