/**
 * This file is part of the Meeds project (https://meeds.io/).
 *
 * Copyright (C) 2020 - 2025 Meeds Association contact@meeds.io
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */
package org.gatein.pc.test.portlet.jsr286.ext.eventsupport;

import org.gatein.pc.test.portlet.jsr286.ext.common.CommonEventPayload;

import javax.portlet.GenericPortlet;
import javax.portlet.EventRequest;
import javax.portlet.EventResponse;
import javax.portlet.PortletException;
import javax.portlet.Event;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import java.io.IOException;

public class CommonPayloadEventPortlet extends GenericPortlet
{
   public void processEvent(EventRequest req, EventResponse resp) throws PortletException, IOException
   {
      Event event = req.getEvent();

      //
      if ("CommonPing".equals(event.getName()))
      {
         CommonEventPayload payload = (CommonEventPayload)event.getValue();
         if (payload.getString().equals("commonpingvalue"))
         {
            CommonEventPayload newPayload = new CommonEventPayload();
            payload.setString("commonpongvalue");
            newPayload.setString("commonpongvalue");
            resp.setEvent("CommonPong", newPayload);
         }
      }
   }

   @Override
   public void render(RenderRequest request, RenderResponse response) throws PortletException, IOException
   {
      // Nothing special to do
   }
}
