/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.test.portlet.jsr286.tck.portleturl;

import java.io.IOException;
import java.util.Collections;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.Portlet;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.portlet.PortletURLGenerationListener;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.portlet.ResourceURL;
import javax.portlet.WindowState;
import org.gatein.pc.test.portlet.jsr286.tck.portleturl.URLGenerationListener1;
import org.gatein.pc.test.portlet.jsr286.tck.portleturl.URLGenerationListener2;
import org.gatein.pc.test.unit.Assert;
import org.gatein.pc.test.unit.Assertion;
import org.gatein.pc.test.unit.PortletTestCase;
import org.gatein.pc.test.unit.PortletTestContext;
import org.gatein.pc.test.unit.TestAction;
import org.gatein.pc.test.unit.actions.PortletActionTestAction;
import org.gatein.pc.test.unit.actions.PortletRenderTestAction;
import org.gatein.pc.test.unit.actions.PortletResourceTestAction;
import org.gatein.pc.test.unit.annotations.TestCase;
import org.gatein.pc.test.unit.protocol.response.EndTestResponse;
import org.gatein.pc.test.unit.protocol.response.InvokeGetResponse;
import org.gatein.pc.test.unit.protocol.response.Response;
import org.gatein.pc.test.unit.web.UTP1;

@TestCase(value={Assertion.JSR286_50})
public class ListenedURLUpdate {
    private static final PortletURLGenerationListener updater1 = new PortletURLGenerationListener(){

        public void filterActionURL(PortletURL portletURL) {
            try {
                portletURL.setPortletMode(PortletMode.EDIT);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void filterRenderURL(PortletURL portletURL) {
            try {
                portletURL.setPortletMode(PortletMode.VIEW);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void filterResourceURL(ResourceURL resourceURL) {
            try {
                resourceURL.setCacheability("cacheLevelPortlet");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    };
    private static final PortletURLGenerationListener updater2 = new PortletURLGenerationListener(){

        public void filterActionURL(PortletURL portletURL) {
            try {
                if (portletURL.getPortletMode() == PortletMode.EDIT) {
                    portletURL.setWindowState(WindowState.MAXIMIZED);
                    portletURL.setParameter("foo", "fooAction");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void filterRenderURL(PortletURL portletURL) {
            try {
                if (portletURL.getPortletMode() == PortletMode.VIEW) {
                    portletURL.setWindowState(WindowState.NORMAL);
                    portletURL.setParameter("foo", "fooRender");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void filterResourceURL(ResourceURL resourceURL) {
            try {
                if ("cacheLevelPortlet".equals(resourceURL.getCacheability())) {
                    resourceURL.setParameter("foo", "fooResource");
                    resourceURL.setResourceID("foo_resource_id");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    };

    public ListenedURLUpdate(PortletTestCase seq) {
        seq.bindAction(0, UTP1.RENDER_JOIN_POINT, (TestAction)new PortletRenderTestAction(this){

            protected Response run(Portlet portlet, RenderRequest request, RenderResponse response, PortletTestContext context) throws PortletException, IOException {
                URLGenerationListener1.delegate = updater1;
                URLGenerationListener2.delegate = updater2;
                PortletURL actionURL = response.createActionURL();
                String s = actionURL.toString();
                Assert.assertEquals(null, (Object)actionURL.getPortletMode());
                Assert.assertEquals(null, (Object)actionURL.getWindowState());
                Assert.assertEquals((Object)0, (Object)actionURL.getParameterMap().size());
                return new InvokeGetResponse(s);
            }
        });
        seq.bindAction(1, UTP1.ACTION_JOIN_POINT, (TestAction)new PortletActionTestAction(this){

            protected void run(Portlet portlet, ActionRequest request, ActionResponse response, PortletTestContext context) throws PortletException, IOException {
                this.assertParameterMap(Collections.singletonMap("foo", new String[]{"fooAction"}), (PortletRequest)request);
                Assert.assertEquals((Object)PortletMode.EDIT, (Object)request.getPortletMode());
                Assert.assertEquals((Object)WindowState.MAXIMIZED, (Object)request.getWindowState());
            }
        });
        seq.bindAction(1, UTP1.RENDER_JOIN_POINT, (TestAction)new PortletRenderTestAction(this){

            protected Response run(Portlet portlet, RenderRequest request, RenderResponse response, PortletTestContext context) throws PortletException, IOException {
                PortletURL renderURL = response.createRenderURL();
                String s = renderURL.toString();
                Assert.assertEquals(null, (Object)renderURL.getPortletMode());
                Assert.assertEquals(null, (Object)renderURL.getWindowState());
                Assert.assertEquals((Object)0, (Object)renderURL.getParameterMap().size());
                return new InvokeGetResponse(s);
            }
        });
        seq.bindAction(2, UTP1.RENDER_JOIN_POINT, (TestAction)new PortletRenderTestAction(this){

            protected Response run(Portlet portlet, RenderRequest request, RenderResponse response, PortletTestContext context) throws PortletException, IOException {
                this.assertParameterMap(Collections.singletonMap("foo", new String[]{"fooRender"}), (PortletRequest)request);
                Assert.assertEquals((Object)PortletMode.VIEW, (Object)request.getPortletMode());
                Assert.assertEquals((Object)WindowState.NORMAL, (Object)request.getWindowState());
                ResourceURL resourceURL = response.createResourceURL();
                String s = resourceURL.toString();
                Assert.assertEquals((Object)"cacheLevelPage", (Object)resourceURL.getCacheability());
                Assert.assertEquals((Object)0, (Object)resourceURL.getParameterMap().size());
                return new InvokeGetResponse(s);
            }
        });
        seq.bindAction(3, UTP1.RESOURCE_JOIN_POINT, (TestAction)new PortletResourceTestAction(this){

            protected Response run(Portlet portlet, ResourceRequest request, ResourceResponse response, PortletTestContext context) throws PortletException, IOException {
                this.assertParameterMap(Collections.singletonMap("foo", new String[]{"fooResource", "fooRender"}), (PortletRequest)request);
                Assert.assertEquals((Object)"foo_resource_id", (Object)request.getResourceID());
                Assert.assertEquals((Object)"cacheLevelPortlet", (Object)request.getCacheability());
                return new EndTestResponse();
            }
        });
    }
}

