/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.test.portlet.jsr286.tck.dispatcher;

import jakarta.servlet.Servlet;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.HashMap;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.EventRequest;
import javax.portlet.EventResponse;
import javax.portlet.Portlet;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.portlet.ResourceURL;
import org.gatein.pc.test.unit.Assert;
import org.gatein.pc.test.unit.Assertion;
import org.gatein.pc.test.unit.PortletTestCase;
import org.gatein.pc.test.unit.PortletTestContext;
import org.gatein.pc.test.unit.TestAction;
import org.gatein.pc.test.unit.actions.PortletActionTestAction;
import org.gatein.pc.test.unit.actions.PortletEventTestAction;
import org.gatein.pc.test.unit.actions.PortletRenderTestAction;
import org.gatein.pc.test.unit.actions.PortletResourceTestAction;
import org.gatein.pc.test.unit.actions.ServletServiceTestAction;
import org.gatein.pc.test.unit.annotations.TestCase;
import org.gatein.pc.test.unit.protocol.response.EndTestResponse;
import org.gatein.pc.test.unit.protocol.response.InvokeGetResponse;
import org.gatein.pc.test.unit.protocol.response.Response;
import org.gatein.pc.test.unit.web.AbstractUniversalTestPortlet;
import org.gatein.pc.test.unit.web.UTP1;
import org.gatein.pc.test.unit.web.UTS1;
import org.gatein.pc.test.unit.web.UTS2;
import org.gatein.pc.test.unit.web.UTS3;
import org.gatein.pc.test.unit.web.UTS4;

@TestCase(value={Assertion.JSR168_123})
public class QueryStringInRequestDispatcher {
    public QueryStringInRequestDispatcher(PortletTestCase seq) {
        seq.bindAction(0, UTP1.RENDER_JOIN_POINT, (TestAction)new PortletRenderTestAction(this){

            protected Response run(Portlet portlet, RenderRequest request, RenderResponse response, PortletTestContext context) {
                PortletURL actionURL = response.createActionURL();
                actionURL.setParameter("key1", "k1actionvalue");
                actionURL.setParameter("key3", "k3actionvalue");
                return new InvokeGetResponse(actionURL.toString());
            }
        });
        seq.bindAction(1, UTP1.ACTION_JOIN_POINT, (TestAction)new PortletActionTestAction(this){

            protected void run(Portlet portlet, ActionRequest request, ActionResponse response, PortletTestContext context) throws IOException, PortletException {
                HashMap<String, String[]> actionParams = new HashMap<String, String[]>();
                actionParams.put("key1", new String[]{"k1actionvalue"});
                actionParams.put("key3", new String[]{"k3actionvalue"});
                this.assertParameterMap(actionParams, (PortletRequest)request);
                String path = "/universalServletA?key1=k1value1&key2=k2value1";
                PortletRequestDispatcher dispatcher = ((AbstractUniversalTestPortlet)portlet).getPortletContext().getRequestDispatcher(path);
                dispatcher.include((PortletRequest)request, (PortletResponse)response);
                this.assertParameterMap(actionParams, (PortletRequest)request);
                response.setEvent("Event", null);
            }
        });
        seq.bindAction(1, UTS1.SERVICE_JOIN_POINT, (TestAction)new ServletServiceTestAction(this){

            protected Response run(Servlet servlet, HttpServletRequest request, HttpServletResponse response, PortletTestContext context) throws ServletException, IOException {
                Assert.assertEquals((Object[])new String[]{"k1value1", "k1actionvalue"}, (Object[])request.getParameterValues("key1"));
                Assert.assertEquals((Object[])new String[]{"k2value1"}, (Object[])request.getParameterValues("key2"));
                Assert.assertEquals((Object[])new String[]{"k3actionvalue"}, (Object[])request.getParameterValues("key3"));
                return null;
            }
        });
        seq.bindAction(1, UTP1.EVENT_JOIN_POINT, (TestAction)new PortletEventTestAction(this){

            protected void run(Portlet portlet, EventRequest request, EventResponse response, PortletTestContext context) throws PortletException, IOException {
                HashMap eventParams = new HashMap();
                this.assertParameterMap(eventParams, (PortletRequest)request);
                String path = "/universalServletB?key1=k1value1&key2=k2value1";
                PortletRequestDispatcher dispatcher = ((AbstractUniversalTestPortlet)portlet).getPortletContext().getRequestDispatcher(path);
                dispatcher.include((PortletRequest)request, (PortletResponse)response);
                this.assertParameterMap(eventParams, (PortletRequest)request);
                response.setRenderParameter("key1", "k1rendervalue");
                response.setRenderParameter("key3", "k3rendervalue");
            }
        });
        seq.bindAction(1, UTS2.SERVICE_JOIN_POINT, (TestAction)new ServletServiceTestAction(this){

            protected Response run(Servlet servlet, HttpServletRequest request, HttpServletResponse response, PortletTestContext context) throws ServletException, IOException {
                Assert.assertEquals((Object[])new String[]{"k1value1"}, (Object[])request.getParameterValues("key1"));
                Assert.assertEquals((Object[])new String[]{"k2value1"}, (Object[])request.getParameterValues("key2"));
                Assert.assertEquals(null, (Object[])request.getParameterValues("key3"));
                return null;
            }
        });
        seq.bindAction(1, UTP1.RENDER_JOIN_POINT, (TestAction)new PortletRenderTestAction(this){

            protected Response run(Portlet portlet, RenderRequest request, RenderResponse response, PortletTestContext context) throws IOException, PortletException {
                HashMap<String, String[]> renderParams = new HashMap<String, String[]>();
                renderParams.put("key1", new String[]{"k1rendervalue"});
                renderParams.put("key3", new String[]{"k3rendervalue"});
                this.assertParameterMap(renderParams, (PortletRequest)request);
                String path = "/universalServletC?key1=k1value1&key2=k2value1";
                PortletRequestDispatcher dispatcher = ((AbstractUniversalTestPortlet)portlet).getPortletContext().getRequestDispatcher(path);
                dispatcher.include(request, response);
                this.assertParameterMap(renderParams, (PortletRequest)request);
                ResourceURL resourceURL = response.createResourceURL();
                resourceURL.setParameter("key1", "k1resourcevalue");
                resourceURL.setParameter("key3", "k3resourcevalue");
                return new InvokeGetResponse(resourceURL.toString());
            }
        });
        seq.bindAction(1, UTS3.SERVICE_JOIN_POINT, (TestAction)new ServletServiceTestAction(this){

            protected Response run(Servlet servlet, HttpServletRequest request, HttpServletResponse response, PortletTestContext context) throws ServletException, IOException {
                Assert.assertEquals((Object[])new String[]{"k1value1", "k1rendervalue"}, (Object[])request.getParameterValues("key1"));
                Assert.assertEquals((Object[])new String[]{"k2value1"}, (Object[])request.getParameterValues("key2"));
                Assert.assertEquals((Object[])new String[]{"k3rendervalue"}, (Object[])request.getParameterValues("key3"));
                return null;
            }
        });
        seq.bindAction(2, UTP1.RESOURCE_JOIN_POINT, (TestAction)new PortletResourceTestAction(this){

            protected Response run(Portlet portlet, ResourceRequest request, ResourceResponse response, PortletTestContext context) throws PortletException, IOException {
                HashMap<String, String[]> resourceParams = new HashMap<String, String[]>();
                resourceParams.put("key1", new String[]{"k1resourcevalue", "k1rendervalue"});
                resourceParams.put("key3", new String[]{"k3resourcevalue", "k3rendervalue"});
                this.assertParameterMap(resourceParams, (PortletRequest)request);
                String path = "/universalServletD?key1=k1value1&key2=k2value1";
                PortletRequestDispatcher dispatcher = ((AbstractUniversalTestPortlet)portlet).getPortletContext().getRequestDispatcher(path);
                dispatcher.include((PortletRequest)request, (PortletResponse)response);
                this.assertParameterMap(resourceParams, (PortletRequest)request);
                return new EndTestResponse();
            }
        });
        seq.bindAction(2, UTS4.SERVICE_JOIN_POINT, (TestAction)new ServletServiceTestAction(this){

            protected Response run(Servlet servlet, HttpServletRequest request, HttpServletResponse response, PortletTestContext context) throws ServletException, IOException {
                Assert.assertEquals((Object[])new String[]{"k1value1", "k1resourcevalue", "k1rendervalue"}, (Object[])request.getParameterValues("key1"));
                Assert.assertEquals((Object[])new String[]{"k2value1"}, (Object[])request.getParameterValues("key2"));
                Assert.assertEquals((Object[])new String[]{"k3resourcevalue", "k3rendervalue"}, (Object[])request.getParameterValues("key3"));
                return null;
            }
        });
    }
}

