/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.test.portlet.session;

import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import javax.portlet.Portlet;
import javax.portlet.PortletSession;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.gatein.common.util.Tools;
import org.gatein.pc.test.portlet.session.MutableValue;
import org.gatein.pc.test.unit.Assert;
import org.gatein.pc.test.unit.PortletTestCase;
import org.gatein.pc.test.unit.PortletTestContext;
import org.gatein.pc.test.unit.TestAction;
import org.gatein.pc.test.unit.actions.PortletRenderTestAction;
import org.gatein.pc.test.unit.annotations.TestCase;
import org.gatein.pc.test.unit.protocol.response.EndTestResponse;
import org.gatein.pc.test.unit.protocol.response.InvokeGetResponse;
import org.gatein.pc.test.unit.protocol.response.Response;
import org.gatein.pc.test.unit.web.UTP1;

@TestCase(enabled=false)
public class TestModifyExistingAttributeWithoutExplicitSetDoesNotReplicate {
    public TestModifyExistingAttributeWithoutExplicitSetDoesNotReplicate(PortletTestCase seq) {
        seq.bindAction(0, UTP1.RENDER_JOIN_POINT, (TestAction)new PortletRenderTestAction(this){

            protected Response run(Portlet portlet, RenderRequest request, RenderResponse response, PortletTestContext context) throws IOException {
                Assert.assertNull((Object)request.getPortletSession(false));
                PortletSession session = request.getPortletSession();
                Assert.assertNotNull((Object)session);
                Assert.assertEquals((Object)Collections.EMPTY_LIST, (Object)Tools.toList((Enumeration)session.getAttributeNames()));
                MutableValue value = new MutableValue("abcdef");
                session.setAttribute("mutable", (Object)value);
                PortletURL portletURL = response.createRenderURL();
                String url = portletURL.toString();
                return new InvokeGetResponse(url);
            }
        });
        seq.bindAction(1, UTP1.RENDER_JOIN_POINT, (TestAction)new PortletRenderTestAction(this){

            protected Response run(Portlet portlet, RenderRequest request, RenderResponse response, PortletTestContext context) throws IOException {
                PortletSession session = request.getPortletSession();
                Assert.assertEquals(Collections.singletonList("mutable"), (Object)Tools.toList((Enumeration)session.getAttributeNames()));
                Object o = session.getAttribute("mutable");
                Assert.assertNotNull((Object)o);
                Assert.assertEquals(MutableValue.class, o.getClass());
                MutableValue value = (MutableValue)o;
                value.setString("fedcba");
                PortletURL portletURL = response.createRenderURL();
                String url = context.rewriteURLForNode(portletURL.toString());
                return new InvokeGetResponse(url);
            }
        });
        seq.bindAction(2, UTP1.RENDER_JOIN_POINT, (TestAction)new PortletRenderTestAction(this){

            protected Response run(Portlet portlet, RenderRequest request, RenderResponse response, PortletTestContext context) {
                PortletSession session = request.getPortletSession();
                Assert.assertNotNull((Object)session);
                Assert.assertEquals(Collections.singletonList("mutable"), (Object)Tools.toList((Enumeration)session.getAttributeNames()));
                Assert.assertEquals((Object)new MutableValue("abcdef"), (Object)session.getAttribute("mutable"));
                return new EndTestResponse();
            }
        });
    }
}

