/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.test.controller;

import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;
import org.gatein.common.util.MultiValuedPropertyMap;
import org.gatein.pc.api.invocation.response.ResponseProperties;
import org.gatein.pc.test.controller.Renderer;
import org.gatein.pc.test.controller.RendererContext;

public abstract class AbstractMarkupRenderer
implements Renderer {
    protected ResponseProperties properties;

    public AbstractMarkupRenderer(ResponseProperties properties) {
        this.properties = properties;
    }

    @Override
    public void render(RendererContext context) throws IOException {
        this.prepareRendering(context);
        HttpServletResponse resp = context.getClientResponse();
        if (this.properties != null) {
            this.renderTransportHeaders(this.properties, resp);
            this.renderCookies(this.properties, resp);
        }
        this.renderContent(resp);
    }

    protected abstract void renderContent(HttpServletResponse var1) throws IOException;

    private void renderCookies(ResponseProperties pageProperties, HttpServletResponse resp) {
        List cookies = pageProperties.getCookies();
        for (Cookie cookie : cookies) {
            resp.addCookie(cookie);
        }
    }

    private void renderTransportHeaders(ResponseProperties pageProperties, HttpServletResponse resp) {
        MultiValuedPropertyMap transportHeaders = pageProperties.getTransportHeaders();
        for (String headerName : transportHeaders.keySet()) {
            for (String headerValue : transportHeaders.getValues(headerName)) {
                resp.addHeader(headerName, headerValue);
            }
        }
    }

    protected void prepareRendering(RendererContext context) {
    }
}

