/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.test.portlet.jsr286.tck.portletrequests;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.EventRequest;
import javax.portlet.EventResponse;
import javax.portlet.Portlet;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.portlet.ResourceURL;
import org.gatein.pc.test.unit.Assert;
import org.gatein.pc.test.unit.Assertion;
import org.gatein.pc.test.unit.PortletTestCase;
import org.gatein.pc.test.unit.PortletTestContext;
import org.gatein.pc.test.unit.TestAction;
import org.gatein.pc.test.unit.actions.PortletActionTestAction;
import org.gatein.pc.test.unit.actions.PortletEventTestAction;
import org.gatein.pc.test.unit.actions.PortletRenderTestAction;
import org.gatein.pc.test.unit.actions.PortletResourceTestAction;
import org.gatein.pc.test.unit.annotations.TestCase;
import org.gatein.pc.test.unit.protocol.Body;
import org.gatein.pc.test.unit.protocol.response.EndTestResponse;
import org.gatein.pc.test.unit.protocol.response.InvokeGetResponse;
import org.gatein.pc.test.unit.protocol.response.InvokePostResponse;
import org.gatein.pc.test.unit.protocol.response.Response;
import org.gatein.pc.test.unit.web.UTP5;

@TestCase(value={Assertion.JSR168_84, Assertion.JSR168_85, Assertion.JSR168_86})
public class PublicRenderParameterAvailableInLifeCycleMethod {
    private Map<String, String[]> expectedClientDataMap = new HashMap<String, String[]>();
    private Map<String, String[]> expectedClientDataPrivateMap;
    private Map<String, String[]> expectedPublicMap;

    public PublicRenderParameterAvailableInLifeCycleMethod(PortletTestCase seq) {
        this.expectedClientDataMap.put("foo", new String[]{"foo_value1", "foo_value2"});
        this.expectedClientDataMap.put("bar", new String[]{"is_bar_value1", "is_bar_value2", "bar_value1", "bar_value2"});
        this.expectedClientDataMap.put("juu", new String[]{"form_juu_value1", "form_juu_value2", "juu_value1", "juu_value2"});
        this.expectedClientDataMap.put("daa", new String[]{"is_daa_value1", "is_daa_value2", "form_daa_value1", "form_daa_value2", "daa_value1", "daa_value2"});
        this.expectedClientDataPrivateMap = new HashMap<String, String[]>();
        this.expectedClientDataPrivateMap.put("bar", new String[]{"is_bar_value1", "is_bar_value2"});
        this.expectedClientDataPrivateMap.put("juu", new String[]{"form_juu_value1", "form_juu_value2"});
        this.expectedClientDataPrivateMap.put("daa", new String[]{"is_daa_value1", "is_daa_value2", "form_daa_value1", "form_daa_value2"});
        this.expectedPublicMap = new HashMap<String, String[]>();
        this.expectedPublicMap.put("foo", new String[]{"foo_value1", "foo_value2"});
        this.expectedPublicMap.put("bar", new String[]{"bar_value1", "bar_value2"});
        this.expectedPublicMap.put("juu", new String[]{"juu_value1", "juu_value2"});
        this.expectedPublicMap.put("daa", new String[]{"daa_value1", "daa_value2"});
        seq.bindAction(0, UTP5.RENDER_JOIN_POINT, (TestAction)new PortletRenderTestAction(this){

            protected Response run(Portlet portlet, RenderRequest request, RenderResponse response, PortletTestContext context) {
                PortletURL renderURL = response.createRenderURL();
                renderURL.setParameter("foo", new String[]{"foo_value1", "foo_value2"});
                renderURL.setParameter("bar", new String[]{"bar_value1", "bar_value2"});
                renderURL.setParameter("juu", new String[]{"juu_value1", "juu_value2"});
                renderURL.setParameter("daa", new String[]{"daa_value1", "daa_value2"});
                return new InvokeGetResponse(renderURL.toString());
            }
        });
        seq.bindAction(1, UTP5.RENDER_JOIN_POINT, (TestAction)new PortletRenderTestAction(this){

            protected Response run(Portlet portlet, RenderRequest request, RenderResponse response, PortletTestContext context) {
                PortletURL actionURL = response.createActionURL();
                actionURL.setParameter("bar", new String[]{"is_bar_value1", "is_bar_value2"});
                actionURL.setParameter("daa", new String[]{"is_daa_value1", "is_daa_value2"});
                InvokePostResponse post = new InvokePostResponse(actionURL.toString());
                Body.Form form = new Body.Form();
                form.addParameter("juu", new String[]{"form_juu_value1", "form_juu_value2"});
                form.addParameter("daa", new String[]{"form_daa_value1", "form_daa_value2"});
                post.setBody((Body)form);
                return post;
            }
        });
        seq.bindAction(2, UTP5.ACTION_JOIN_POINT, (TestAction)new PortletActionTestAction(){

            protected void run(Portlet portlet, ActionRequest request, ActionResponse response, PortletTestContext context) throws PortletException, IOException {
                this.assertParameterMap(PublicRenderParameterAvailableInLifeCycleMethod.this.expectedClientDataMap, (PortletRequest)request);
                Assert.assertEquals(PublicRenderParameterAvailableInLifeCycleMethod.this.expectedClientDataPrivateMap, (Object)request.getPrivateParameterMap());
                Assert.assertEquals(PublicRenderParameterAvailableInLifeCycleMethod.this.expectedPublicMap, (Object)request.getPublicParameterMap());
                response.setEvent("Event", null);
            }
        });
        seq.bindAction(2, UTP5.EVENT_JOIN_POINT, (TestAction)new PortletEventTestAction(){

            protected void run(Portlet portlet, EventRequest request, EventResponse response, PortletTestContext context) throws PortletException, IOException {
                this.assertParameterMap(PublicRenderParameterAvailableInLifeCycleMethod.this.expectedPublicMap, (PortletRequest)request);
                Assert.assertEquals(Collections.emptyMap(), (Object)request.getPrivateParameterMap());
                Assert.assertEquals(PublicRenderParameterAvailableInLifeCycleMethod.this.expectedPublicMap, (Object)request.getPublicParameterMap());
            }
        });
        seq.bindAction(2, UTP5.RENDER_JOIN_POINT, (TestAction)new PortletRenderTestAction(){

            protected Response run(Portlet portlet, RenderRequest request, RenderResponse response, PortletTestContext context) {
                this.assertParameterMap(PublicRenderParameterAvailableInLifeCycleMethod.this.expectedPublicMap, (PortletRequest)request);
                Assert.assertEquals(Collections.emptyMap(), (Object)request.getPrivateParameterMap());
                Assert.assertEquals(PublicRenderParameterAvailableInLifeCycleMethod.this.expectedPublicMap, (Object)request.getPublicParameterMap());
                ResourceURL resourceURL = response.createResourceURL();
                resourceURL.setParameter("bar", new String[]{"is_bar_value1", "is_bar_value2"});
                resourceURL.setParameter("daa", new String[]{"is_daa_value1", "is_daa_value2"});
                InvokePostResponse post = new InvokePostResponse(resourceURL.toString());
                Body.Form form = new Body.Form();
                form.addParameter("juu", new String[]{"form_juu_value1", "form_juu_value2"});
                form.addParameter("daa", new String[]{"form_daa_value1", "form_daa_value2"});
                post.setBody((Body)form);
                return post;
            }
        });
        seq.bindAction(3, UTP5.RESOURCE_JOIN_POINT, (TestAction)new PortletResourceTestAction(){

            protected Response run(Portlet portlet, ResourceRequest request, ResourceResponse response, PortletTestContext context) throws PortletException, IOException {
                this.assertParameterMap(PublicRenderParameterAvailableInLifeCycleMethod.this.expectedClientDataMap, (PortletRequest)request);
                Assert.assertEquals(PublicRenderParameterAvailableInLifeCycleMethod.this.expectedClientDataPrivateMap, (Object)request.getPrivateParameterMap());
                Assert.assertEquals(PublicRenderParameterAvailableInLifeCycleMethod.this.expectedPublicMap, (Object)request.getPublicParameterMap());
                return new EndTestResponse();
            }
        });
    }
}

