/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.test.unit.protocol;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.HashMap;
import org.gatein.common.io.IOTools;
import org.gatein.pc.test.unit.PortletTestCase;
import org.gatein.pc.test.unit.PortletTestContext;
import org.gatein.pc.test.unit.PortletTestServlet;
import org.gatein.pc.test.unit.protocol.DriverContext;
import org.gatein.pc.test.unit.protocol.response.Response;

public class DriverServlet
extends HttpServlet {
    private static PortletTestContext context;

    public static PortletTestContext getPortletTestContext() {
        return context;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Response response = context.getResponse();
        if (response != null) {
            resp.setStatus(200);
            IOTools.copy((InputStream)new ByteArrayInputStream(IOTools.serialize((Serializable)response)), (OutputStream)resp.getOutputStream());
        } else {
            resp.setStatus(404);
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        HashMap payload;
        String step;
        String testName;
        try {
            testName = req.getParameter("test");
            step = req.getParameter("step");
            byte[] body = IOTools.getBytes((InputStream)req.getInputStream());
            payload = (HashMap)IOTools.unserialize((byte[])body, (ClassLoader)Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new ServletException((Throwable)e);
        }
        DriverContext ctx = new DriverContext(Integer.parseInt(step), payload);
        PortletTestCase testCase = PortletTestServlet.getTestCase(testName);
        context = new PortletTestContext(testName, testCase, ctx);
        resp.setStatus(200);
    }
}

