/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.test;

import org.gatein.pc.test.StringCodec;
import org.gatein.pc.test.unit.Assert;
import org.junit.Test;

public class StringCodecTestCase {
    private static final char EURO_CHAR = '\u20ac';

    @Test
    public void testA() {
        Assert.assertEquals("ABCDEFGHIJKLMNOPQRSTUVWXYZ", StringCodec.encode("ABCDEFGHIJKLMNOPQRSTUVWXYZ"));
        Assert.assertEquals("abcdefghijklmnopqrstuvwxyz", StringCodec.encode("abcdefghijklmnopqrstuvwxyz"));
        Assert.assertEquals("0123456789", StringCodec.encode("0123456789"));
        Assert.assertEquals("_2F", StringCodec.encode("/"));
        Assert.assertEquals("_40", StringCodec.encode("@"));
        Assert.assertEquals("_E2_82_AC", StringCodec.encode(Character.toString('\u20ac')));
        Assert.assertEquals("A_E2_82_ACB_40C", StringCodec.encode("A\u20acB@C"));
    }

    @Test
    public void testB() {
        Assert.assertEquals("ABCDEFGHIJKLMNOPQRSTUVWXYZ", StringCodec.decode(StringCodec.encode("ABCDEFGHIJKLMNOPQRSTUVWXYZ")));
        Assert.assertEquals("abcdefghijklmnopqrstuvwxyz", StringCodec.decode(StringCodec.encode("abcdefghijklmnopqrstuvwxyz")));
        Assert.assertEquals("0123456789", StringCodec.decode(StringCodec.encode("0123456789")));
        Assert.assertEquals("/", StringCodec.decode(StringCodec.encode("/")));
        Assert.assertEquals("@", StringCodec.decode(StringCodec.encode("@")));
        Assert.assertEquals(Character.toString('\u20ac'), StringCodec.decode(StringCodec.encode(Character.toString('\u20ac'))));
        Assert.assertEquals("A\u20acB@C", StringCodec.decode(StringCodec.encode("A\u20acB@C")));
    }
}

