/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.test.controller.unit;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.gatein.common.io.Serialization;
import org.gatein.pc.api.Mode;
import org.gatein.pc.api.StateString;
import org.gatein.pc.api.WindowState;
import org.gatein.pc.controller.state.PageNavigationalState;
import org.gatein.pc.controller.state.StateControllerContext;
import org.gatein.pc.controller.state.WindowNavigationalState;

public class PageNavigationalStateSerialization
implements Serialization<PageNavigationalState> {
    private static final Map<WindowState, Integer> windowStateToCode = new HashMap<WindowState, Integer>();
    private static final Map<Mode, Integer> modeToCode = new HashMap<Mode, Integer>();
    private static final Map<Integer, WindowState> codeToWindowState = new HashMap<Integer, WindowState>();
    private static final Map<Integer, Mode> codeToMode = new HashMap<Integer, Mode>();
    private final StateControllerContext context;

    public PageNavigationalStateSerialization(StateControllerContext context) {
        if (context == null) {
            throw new IllegalArgumentException();
        }
        this.context = context;
    }

    public void serialize(PageNavigationalState pageNavigationalState, OutputStream out) throws IOException, IllegalArgumentException {
        DataOutputStream data = out instanceof DataOutputStream ? (DataOutputStream)out : new DataOutputStream(out);
        data.writeInt(pageNavigationalState.getWindowIds().size());
        for (String windowId : pageNavigationalState.getWindowIds()) {
            Integer value;
            data.writeUTF(windowId);
            WindowNavigationalState windowNS = pageNavigationalState.getWindowNavigationalState(windowId);
            byte header = 0;
            int decision = 0;
            if (windowNS.getPortletNavigationalState() != null) {
                header = (byte)(header | 1);
                decision |= 1;
            }
            if (windowNS.getWindowState() != null) {
                value = windowStateToCode.get(windowNS.getWindowState());
                if (value != null) {
                    header = (byte)(header | value << 1);
                } else {
                    header = (byte)(header | 8);
                    decision |= 2;
                }
            }
            if (windowNS.getMode() != null) {
                value = modeToCode.get(windowNS.getMode());
                if (value != null) {
                    header = (byte)(header | value << 4);
                } else {
                    header = (byte)(header | 0x40);
                    decision |= 4;
                }
            }
            data.writeByte(header);
            if (decision & true) {
                windowNS.getPortletNavigationalState().writeTo(data);
            }
            if ((decision & 2) != 0) {
                data.writeUTF(windowNS.getWindowState().toString());
            }
            if ((decision & 4) == 0) continue;
            data.writeUTF(windowNS.getMode().toString());
        }
        Set publicNames = pageNavigationalState.getPublicNames();
        data.writeInt(publicNames.size());
        for (QName name : pageNavigationalState.getPublicNames()) {
            data.writeUTF(name.getNamespaceURI());
            data.writeUTF(name.getLocalPart());
            String[] values = pageNavigationalState.getPublicNavigationalState(name);
            int length = values.length;
            data.writeInt(length);
            for (String value : values) {
                data.writeUTF(value);
            }
        }
        data.flush();
    }

    public PageNavigationalState unserialize(InputStream in) throws IOException, IllegalArgumentException {
        DataInputStream data = in instanceof DataInputStream ? (DataInputStream)in : new DataInputStream(in);
        PageNavigationalState pageNS = new PageNavigationalState(true);
        int size = data.readInt();
        while (size-- > 0) {
            String windowId = data.readUTF();
            byte header = data.readByte();
            StateString portletNS = null;
            if ((header & 1) != 0) {
                portletNS = StateString.create((DataInputStream)data);
            }
            WindowState windowState = null;
            int windowStateHeader = (header & 0xE) >> 1;
            switch (windowStateHeader) {
                case 0: {
                    break;
                }
                case 4: {
                    windowState = WindowState.create((String)data.readUTF());
                    break;
                }
                default: {
                    windowState = codeToWindowState.get(windowStateHeader);
                }
            }
            Mode mode = null;
            int modeStateHeader = (header & 0x70) >> 4;
            switch (modeStateHeader) {
                case 0: {
                    break;
                }
                case 4: {
                    mode = Mode.create((String)data.readUTF());
                    break;
                }
                default: {
                    mode = codeToMode.get(modeStateHeader);
                }
            }
            WindowNavigationalState windowNS = new WindowNavigationalState(portletNS, mode, windowState);
            pageNS.setWindowNavigationalState(windowId, windowNS);
        }
        size = data.readInt();
        while (size-- > 0) {
            String namespaceURI = data.readUTF();
            String localName = data.readUTF();
            QName name = new QName(namespaceURI, localName);
            int length = data.readInt();
            String[] values = new String[length];
            for (int i = 0; i < length; ++i) {
                values[i] = data.readUTF();
            }
            pageNS.setPublicNavigationalState(name, values);
        }
        return pageNS;
    }

    static {
        windowStateToCode.put(WindowState.NORMAL, 1);
        windowStateToCode.put(WindowState.MINIMIZED, 2);
        windowStateToCode.put(WindowState.MAXIMIZED, 3);
        codeToWindowState.put(1, WindowState.NORMAL);
        codeToWindowState.put(2, WindowState.MINIMIZED);
        codeToWindowState.put(3, WindowState.MAXIMIZED);
        modeToCode.put(Mode.VIEW, 1);
        modeToCode.put(Mode.EDIT, 2);
        modeToCode.put(Mode.HELP, 3);
        codeToMode.put(1, Mode.VIEW);
        codeToMode.put(2, Mode.EDIT);
        codeToMode.put(3, Mode.HELP);
    }
}

