/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.test.portlet.jsr286.tck.stateawareresponse;

import java.io.IOException;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.EventRequest;
import javax.portlet.EventResponse;
import javax.portlet.Portlet;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.gatein.pc.test.unit.Assert;
import org.gatein.pc.test.unit.Assertion;
import org.gatein.pc.test.unit.PortletTestCase;
import org.gatein.pc.test.unit.PortletTestContext;
import org.gatein.pc.test.unit.TestAction;
import org.gatein.pc.test.unit.actions.PortletActionTestAction;
import org.gatein.pc.test.unit.actions.PortletEventTestAction;
import org.gatein.pc.test.unit.actions.PortletRenderTestAction;
import org.gatein.pc.test.unit.annotations.TestCase;
import org.gatein.pc.test.unit.protocol.response.EndTestResponse;
import org.gatein.pc.test.unit.protocol.response.InvokeGetResponse;
import org.gatein.pc.test.unit.protocol.response.Response;
import org.gatein.pc.test.unit.web.UTP1;

@TestCase(value={Assertion.JSR286_103})
public class SetRenderParameters {
    public SetRenderParameters(PortletTestCase seq) {
        seq.bindAction(0, UTP1.RENDER_JOIN_POINT, (TestAction)new PortletRenderTestAction(this){

            protected Response run(Portlet portlet, RenderRequest request, RenderResponse response, PortletTestContext context) {
                return new InvokeGetResponse(response.createActionURL().toString());
            }
        });
        seq.bindAction(1, UTP1.ACTION_JOIN_POINT, (TestAction)new PortletActionTestAction(this){

            protected void run(Portlet portlet, ActionRequest request, ActionResponse response, PortletTestContext context) throws PortletException, IOException {
                response.setRenderParameter("foo", "fooaction1");
            }
        });
        seq.bindAction(1, UTP1.RENDER_JOIN_POINT, (TestAction)new PortletRenderTestAction(){

            protected Response run(Portlet portlet, RenderRequest request, RenderResponse response, PortletTestContext context) {
                SetRenderParameters.this.assertRenderParameter((PortletRequest)request, "foo", "fooaction1");
                return new InvokeGetResponse(response.createActionURL().toString());
            }
        });
        seq.bindAction(2, UTP1.ACTION_JOIN_POINT, (TestAction)new PortletActionTestAction(this){

            protected void run(Portlet portlet, ActionRequest request, ActionResponse response, PortletTestContext context) throws PortletException, IOException {
                response.setRenderParameter("foo", "fooaction2");
                response.setEvent("Foo", null);
            }
        });
        seq.bindAction(2, UTP1.EVENT_JOIN_POINT, (TestAction)new PortletEventTestAction(){

            protected void run(Portlet portlet, EventRequest request, EventResponse response, PortletTestContext context) throws PortletException, IOException {
                if ("Foo".equals(request.getEvent().getName())) {
                    SetRenderParameters.this.assertRenderParameter((PortletRequest)request, "foo", "fooaction2");
                    response.setRenderParameter("foo", "fooevent1");
                } else {
                    Assert.fail();
                }
            }
        });
        seq.bindAction(2, UTP1.RENDER_JOIN_POINT, (TestAction)new PortletRenderTestAction(){

            protected Response run(Portlet portlet, RenderRequest request, RenderResponse response, PortletTestContext context) {
                SetRenderParameters.this.assertRenderParameter((PortletRequest)request, "foo", "fooevent1");
                return new InvokeGetResponse(response.createActionURL().toString());
            }
        });
        seq.bindAction(3, UTP1.ACTION_JOIN_POINT, (TestAction)new PortletActionTestAction(this){

            protected void run(Portlet portlet, ActionRequest request, ActionResponse response, PortletTestContext context) throws PortletException, IOException {
                response.setRenderParameter("foo", "fooaction3");
                response.setEvent("Foo", null);
            }
        });
        seq.bindAction(3, UTP1.EVENT_JOIN_POINT, (TestAction)new PortletEventTestAction(){

            protected void run(Portlet portlet, EventRequest request, EventResponse response, PortletTestContext context) throws PortletException, IOException {
                String eventName = request.getEvent().getName();
                if ("Foo".equals(eventName)) {
                    SetRenderParameters.this.assertRenderParameter((PortletRequest)request, "foo", "fooaction3");
                    response.setRenderParameter("foo", "fooevent2");
                    response.setEvent("Bar", null);
                } else if ("Bar".equals(eventName)) {
                    SetRenderParameters.this.assertRenderParameter((PortletRequest)request, "foo", "fooevent2");
                    response.setRenderParameter("foo", "fooevent3");
                } else {
                    Assert.fail();
                }
            }
        });
        seq.bindAction(3, UTP1.RENDER_JOIN_POINT, (TestAction)new PortletRenderTestAction(){

            protected Response run(Portlet portlet, RenderRequest request, RenderResponse response, PortletTestContext context) {
                SetRenderParameters.this.assertRenderParameter((PortletRequest)request, "foo", "fooevent3");
                return new EndTestResponse();
            }
        });
    }

    private void assertRenderParameter(PortletRequest request, String name, String value) {
        Assert.assertEquals((Object)1, (Object)request.getParameterMap().size());
        Assert.assertTrue((boolean)request.getParameterMap().containsKey(name));
        Assert.assertEquals((Object[])new String[]{value}, (Object[])((Object[])request.getParameterMap().get(name)));
        Assert.assertEquals((Object)value, (Object)request.getParameter(name));
        Assert.assertEquals((Object[])new String[]{value}, (Object[])request.getParameterValues(name));
    }
}

