/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.test.unit.actions;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import javax.portlet.Portlet;
import javax.portlet.PortletException;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import org.gatein.common.NotYetImplemented;
import org.gatein.common.io.IOTools;
import org.gatein.pc.test.unit.Failure;
import org.gatein.pc.test.unit.PortletTestContext;
import org.gatein.pc.test.unit.TestAction;
import org.gatein.pc.test.unit.protocol.response.FailureResponse;
import org.gatein.pc.test.unit.protocol.response.Response;

public abstract class PortletResourceTestAction
extends TestAction {
    private final boolean attemptToSendResponse;

    protected PortletResourceTestAction(boolean attemptToSendResponse) {
        this.attemptToSendResponse = attemptToSendResponse;
    }

    protected PortletResourceTestAction() {
        this(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Response execute(Portlet portlet, ResourceRequest request, ResourceResponse response, PortletTestContext context) throws PortletException, IOException {
        boolean sendResponse = false;
        try {
            Response driverResponse = this.runWithRuntimeException(portlet, request, response, context);
            sendResponse = this.attemptToSendResponse;
            Response response2 = driverResponse;
            return response2;
        }
        catch (AssertionError t) {
            this.getLogger().error((Object)"The test case failed", (Throwable)((Object)t));
            sendResponse = this.attemptToSendResponse;
            FailureResponse failureResponse = new FailureResponse(Failure.createFailure((Throwable)((Object)t)));
            return failureResponse;
        }
        finally {
            if (sendResponse) {
                if (response.getContentType() == null) {
                    response.setContentType("text/html");
                }
                boolean gotWriter = false;
                try {
                    PrintWriter writer = response.getWriter();
                    gotWriter = true;
                    IOTools.safeClose((Closeable)writer);
                }
                catch (IllegalStateException writer) {}
                if (!gotWriter) {
                    try {
                        OutputStream out = response.getPortletOutputStream();
                        IOTools.safeClose((Closeable)out);
                    }
                    catch (IllegalStateException illegalStateException) {
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    protected Response runWithRuntimeException(Portlet portlet, ResourceRequest request, ResourceResponse response, PortletTestContext context) throws PortletException, IOException {
        try {
            return this.run(portlet, request, response, context);
        }
        catch (Exception e) {
            if (e instanceof PortletException) {
                throw (PortletException)e;
            }
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new AssertionError((Object)e);
        }
    }

    protected Response run(Portlet portlet, ResourceRequest request, ResourceResponse response, PortletTestContext context) throws PortletException, IOException {
        throw new NotYetImplemented();
    }
}

