/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.test.portlet.jsr286.tck.dispatcher;

import jakarta.servlet.ServletContext;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.PortletResponse;
import org.gatein.pc.test.portlet.jsr286.tck.dispatcher.DispatchedContainerAttributes;
import org.gatein.pc.test.unit.Assertion;
import org.gatein.pc.test.unit.PortletTestCase;
import org.gatein.pc.test.unit.annotations.TestCase;

@TestCase(value={Assertion.JSR286_239})
public class RFContainerAttributes
extends DispatchedContainerAttributes {
    private static Map<String, String> buildAttributes(ServletContext ctx) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("jakarta.servlet.forward.request_uri", ctx.getContextPath() + "/universalServletA/pathinfo");
        map.put("jakarta.servlet.forward.context_path", ctx.getContextPath());
        map.put("jakarta.servlet.forward.servlet_path", "/universalServletA");
        map.put("jakarta.servlet.forward.path_info", "/pathinfo");
        map.put("jakarta.servlet.forward.query_string", "foo=bar");
        map.put("jakarta.servlet.include.request_uri", null);
        map.put("jakarta.servlet.include.context_path", null);
        map.put("jakarta.servlet.include.servlet_path", null);
        map.put("jakarta.servlet.include.path_info", null);
        map.put("jakarta.servlet.include.query_string", null);
        return Collections.unmodifiableMap(map);
    }

    private static Map<String, String> buildInfo(ServletContext ctx) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("request_uri", ctx.getContextPath() + "/universalServletA/pathinfo");
        map.put("context_path", ctx.getContextPath());
        map.put("servlet_path", "/universalServletA");
        map.put("path_info", "/pathinfo");
        map.put("query_string", "foo=bar");
        return Collections.unmodifiableMap(map);
    }

    public RFContainerAttributes(PortletTestCase seq) {
        super(seq, RFContainerAttributes.buildAttributes(seq.getContext()), RFContainerAttributes.buildInfo(seq.getContext()));
    }

    @Override
    protected void dispatch(PortletRequest request, PortletResponse response, PortletContext portletContext) throws IOException, PortletException {
        PortletRequestDispatcher dispatcher = portletContext.getRequestDispatcher("/universalServletA/pathinfo?foo=bar");
        dispatcher.forward(request, response);
    }
}

