/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.test;

import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;

public class StringCodec {
    private static char[] blah = "0123456789ABCDEF".toCharArray();

    public static String encode(String decodedValue) {
        try {
            StringBuffer buffer = new StringBuffer();
            char[] tmp = new char[1];
            for (int i = 0; i < decodedValue.length(); ++i) {
                byte[] bytes;
                char c = decodedValue.charAt(i);
                if (Character.isLetterOrDigit(c)) {
                    buffer.append(c);
                    continue;
                }
                tmp[0] = c;
                for (byte b : bytes = new String(tmp).getBytes("UTF8")) {
                    buffer.append('_').append(blah[(b & 0xF0) >> 4]).append(blah[b & 0xF]);
                }
            }
            return buffer.toString();
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException();
        }
    }

    public static String decode(String encodedValue) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(encodedValue.length());
            for (int i = 0; i < encodedValue.length(); ++i) {
                char c = encodedValue.charAt(i);
                if (Character.isLetterOrDigit(c)) {
                    baos.write(c);
                    continue;
                }
                if ('_' == c) {
                    if (i + 3 > encodedValue.length()) {
                        throw new IllegalArgumentException("There should be at least 2 chars after an _ char");
                    }
                    String hex = encodedValue.substring(i + 1, i + 3);
                    int x = Integer.parseInt(hex, 16);
                    baos.write(x);
                    i += 2;
                    continue;
                }
                throw new IllegalArgumentException("Invalid char " + c);
            }
            return baos.toString("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException();
        }
    }
}

