/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wci.test.authentication;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.LinkedList;
import org.gatein.wci.ServletContainer;
import org.gatein.wci.ServletContainerFactory;
import org.gatein.wci.authentication.AuthenticationEvent;
import org.gatein.wci.authentication.AuthenticationException;
import org.gatein.wci.authentication.AuthenticationListener;
import org.gatein.wci.security.Credentials;

public class AuthenticationServlet
extends HttpServlet {
    static int status = 0;
    static String remoteUser;
    ServletContainer sc;
    static LinkedList<AuthenticationEvent> authEvents;

    public void init() throws ServletException {
        this.sc = ServletContainerFactory.getServletContainer();
        this.sc.addAuthenticationListener(new AuthenticationListener(this){

            public void onEvent(AuthenticationEvent event) {
                authEvents.addLast(event);
            }
        });
    }

    public void destroy() {
        this.sc = null;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        switch (status) {
            case 0: {
                remoteUser = req.getRemoteUser();
                resp.setStatus(200);
                break;
            }
            case 1: {
                try {
                    this.sc.login(req, resp, new Credentials("foo", "foo"));
                    throw new ServletException("Was expecting an authentication exception");
                }
                catch (AuthenticationException authenticationException) {
                    resp.sendError(401);
                    break;
                }
            }
            case 2: {
                this.sc.login(req, resp, new Credentials("foo", "bar"));
                try {
                    this.sc.login(req, resp, new Credentials("foo", "bar"));
                    throw new ServletException("Was expecting authenticated login to throw IllegalStateException");
                }
                catch (IllegalStateException illegalStateException) {
                    remoteUser = req.getRemoteUser();
                    resp.setStatus(200);
                    resp.setContentType("text/plain");
                    resp.getWriter().write(this.getURL(req, resp));
                    break;
                }
            }
            case 3: {
                req.getSession();
                remoteUser = req.getRemoteUser();
                resp.setStatus(200);
                resp.setContentType("text/plain");
                resp.getWriter().write(this.getURL(req, resp));
                break;
            }
            case 4: {
                this.sc.logout(req, resp);
                try {
                    this.sc.logout(req, resp);
                    throw new ServletException("Was expecting unauthenticated logout to throw IllegalStateException");
                }
                catch (IllegalStateException illegalStateException) {
                    remoteUser = req.getRemoteUser();
                    resp.setStatus(200);
                    break;
                }
            }
            default: {
                throw new ServletException("Unexpected status");
            }
        }
    }

    private String getURL(HttpServletRequest req, HttpServletResponse resp) {
        return resp.encodeURL("http://" + req.getServerName() + ":" + req.getServerPort() + req.getContextPath());
    }

    static {
        authEvents = new LinkedList();
    }
}

