/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wci.test.requestdispatch;

import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.gatein.wci.RequestDispatchCallback;
import org.gatein.wci.ServletContextDispatcher;
import org.gatein.wci.test.requestdispatch.AbstractCallback;

public class NormalCallback
extends AbstractCallback {
    private final ServletContext expectedContext;
    private final ClassLoader expectedThreadContextClassLoader;
    private final Object expectedHandback;
    private final Object expectedReturnedValue;
    private Object handback;
    private ClassLoader threadContextClassLoader;
    private boolean invoked;

    public NormalCallback(ServletContext expectedContext, ClassLoader expectedThreadContextClassLoader) {
        this.expectedContext = expectedContext;
        this.expectedThreadContextClassLoader = expectedThreadContextClassLoader;
        this.expectedHandback = new Object();
        this.expectedReturnedValue = new Object();
        this.invoked = false;
        this.handback = null;
    }

    public Object doCallback(ServletContext dispatchedServletContext, HttpServletRequest dispatchedRequest, HttpServletResponse dispatchedResponse, Object handback) throws ServletException, IOException {
        this.invoked = true;
        this.threadContextClassLoader = Thread.currentThread().getContextClassLoader();
        this.handback = handback;
        return this.expectedReturnedValue;
    }

    @Override
    protected Throwable test(ServletContextDispatcher dispatcher) {
        try {
            Object returnedValue = dispatcher.include(this.expectedContext, (RequestDispatchCallback)this, this.expectedHandback);
            if (!this.invoked) {
                return new Exception("The callback was not invoked");
            }
            if (this.expectedHandback != this.handback) {
                return new Exception("The provided handback is not the same than the expected handback");
            }
            if (this.expectedReturnedValue != returnedValue) {
                return new Exception("The returned value is not the same than the expected one");
            }
            if (this.expectedThreadContextClassLoader != this.threadContextClassLoader) {
                return new Exception("The thread context class loader is not the same than the expected one");
            }
        }
        catch (Exception e) {
            return e;
        }
        return null;
    }
}

