/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.ide.service;

import io.meeds.ide.model.Widget;
import io.meeds.ide.service.WidgetService;
import io.meeds.ide.storage.WidgetStorage;
import io.meeds.layout.service.LayoutAclService;
import java.time.LocalDateTime;
import org.exoplatform.commons.ObjectAlreadyExistsException;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.verification.VerificationMode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;

@SpringBootTest(classes={WidgetService.class})
@ExtendWith(value={MockitoExtension.class})
public class WidgetServiceTest {
    private static final String USERNAME = "testUser";
    private static final String HTML_CONTENT = "...html...";
    private static final String CSS_CONTENT = "...css...";
    private static final String JS_CONTENT = "...js...";
    @MockBean
    private LayoutAclService layoutAclService;
    @MockBean
    private IdentityManager identityManager;
    @MockBean
    private ListenerService listenerService;
    @MockBean
    private WidgetStorage widgetStorage;
    @Autowired
    private WidgetService widgetService;
    @Mock
    private Widget widget;
    @Mock
    private Identity identity;

    @Test
    public void getWidget() throws ObjectNotFoundException {
        Assertions.assertThrows(ObjectNotFoundException.class, () -> this.widgetService.getWidget(2L));
        Mockito.when((Object)this.widgetStorage.getWidget(Long.valueOf(2L))).thenReturn((Object)this.widget);
        Assertions.assertEquals((Object)this.widget, (Object)this.widgetService.getWidget(2L));
    }

    @Test
    public void createWidget() throws ObjectAlreadyExistsException, IllegalAccessException {
        Assertions.assertThrows(IllegalAccessException.class, () -> this.widgetService.createWidget(this.widget, USERNAME));
        Mockito.when((Object)this.layoutAclService.isAdministrator(USERNAME)).thenReturn((Object)true);
        Mockito.when((Object)this.widget.getPortletId()).thenReturn((Object)3L);
        Mockito.when((Object)this.widgetStorage.existsByPortletInstanceId(Long.valueOf(3L))).thenReturn((Object)true);
        Assertions.assertThrows(ObjectAlreadyExistsException.class, () -> this.widgetService.createWidget(this.widget, USERNAME));
        Mockito.when((Object)this.widgetStorage.existsByPortletInstanceId(Long.valueOf(3L))).thenReturn((Object)false);
        Mockito.when((Object)this.identityManager.getOrCreateUserIdentity(USERNAME)).thenReturn((Object)this.identity);
        Mockito.when((Object)this.identity.getId()).thenReturn((Object)"5");
        Mockito.when((Object)this.widgetStorage.createWidget(this.widget)).thenReturn((Object)this.widget);
        Widget savedWidget = this.widgetService.createWidget(this.widget, USERNAME);
        Assertions.assertNotNull((Object)savedWidget);
        ((Widget)Mockito.verify((Object)this.widget)).setCreatorId(Long.valueOf(5L));
        ((Widget)Mockito.verify((Object)this.widget)).setModifierId(Long.valueOf(5L));
        ((Widget)Mockito.verify((Object)this.widget)).setCreatedDate((LocalDateTime)ArgumentMatchers.notNull());
        ((Widget)Mockito.verify((Object)this.widget)).setModifiedDate((LocalDateTime)ArgumentMatchers.notNull());
        ((WidgetStorage)Mockito.verify((Object)this.widgetStorage)).createWidget(this.widget);
        ((ListenerService)Mockito.verify((Object)this.listenerService)).broadcast("ide.widget.created", null, (Object)this.widget);
    }

    @Test
    public void updateWidget() throws ObjectNotFoundException, IllegalAccessException {
        Assertions.assertThrows(IllegalAccessException.class, () -> this.widgetService.updateWidget(this.widget, USERNAME));
        Mockito.when((Object)this.layoutAclService.isAdministrator(USERNAME)).thenReturn((Object)true);
        Mockito.when((Object)this.widget.getId()).thenReturn((Object)2L);
        Mockito.when((Object)this.widget.getHtml()).thenReturn((Object)HTML_CONTENT);
        Mockito.when((Object)this.widget.getCss()).thenReturn((Object)CSS_CONTENT);
        Mockito.when((Object)this.widget.getJs()).thenReturn((Object)JS_CONTENT);
        Mockito.when((Object)this.widgetStorage.getWidget(Long.valueOf(2L))).thenReturn(null);
        Assertions.assertThrows(ObjectNotFoundException.class, () -> this.widgetService.updateWidget(this.widget, USERNAME));
        Mockito.when((Object)this.widgetStorage.getWidget(Long.valueOf(2L))).thenReturn((Object)this.widget);
        Mockito.when((Object)this.identityManager.getOrCreateUserIdentity(USERNAME)).thenReturn((Object)this.identity);
        Mockito.when((Object)this.identity.getId()).thenReturn((Object)"5");
        Mockito.when((Object)this.widgetStorage.updateWidget(this.widget)).thenReturn((Object)this.widget);
        Widget savedWidget = this.widgetService.updateWidget(this.widget, USERNAME);
        Assertions.assertNotNull((Object)savedWidget);
        ((Widget)Mockito.verify((Object)this.widget)).setHtml(HTML_CONTENT);
        ((Widget)Mockito.verify((Object)this.widget)).setJs(JS_CONTENT);
        ((Widget)Mockito.verify((Object)this.widget)).setCss(CSS_CONTENT);
        ((Widget)Mockito.verify((Object)this.widget)).setModifierId(Long.valueOf(5L));
        ((Widget)Mockito.verify((Object)this.widget)).setModifiedDate((LocalDateTime)ArgumentMatchers.notNull());
        ((WidgetStorage)Mockito.verify((Object)this.widgetStorage)).updateWidget(this.widget);
        ((ListenerService)Mockito.verify((Object)this.listenerService)).broadcast("ide.widget.updated", null, (Object)this.widget);
    }

    @Test
    void deleteWidget() throws ObjectNotFoundException, IllegalAccessException {
        Assertions.assertThrows(IllegalAccessException.class, () -> this.widgetService.deleteWidget(6L, USERNAME));
        Mockito.when((Object)this.layoutAclService.isAdministrator(USERNAME)).thenReturn((Object)true);
        Mockito.when((Object)this.widgetStorage.getWidget(Long.valueOf(6L))).thenReturn((Object)this.widget);
        this.widgetService.deleteWidget(6L, USERNAME);
        ((WidgetStorage)Mockito.verify((Object)this.widgetStorage, (VerificationMode)Mockito.times((int)1))).deleteWidgetById(6L);
    }
}

