/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.utils;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import junit.framework.TestCase;
import org.exoplatform.commons.utils.IOUtil;

public class TestIOUtil
extends TestCase {
    public void testGetFileContentAsStringThrowsIllegalArgumentException() throws IOException {
        try {
            IOUtil.getFileContentAsString((File)null);
            TestIOUtil.fail((String)"Was expecting an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            IOUtil.getFileContentAsString((String)null);
            TestIOUtil.fail((String)"Was expecting an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            IOUtil.getFileContentAsString((File)null, (String)"UTF-8");
            TestIOUtil.fail((String)"Was expecting an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            IOUtil.getFileContentAsString((String)null, (String)"UTF-8");
            TestIOUtil.fail((String)"Was expecting an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testStreamContentAsStringThrowsIllegalArgumentException() throws IOException {
        try {
            IOUtil.getStreamContentAsString(null);
            TestIOUtil.fail((String)"Was expecting an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testStreamContentAsString() throws IOException {
        String s = IOUtil.getStreamContentAsString((InputStream)new ByteArrayInputStream("a\u1000".getBytes("UTF-8")));
        TestIOUtil.assertEquals((String)"a\u1000", (String)s);
    }

    public void testStreamContentAsBytesThrowsIllegalArgumentException() throws IOException {
        try {
            IOUtil.getStreamContentAsBytes(null);
            TestIOUtil.fail((String)"Was expecting an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testStreamContentAsBytes() throws IOException {
        byte[] bytes = IOUtil.getStreamContentAsBytes((InputStream)new ByteArrayInputStream("a\u1000".getBytes("UTF-8")));
        TestIOUtil.assertEquals((String)"a\u1000", (String)new String(bytes, "UTF-8"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetResourceAsString() throws IOException {
        ClassLoader newCL = TestIOUtil.class.getClassLoader();
        ClassLoader oldCL = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(newCL);
            String content = IOUtil.getResourceAsString((String)"Simple.properties");
            TestIOUtil.assertEquals((String)"resource_content", (String)content);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCL);
        }
    }

    public void testGetResourceAsStringThrowsIllegalArgumentException() throws IOException {
        try {
            IOUtil.getResourceAsString(null);
            TestIOUtil.fail((String)"Was expecting an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetResourceAsStringNotFound() throws IOException {
        ClassLoader newCL = new ClassLoader(this){

            @Override
            public URL getResource(String name) {
                return null;
            }
        };
        ClassLoader oldCL = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(newCL);
            IOUtil.getResourceAsString((String)"whatever");
            TestIOUtil.fail((String)"Was expecting an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCL);
        }
    }

    public void testGetStreamContentAsBytesWithErrorDuringClose() throws IOException {
        final Error er = new Error();
        ByteValueInputStream in = new ByteValueInputStream(this, 3){

            @Override
            public void close() throws IOException {
                super.close();
                throw er;
            }
        };
        try {
            IOUtil.getStreamContentAsBytes((InputStream)in);
            TestIOUtil.fail();
        }
        catch (Error e) {
            TestIOUtil.assertSame((Object)e, (Object)er);
        }
        TestIOUtil.assertTrue((boolean)in.closed);
    }

    public void testGetStreamContentAsBytesWithIOExceptionDuringClose() throws IOException {
        ByteValueInputStream in = new ByteValueInputStream(this, 3){

            @Override
            public void close() throws IOException {
                super.close();
                throw new RuntimeException();
            }
        };
        byte[] bytes = IOUtil.getStreamContentAsBytes((InputStream)in);
        TestIOUtil.assertNotNull((Object)bytes);
        TestIOUtil.assertEquals((int)1, (int)bytes.length);
        TestIOUtil.assertEquals((int)3, (int)bytes[0]);
        TestIOUtil.assertTrue((boolean)in.closed);
    }

    public void testGetStreamContentAsBytesWithIOExceptionDuringRead() throws IOException {
        final IOException ex = new IOException();
        ClosableInputStream in = new ClosableInputStream(this){

            @Override
            public int read() throws IOException {
                throw ex;
            }
        };
        try {
            IOUtil.getStreamContentAsBytes((InputStream)in);
        }
        catch (IOException e) {
            TestIOUtil.assertSame((Object)ex, (Object)e);
        }
        TestIOUtil.assertTrue((boolean)in.closed);
    }

    public void testGetStreamContentAsBytesWithRuntimeExceptionDuringRead() throws IOException {
        final RuntimeException ex = new RuntimeException();
        ClosableInputStream in = new ClosableInputStream(this){

            @Override
            public int read() throws IOException {
                throw ex;
            }
        };
        try {
            IOUtil.getStreamContentAsBytes((InputStream)in);
        }
        catch (RuntimeException e) {
            TestIOUtil.assertSame((Object)ex, (Object)e);
        }
        TestIOUtil.assertTrue((boolean)in.closed);
    }

    public void testGetStreamContentAsBytesWithRuntimeExceptionDuringClose() throws IOException {
        final RuntimeException ex = new RuntimeException();
        ClosableInputStream in = new ClosableInputStream(this){

            @Override
            public int read() throws IOException {
                throw ex;
            }
        };
        try {
            IOUtil.getStreamContentAsBytes((InputStream)in);
        }
        catch (RuntimeException e) {
            TestIOUtil.assertSame((Object)ex, (Object)e);
        }
        TestIOUtil.assertTrue((boolean)in.closed);
    }

    public void testGetStreamContentAsBytesWithErrorDuringRead() throws IOException {
        final Error er = new Error();
        ClosableInputStream in = new ClosableInputStream(this){

            @Override
            public int read() throws IOException {
                throw er;
            }
        };
        try {
            IOUtil.getStreamContentAsBytes((InputStream)in);
        }
        catch (Error e) {
            TestIOUtil.assertSame((Object)er, (Object)e);
        }
        TestIOUtil.assertTrue((boolean)in.closed);
    }

    public void testGetStreamContentAsBytesCloseTheStreamAfterRead() throws IOException {
        ByteValueInputStream in = new ByteValueInputStream(0);
        IOUtil.getStreamContentAsBytes((InputStream)in);
        TestIOUtil.assertTrue((boolean)in.closed);
    }

    public void testGetStreamContentAsBytesWithEmptyStream() {
        try {
            byte[] bytes = IOUtil.getStreamContentAsBytes((InputStream)new ByteArrayInputStream(new byte[0]));
            TestIOUtil.assertNotNull((Object)bytes);
            TestIOUtil.assertEquals((int)0, (int)bytes.length);
        }
        catch (IOException e) {
            TestIOUtil.fail();
        }
    }

    public void testGetStreamContentAsBytesThrowsIllegalArgumentException() throws IOException {
        try {
            IOUtil.getStreamContentAsBytes(null);
            TestIOUtil.fail((String)"Was expecting an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testGetStreamContentAsBytes() throws IOException {
        ByteArrayInputStream in = new ByteArrayInputStream("foo".getBytes("UTF8"));
        byte[] bytes = IOUtil.getStreamContentAsBytes((InputStream)in);
        TestIOUtil.assertEquals((String)"foo", (String)new String(bytes, "UTF8"));
    }

    public void testGetStreamContentAsBytesWithCorruptedStream() {
        InputStream corruptedInputStream = new InputStream(this){
            int state = 0;

            @Override
            public int read(byte[] b, int off, int len) throws IOException {
                if (len < 0) {
                    throw new AssertionError((Object)"We assume that does not happen");
                }
                switch (this.state++) {
                    case 0: {
                        b[0] = 4;
                        return 1;
                    }
                    case 1: {
                        return 0;
                    }
                    case 2: {
                        b[0] = 1;
                        return 1;
                    }
                    case 3: {
                        return -1;
                    }
                }
                throw new AssertionError((Object)"This should not happen");
            }

            @Override
            public int read() throws IOException {
                throw new UnsupportedOperationException();
            }
        };
        try {
            byte[] bytes = IOUtil.getStreamContentAsBytes((InputStream)corruptedInputStream);
            TestIOUtil.assertNotNull((Object)bytes);
            TestIOUtil.assertEquals((int)2, (int)bytes.length);
            TestIOUtil.assertEquals((int)4, (int)bytes[0]);
            TestIOUtil.assertEquals((int)1, (int)bytes[1]);
        }
        catch (IOException e) {
            TestIOUtil.fail();
        }
    }

    private static abstract class ClosableInputStream
    extends InputStream {
        protected boolean closed = false;

        private ClosableInputStream() {
        }

        @Override
        public void close() throws IOException {
            super.close();
            this.closed = true;
        }
    }

    private static class ByteValueInputStream
    extends ClosableInputStream {
        private Byte value;

        private ByteValueInputStream(byte value) {
            this.value = value;
        }

        @Override
        public int read() throws IOException {
            if (this.value != null) {
                byte tmp = this.value;
                this.value = null;
                return tmp;
            }
            return -1;
        }
    }
}

