/**
 * This file is part of the Meeds project (https://meeds.io/).
 *
 * Copyright (C) 2020 - 2025 Meeds Association contact@meeds.io
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */
package org.exoplatform.commons.utils;

import java.util.List;

/**
 * This object breaks the concepts of paging at its usage leads to load all the objects. It should not
 * be used and will be probably removed.
 *
 * @deprecated
 */
public class ObjectPageList<E> extends PageList<E>
{

   private List<E> objects_;

   public ObjectPageList(List<E> list, int pageSize)
   {
      super(pageSize);
      objects_ = list;
      setAvailablePage(list.size());
   }

   protected void populateCurrentPage(int page) throws Exception
   {
      currentListPage_ = objects_.subList(getFrom(), getTo());
   }

   public List<E> getAll() throws Exception
   {
      return objects_;
   }
}
