/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.utils;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import junit.framework.TestCase;
import org.exoplatform.commons.utils.Tools;

public class TestTools
extends TestCase {
    public void testEmtySet() {
        Set strings = Tools.set((Object[])new String[0]);
        TestTools.assertTrue((boolean)(strings instanceof HashSet));
        TestTools.assertTrue((boolean)strings.isEmpty());
    }

    public void testSingletonSet1() {
        Set strings = Tools.set((Object[])new String[]{"a"});
        TestTools.assertTrue((boolean)(strings instanceof HashSet));
        TestTools.assertEquals((int)1, (int)strings.size());
        TestTools.assertTrue((boolean)strings.contains("a"));
    }

    public void testSingletonSet2() {
        Set strings = Tools.set((Object[])new String[]{"a", "a"});
        TestTools.assertTrue((boolean)(strings instanceof HashSet));
        TestTools.assertEquals((int)1, (int)strings.size());
        TestTools.assertTrue((boolean)strings.contains("a"));
    }

    public void testTwoElementsInSet() {
        Set strings = Tools.set((Object[])new String[]{"a", "b"});
        TestTools.assertTrue((boolean)(strings instanceof HashSet));
        TestTools.assertEquals((int)2, (int)strings.size());
        TestTools.assertTrue((boolean)strings.contains("a"));
        TestTools.assertTrue((boolean)strings.contains("b"));
    }

    public void testSetThrowsIllegalArgumentException() {
        try {
            Tools.set((Object[])null);
            TestTools.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testParseCommaList() {
        TestTools.assertEquals((Object)Tools.set((Object[])new String[0]), (Object)Tools.parseCommaList((String)""));
        TestTools.assertEquals((Object)Tools.set((Object[])new String[0]), (Object)Tools.parseCommaList((String)","));
        TestTools.assertEquals((Object)Tools.set((Object[])new String[]{"a"}), (Object)Tools.parseCommaList((String)"a,"));
        TestTools.assertEquals((Object)Tools.set((Object[])new String[]{"a"}), (Object)Tools.parseCommaList((String)",a"));
        TestTools.assertEquals((Object)Tools.set((Object[])new String[]{"a", "b"}), (Object)Tools.parseCommaList((String)"a,,b"));
        TestTools.assertEquals((Object)Tools.set((Object[])new String[]{"a"}), (Object)Tools.parseCommaList((String)"a,a"));
        TestTools.assertEquals((Object)Tools.set((Object[])new String[]{"a", "b"}), (Object)Tools.parseCommaList((String)"a,b"));
    }

    public void testParseCommandListThrowsIllegalArgumentException() {
        try {
            Tools.parseCommaList(null);
            TestTools.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testEndsWithIgnoreCase() {
        TestTools.assertFalse((boolean)Tools.endsWithIgnoreCase((String)"", (String)"a"));
        TestTools.assertFalse((boolean)Tools.endsWithIgnoreCase((String)"b", (String)"a"));
        TestTools.assertTrue((boolean)Tools.endsWithIgnoreCase((String)"a", (String)"a"));
        TestTools.assertTrue((boolean)Tools.endsWithIgnoreCase((String)"a", (String)"A"));
        TestTools.assertTrue((boolean)Tools.endsWithIgnoreCase((String)"A", (String)"a"));
    }

    public void testEndsWithIgnoreCaseThrowsIllegalArgumentException() {
        try {
            Tools.endsWithIgnoreCase(null, (String)"a");
            TestTools.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            Tools.endsWithIgnoreCase((String)"a", null);
            TestTools.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            Tools.endsWithIgnoreCase(null, null);
            TestTools.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testAsMap() {
        Properties props = new Properties();
        props.put(new Object(), new Object());
        props.put("a", "b");
        Map map = Tools.asMap((Properties)props);
        TestTools.assertEquals(Collections.singletonMap("a", "b"), (Object)map);
        map.put("a", "c");
        TestTools.assertEquals(Collections.singletonMap("a", "c"), (Object)map);
        TestTools.assertEquals((int)2, (int)props.size());
        TestTools.assertEquals((String)"b", (String)props.getProperty("a"));
    }

    public void testAsMapThrowsIllegalArgumentException() {
        try {
            Tools.asMap(null);
            TestTools.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testAsProperties() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("a", "b");
        Properties props = Tools.asProperties(map);
        TestTools.assertEquals((int)1, (int)props.size());
        TestTools.assertEquals((String)"b", (String)props.getProperty("a"));
        props.put("a", "c");
        TestTools.assertEquals((int)1, (int)props.size());
        TestTools.assertEquals((String)"c", (String)props.getProperty("a"));
        TestTools.assertEquals(Collections.singletonMap("a", "b"), map);
    }

    public void testAsPropertiesThrowsIllegalArgumentException() {
        try {
            Tools.asProperties(null);
            TestTools.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

