/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.utils;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import junit.framework.TestCase;
import org.exoplatform.commons.exception.ExoMessageException;
import org.exoplatform.commons.utils.LazyPageList;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.commons.utils.ObjectPageList;
import org.exoplatform.commons.utils.PageList;

public class TestPageList
extends TestCase {
    private final List<String> l = Collections.unmodifiableList(Arrays.asList("0", "1", "2", "3", "4", "5", "6"));

    public TestPageList() {
    }

    public TestPageList(String s) {
        super(s);
    }

    public void testObjectPageList() throws Exception {
        ObjectPageList list = new ObjectPageList(this.l, 3);
        this.testBehavior((PageList)list);
    }

    public void testLazyList() throws Exception {
        ListAccess<String> list = new ListAccess<String>(){

            public String[] load(int index, int length) throws Exception, IllegalArgumentException {
                return TestPageList.this.l.subList(index, index + length).toArray(new String[length]);
            }

            public int getSize() throws Exception {
                return TestPageList.this.l.size();
            }
        };
        this.testBehavior((PageList)new LazyPageList((ListAccess)list, 3));
    }

    public void testBehavior(PageList list) throws Exception {
        TestPageList.assertEquals((int)0, (int)list.getFrom());
        TestPageList.assertEquals((int)3, (int)list.getTo());
        TestPageList.assertEquals((int)1, (int)list.getCurrentPage());
        TestPageList.assertEquals((int)3, (int)list.getAvailablePage());
        TestPageList.assertEquals((int)7, (int)list.getAvailable());
        List s = list.getPage(1);
        TestPageList.assertNotNull((Object)s);
        TestPageList.assertEquals((int)3, (int)s.size());
        TestPageList.assertEquals((String)"0", (String)((String)s.get(0)));
        TestPageList.assertEquals((String)"1", (String)((String)s.get(1)));
        TestPageList.assertEquals((String)"2", (String)((String)s.get(2)));
        TestPageList.assertEquals((int)0, (int)list.getFrom());
        TestPageList.assertEquals((int)3, (int)list.getTo());
        TestPageList.assertEquals((int)1, (int)list.getCurrentPage());
        TestPageList.assertEquals((int)3, (int)list.getAvailablePage());
        TestPageList.assertEquals((int)7, (int)list.getAvailable());
        s = list.getPage(2);
        TestPageList.assertNotNull((Object)s);
        TestPageList.assertEquals((int)3, (int)s.size());
        TestPageList.assertEquals((String)"3", (String)((String)s.get(0)));
        TestPageList.assertEquals((String)"4", (String)((String)s.get(1)));
        TestPageList.assertEquals((String)"5", (String)((String)s.get(2)));
        TestPageList.assertEquals((int)3, (int)list.getFrom());
        TestPageList.assertEquals((int)6, (int)list.getTo());
        TestPageList.assertEquals((int)2, (int)list.getCurrentPage());
        TestPageList.assertEquals((int)3, (int)list.getAvailablePage());
        TestPageList.assertEquals((int)7, (int)list.getAvailable());
        s = list.getPage(3);
        TestPageList.assertNotNull((Object)s);
        TestPageList.assertEquals((int)1, (int)s.size());
        TestPageList.assertEquals((String)"6", (String)((String)s.get(0)));
        TestPageList.assertEquals((int)6, (int)list.getFrom());
        TestPageList.assertEquals((int)7, (int)list.getTo());
        TestPageList.assertEquals((int)3, (int)list.getCurrentPage());
        TestPageList.assertEquals((int)3, (int)list.getAvailablePage());
        TestPageList.assertEquals((int)7, (int)list.getAvailable());
        try {
            list.getPage(4);
            TestPageList.fail();
        }
        catch (ExoMessageException exoMessageException) {
            // empty catch block
        }
        try {
            list.getPage(0);
            TestPageList.fail();
        }
        catch (ExoMessageException exoMessageException) {
            // empty catch block
        }
        try {
            list.getPage(-1);
            TestPageList.fail();
        }
        catch (ExoMessageException exoMessageException) {
            // empty catch block
        }
    }
}

