/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.utils;

import java.io.IOException;
import java.io.InputStream;
import junit.framework.TestCase;
import org.exoplatform.commons.utils.MimeTypeResolver;

public class TestMimeTypeResolver
extends TestCase {
    private MimeTypeResolver resolver = new MimeTypeResolver();

    public void testGetMimeTypeFromExtension() {
        TestMimeTypeResolver.assertEquals((String)this.resolver.getDefaultMimeType(), (String)this.resolver.getMimeType("file.unknown-file-extension"));
        TestMimeTypeResolver.assertEquals((String)this.resolver.getDefaultMimeType(), (String)this.resolver.getMimeType("file.pdf.unknown-file-extension"));
        TestMimeTypeResolver.assertEquals((String)"application/vnd.ms-outlook", (String)this.resolver.getMimeType("my.msg"));
        TestMimeTypeResolver.assertEquals((String)"application/msword", (String)this.resolver.getMimeType("my.doc"));
        TestMimeTypeResolver.assertEquals((String)"application/vnd.openxmlformats-officedocument.wordprocessingml.document", (String)this.resolver.getMimeType("my.docx"));
        TestMimeTypeResolver.assertEquals((String)"application/vnd.ms-excel", (String)this.resolver.getMimeType("my.xls"));
        TestMimeTypeResolver.assertEquals((String)"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", (String)this.resolver.getMimeType("my.xlsx"));
        TestMimeTypeResolver.assertEquals((String)"application/pdf", (String)this.resolver.getMimeType("my.pdf"));
        TestMimeTypeResolver.assertEquals((String)"image/jpeg", (String)this.resolver.getMimeType("my.jpg"));
        TestMimeTypeResolver.assertEquals((String)"application/vnd.oasis.opendocument.text", (String)this.resolver.getMimeType("my.odt"));
        TestMimeTypeResolver.assertEquals((String)"application/vnd.ms-word.document.macroenabled.12", (String)this.resolver.getMimeType("my.docm"));
        TestMimeTypeResolver.assertEquals((String)"application/msword", (String)this.resolver.getMimeType("my.dot"));
        TestMimeTypeResolver.assertEquals((String)"application/vnd.ms-word.template.macroenabled.12", (String)this.resolver.getMimeType("my.dotm"));
        TestMimeTypeResolver.assertEquals((String)"application/vnd.openxmlformats-officedocument.wordprocessingml.template", (String)this.resolver.getMimeType("my.dotx"));
        TestMimeTypeResolver.assertEquals((String)"application/vnd.ms-powerpoint.presentation.macroenabled.12", (String)this.resolver.getMimeType("my.pptm"));
        TestMimeTypeResolver.assertEquals((String)"application/vnd.openxmlformats-officedocument.presentationml.slideshow", (String)this.resolver.getMimeType("my.ppsx"));
        TestMimeTypeResolver.assertEquals((String)"application/vnd.ms-powerpoint.slideshow.macroenabled.12", (String)this.resolver.getMimeType("my.ppsm"));
        TestMimeTypeResolver.assertEquals((String)"application/vnd.ms-powerpoint", (String)this.resolver.getMimeType("my.pps"));
        TestMimeTypeResolver.assertEquals((String)"application/vnd.ms-powerpoint.addin.macroenabled.12", (String)this.resolver.getMimeType("my.ppam"));
        TestMimeTypeResolver.assertEquals((String)"application/vnd.ms-powerpoint", (String)this.resolver.getMimeType("my.ppa"));
        TestMimeTypeResolver.assertEquals((String)"application/vnd.openxmlformats-officedocument.presentationml.template", (String)this.resolver.getMimeType("my.potx"));
        TestMimeTypeResolver.assertEquals((String)"application/vnd.ms-powerpoint.template.macroenabled.12", (String)this.resolver.getMimeType("my.potm"));
        TestMimeTypeResolver.assertEquals((String)"application/vnd.ms-powerpoint", (String)this.resolver.getMimeType("my.pot"));
        TestMimeTypeResolver.assertEquals((String)"application/vnd.openxmlformats-officedocument.spreadsheetml.template", (String)this.resolver.getMimeType("my.xltx"));
        TestMimeTypeResolver.assertEquals((String)"application/vnd.ms-excel.template.macroenabled.12", (String)this.resolver.getMimeType("my.xltm"));
        TestMimeTypeResolver.assertEquals((String)"application/vnd.ms-excel", (String)this.resolver.getMimeType("my.xlt"));
        TestMimeTypeResolver.assertEquals((String)"application/vnd.ms-excel.sheet.macroenabled.12", (String)this.resolver.getMimeType("my.xlsm"));
        TestMimeTypeResolver.assertEquals((String)"application/vnd.ms-excel.sheet.binary.macroenabled.12", (String)this.resolver.getMimeType("my.xlsb"));
        TestMimeTypeResolver.assertEquals((String)"application/vnd.ms-excel.addin.macroenabled.12", (String)this.resolver.getMimeType("my.xlam"));
        TestMimeTypeResolver.assertEquals((String)"application/vnd.ms-excel", (String)this.resolver.getMimeType("my.xla"));
        TestMimeTypeResolver.assertEquals((String)"application/vnd.ms-excel", (String)this.resolver.getMimeType("my.xll"));
    }

    public void testGetMimeTypeFromContent() throws IOException {
        TestMimeTypeResolver.assertEquals((String)this.resolver.getDefaultMimeType(), (String)this.resolver.getMimeType("unknown-file-extension"));
        TestMimeTypeResolver.assertEquals((String)this.resolver.getDefaultMimeType(), (String)this.resolver.getMimeType("file."));
        InputStream is = TestMimeTypeResolver.class.getResourceAsStream("/testjpg");
        TestMimeTypeResolver.assertEquals((String)"image/jpeg", (String)this.resolver.getMimeType("testjpg", is));
        is.close();
        is = TestMimeTypeResolver.class.getResourceAsStream("/testpdf");
        TestMimeTypeResolver.assertEquals((String)"application/pdf", (String)this.resolver.getMimeType("testpdf", is));
        is.close();
        is = TestMimeTypeResolver.class.getResourceAsStream("/testdoc");
        TestMimeTypeResolver.assertEquals((String)"application/msword", (String)this.resolver.getMimeType("testdoc", is));
        is.close();
        is = TestMimeTypeResolver.class.getResourceAsStream("/testxml");
        TestMimeTypeResolver.assertEquals((String)"text/xml", (String)this.resolver.getMimeType("testxml", is));
        is.close();
        is = TestMimeTypeResolver.class.getResourceAsStream("/testxls");
        TestMimeTypeResolver.assertEquals((String)"application/msword", (String)this.resolver.getMimeType("testxls", is));
        is.close();
    }

    public void testGetExtension() {
        TestMimeTypeResolver.assertEquals((String)"jpeg", (String)this.resolver.getExtension("image/jpeg"));
        TestMimeTypeResolver.assertEquals((String)"jpeg", (String)this.resolver.getExtension("image/pjpeg"));
        TestMimeTypeResolver.assertEquals((String)"", (String)this.resolver.getExtension(""));
        TestMimeTypeResolver.assertEquals((String)"", (String)this.resolver.getExtension("unknown-mimetype"));
        TestMimeTypeResolver.assertEquals((String)"", (String)this.resolver.getExtension(this.resolver.getDefaultMimeType()));
        TestMimeTypeResolver.assertEquals((String)"msg", (String)this.resolver.getExtension("application/vnd.ms-outlook"));
        TestMimeTypeResolver.assertEquals((String)"midi", (String)this.resolver.getExtension("audio/midi"));
        TestMimeTypeResolver.assertEquals((String)"dcr", (String)this.resolver.getExtension("application/x-director"));
    }

    public void testGetMimeTypeFromExtensionInUpperCase() {
        TestMimeTypeResolver.assertEquals((String)this.resolver.getDefaultMimeType(), (String)this.resolver.getMimeType("FILE.UNKNOWN-FILE-EXTENSION"));
        TestMimeTypeResolver.assertEquals((String)this.resolver.getDefaultMimeType(), (String)this.resolver.getMimeType("FILE.PDF.UNKNOWN-FILE-EXTENSION"));
        TestMimeTypeResolver.assertEquals((String)"application/vnd.ms-outlook", (String)this.resolver.getMimeType("MY.MSG"));
        TestMimeTypeResolver.assertEquals((String)"application/msword", (String)this.resolver.getMimeType("MY.DOC"));
        TestMimeTypeResolver.assertEquals((String)"application/vnd.openxmlformats-officedocument.wordprocessingml.document", (String)this.resolver.getMimeType("MY.DOCX"));
        TestMimeTypeResolver.assertEquals((String)"application/vnd.ms-excel", (String)this.resolver.getMimeType("MY.XLS"));
        TestMimeTypeResolver.assertEquals((String)"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", (String)this.resolver.getMimeType("MY.XLSX"));
        TestMimeTypeResolver.assertEquals((String)"application/pdf", (String)this.resolver.getMimeType("MY.PDF"));
        TestMimeTypeResolver.assertEquals((String)"image/jpeg", (String)this.resolver.getMimeType("MY.JPG"));
        TestMimeTypeResolver.assertEquals((String)"application/vnd.oasis.opendocument.text", (String)this.resolver.getMimeType("MY.ODT"));
    }
}

