/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.utils;

import java.util.Calendar;
import junit.framework.TestCase;
import org.exoplatform.commons.utils.ISO8601;

public class TestISO8601
extends TestCase {
    public void testParseNFormat() throws Exception {
        String dateStr = "1997";
        Calendar date = ISO8601.parseEx((String)dateStr);
        TestISO8601.assertTrue((boolean)ISO8601.format((Calendar)date).startsWith(dateStr + "-01-01T00:00:00.000"));
        dateStr = "1997-07";
        date = ISO8601.parseEx((String)dateStr);
        TestISO8601.assertTrue((boolean)ISO8601.format((Calendar)date).startsWith(dateStr + "-01T00:00:00.000"));
        dateStr = "1997-07-16";
        date = ISO8601.parseEx((String)dateStr);
        TestISO8601.assertTrue((boolean)ISO8601.format((Calendar)date).startsWith(dateStr + "T00:00:00.000"));
        dateStr = "1997-07-16T19:20";
        date = ISO8601.parseEx((String)dateStr);
        TestISO8601.assertTrue((boolean)ISO8601.format((Calendar)date).startsWith(dateStr + ":00.000"));
        dateStr = "1997-07-16T19:20:30";
        date = ISO8601.parseEx((String)dateStr);
        TestISO8601.assertTrue((boolean)ISO8601.format((Calendar)date).startsWith(dateStr + ".000"));
        dateStr = "1997-07-16T19:20:30.45";
        date = ISO8601.parseEx((String)dateStr);
        TestISO8601.assertTrue((boolean)ISO8601.format((Calendar)date).startsWith("1997-07-16T19:20:30.450"));
        dateStr = "1997-07-16T19:20:30.450";
        date = ISO8601.parseEx((String)dateStr);
        TestISO8601.assertTrue((boolean)ISO8601.format((Calendar)date).startsWith(dateStr));
        dateStr = "1997-07-16T19:20:30.450+01:00";
        date = ISO8601.parseEx((String)dateStr);
        TestISO8601.assertEquals((String)dateStr, (String)ISO8601.format((Calendar)date));
        dateStr = "1997-07-16T19:20:30.450-01:00";
        date = ISO8601.parseEx((String)dateStr);
        TestISO8601.assertEquals((String)dateStr, (String)ISO8601.format((Calendar)date));
        dateStr = "1997-07-16T19:20:30.450+0100";
        date = ISO8601.parseEx((String)dateStr);
        TestISO8601.assertEquals((String)(dateStr.substring(0, dateStr.length() - 2) + ":00"), (String)ISO8601.format((Calendar)date));
        dateStr = "1997-07-16T19:20:30.450-0100";
        date = ISO8601.parseEx((String)dateStr);
        TestISO8601.assertEquals((String)(dateStr.substring(0, dateStr.length() - 2) + ":00"), (String)ISO8601.format((Calendar)date));
        dateStr = "1997-07-16T19:20:30.450+01";
        date = ISO8601.parseEx((String)dateStr);
        TestISO8601.assertEquals((String)(dateStr + ":00"), (String)ISO8601.format((Calendar)date));
        dateStr = "1997-07-16T19:20:30.450-01";
        date = ISO8601.parseEx((String)dateStr);
        TestISO8601.assertEquals((String)(dateStr + ":00"), (String)ISO8601.format((Calendar)date));
        dateStr = "1997-07-16T19:20+0100";
        date = ISO8601.parseEx((String)dateStr);
        TestISO8601.assertEquals((String)(dateStr.substring(0, dateStr.length() - 5) + ":00.000+01:00"), (String)ISO8601.format((Calendar)date));
        dateStr = "1997-07-16T19:20-0100";
        date = ISO8601.parseEx((String)dateStr);
        TestISO8601.assertEquals((String)(dateStr.substring(0, dateStr.length() - 5) + ":00.000-01:00"), (String)ISO8601.format((Calendar)date));
        dateStr = "1997-07-16T19:20+01:00";
        date = ISO8601.parseEx((String)dateStr);
        TestISO8601.assertEquals((String)(dateStr.substring(0, dateStr.length() - 6) + ":00.000+01:00"), (String)ISO8601.format((Calendar)date));
        dateStr = "1997-07-16T19:20-01:00";
        date = ISO8601.parseEx((String)dateStr);
        TestISO8601.assertEquals((String)(dateStr.substring(0, dateStr.length() - 6) + ":00.000-01:00"), (String)ISO8601.format((Calendar)date));
        dateStr = "1997-07-16T19:20:30+0100";
        date = ISO8601.parseEx((String)dateStr);
        TestISO8601.assertEquals((String)(dateStr.substring(0, dateStr.length() - 5) + ".000+01:00"), (String)ISO8601.format((Calendar)date));
        dateStr = "1997-07-16T19:20:30-0100";
        date = ISO8601.parseEx((String)dateStr);
        TestISO8601.assertEquals((String)(dateStr.substring(0, dateStr.length() - 5) + ".000-01:00"), (String)ISO8601.format((Calendar)date));
        dateStr = "1997-07-16T19:20:30+01:00";
        date = ISO8601.parseEx((String)dateStr);
        TestISO8601.assertEquals((String)(dateStr.substring(0, dateStr.length() - 6) + ".000+01:00"), (String)ISO8601.format((Calendar)date));
        dateStr = "1997-07-16T19:20:30-01:00";
        date = ISO8601.parseEx((String)dateStr);
        TestISO8601.assertEquals((String)(dateStr.substring(0, dateStr.length() - 6) + ".000-01:00"), (String)ISO8601.format((Calendar)date));
        dateStr = "1997-07-16T19:20:30.045+0100";
        date = ISO8601.parseEx((String)dateStr);
        TestISO8601.assertEquals((String)(dateStr.substring(0, dateStr.length() - 5) + "+01:00"), (String)ISO8601.format((Calendar)date));
        dateStr = "1997-07-16T19:20:30.045-0100";
        date = ISO8601.parseEx((String)dateStr);
        TestISO8601.assertEquals((String)(dateStr.substring(0, dateStr.length() - 5) + "-01:00"), (String)ISO8601.format((Calendar)date));
        dateStr = "1997-07-16T19:20:30.45+01:00";
        date = ISO8601.parseEx((String)dateStr);
        TestISO8601.assertEquals((String)(dateStr.substring(0, dateStr.length() - 8) + "450+01:00"), (String)ISO8601.format((Calendar)date));
        dateStr = "1997-07-16T19:20:30.45-01:00";
        date = ISO8601.parseEx((String)dateStr);
        TestISO8601.assertEquals((String)(dateStr.substring(0, dateStr.length() - 8) + "450-01:00"), (String)ISO8601.format((Calendar)date));
        dateStr = "2012-04-13T10:31:18.798 01:00";
        date = ISO8601.parseEx((String)dateStr);
        TestISO8601.assertEquals((String)dateStr.substring(0, dateStr.length() - 6), (String)ISO8601.format((Calendar)date).substring(0, dateStr.length() - 6));
        dateStr = "2012-04-13T10:31:18.798+07:00";
        date = ISO8601.parseEx((String)dateStr);
        TestISO8601.assertEquals((String)(dateStr.substring(0, dateStr.length() - 6) + "+07:00"), (String)ISO8601.format((Calendar)date));
        dateStr = "2012-04-13T10:31:18.798+07:00--true;1;1;Asia/Ho_Chi_Minh";
        date = ISO8601.parseEx((String)dateStr);
        TestISO8601.assertEquals((String)(dateStr.substring(0, dateStr.length() - 33) + "Z"), (String)ISO8601.format((Calendar)date));
    }
}

