/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cache.concurrent;

import java.io.Serializable;
import java.util.Collections;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.Parameter;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.services.cache.concurrent.SimpleReplicatedExoCache;
import org.exoplatform.services.rpc.RPCService;
import org.exoplatform.services.rpc.jgv3.RPCServiceImpl;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestSimpleReplicatedExoCache {
    private PortalContainer container;
    private RPCServiceImpl service1;
    private RPCServiceImpl service2;
    private SimpleReplicatedExoCache<String, String> cache1;
    private SimpleReplicatedExoCache<String, String> cache2;

    @Before
    public void init() throws Exception {
        this.container = PortalContainer.getInstance();
        ConfigurationManager configManager = (ConfigurationManager)this.container.getComponentInstanceOfType(ConfigurationManager.class);
        InitParams params = new InitParams();
        ValueParam paramConf = new ValueParam();
        paramConf.setName("jgroups-configuration");
        paramConf.setValue("jar:/conf/portal/udp.xml");
        params.addParameter((Parameter)paramConf);
        this.service1 = new RPCServiceImpl(this.container.getContext(), params, configManager);
        this.service2 = new RPCServiceImpl(this.container.getContext(), params, configManager);
        this.cache1 = new SimpleReplicatedExoCache(this.container.getContext(), (RPCService)this.service1);
        this.cache2 = new SimpleReplicatedExoCache(this.container.getContext(), (RPCService)this.service2);
        this.cache1.setName("TestSimpleReplicatedExoCache");
        this.cache2.setName("TestSimpleReplicatedExoCache");
        this.service1.start();
        this.service2.start();
    }

    @After
    public void destroy() throws Exception {
        this.service1.stop();
        this.service2.stop();
    }

    @Test
    public void testPut() throws Exception {
        int i;
        Assert.assertEquals((long)0L, (long)this.cache1.getCacheSize());
        Assert.assertEquals((long)0L, (long)this.cache2.getCacheSize());
        this.cache1.put((Serializable)((Object)"a"), (Serializable)((Object)"value"));
        Assert.assertEquals((long)1L, (long)this.cache1.getCacheSize());
        Assert.assertEquals((Object)"value", (Object)this.cache1.get((Serializable)((Object)"a")));
        for (int i2 = 0; i2 < 5 && this.cache2.getCacheSize() <= 0; ++i2) {
            Thread.sleep(200L);
        }
        Assert.assertEquals((long)1L, (long)this.cache2.getCacheSize());
        Assert.assertEquals((Object)"value", (Object)this.cache2.get((Serializable)((Object)"a")));
        String value1 = new String("value");
        Object value2 = this.cache2.get((Serializable)((Object)"a"));
        this.cache1.put((Serializable)((Object)"a"), (Serializable)((Object)value1));
        Assert.assertEquals((long)1L, (long)this.cache1.getCacheSize());
        Assert.assertEquals((Object)"value", (Object)this.cache1.get((Serializable)((Object)"a")));
        Assert.assertTrue((value1 == this.cache1.get((Serializable)((Object)"a")) ? 1 : 0) != 0);
        for (i = 0; i < 5; ++i) {
            Assert.assertEquals((Object)"value", (Object)this.cache2.get((Serializable)((Object)"a")));
            Assert.assertTrue((value2 == this.cache2.get((Serializable)((Object)"a")) ? 1 : 0) != 0);
            Thread.sleep(200L);
        }
        Assert.assertEquals((Object)"value", (Object)this.cache2.get((Serializable)((Object)"a")));
        Assert.assertTrue((value2 == this.cache2.get((Serializable)((Object)"a")) ? 1 : 0) != 0);
        this.cache1.put((Serializable)((Object)"a"), (Serializable)((Object)"value2"));
        Assert.assertEquals((long)1L, (long)this.cache1.getCacheSize());
        Assert.assertEquals((Object)"value2", (Object)this.cache1.get((Serializable)((Object)"a")));
        for (i = 0; i < 5 && !((String)this.cache2.get((Serializable)((Object)"a"))).equals("value2"); ++i) {
            Thread.sleep(200L);
        }
        Assert.assertEquals((long)1L, (long)this.cache2.getCacheSize());
        Assert.assertEquals((Object)"value2", (Object)this.cache2.get((Serializable)((Object)"a")));
    }

    @Test
    public void testPutMap() throws Exception {
        int i;
        Assert.assertEquals((long)0L, (long)this.cache1.getCacheSize());
        Assert.assertEquals((long)0L, (long)this.cache2.getCacheSize());
        this.cache1.putMap(Collections.singletonMap("a", "value"));
        Assert.assertEquals((long)1L, (long)this.cache1.getCacheSize());
        Assert.assertEquals((Object)"value", (Object)this.cache1.get((Serializable)((Object)"a")));
        for (int i2 = 0; i2 < 5 && this.cache2.getCacheSize() <= 0; ++i2) {
            Thread.sleep(200L);
        }
        Assert.assertEquals((long)1L, (long)this.cache2.getCacheSize());
        Assert.assertEquals((Object)"value", (Object)this.cache2.get((Serializable)((Object)"a")));
        String value1 = new String("value");
        Object value2 = this.cache2.get((Serializable)((Object)"a"));
        this.cache1.putMap(Collections.singletonMap("a", value1));
        Assert.assertEquals((long)1L, (long)this.cache1.getCacheSize());
        Assert.assertEquals((Object)"value", (Object)this.cache1.get((Serializable)((Object)"a")));
        Assert.assertTrue((value1 == this.cache1.get((Serializable)((Object)"a")) ? 1 : 0) != 0);
        for (i = 0; i < 5; ++i) {
            Assert.assertEquals((Object)"value", (Object)this.cache2.get((Serializable)((Object)"a")));
            Assert.assertTrue((value2 == this.cache2.get((Serializable)((Object)"a")) ? 1 : 0) != 0);
            Thread.sleep(200L);
        }
        Assert.assertEquals((Object)"value", (Object)this.cache2.get((Serializable)((Object)"a")));
        Assert.assertTrue((value2 == this.cache2.get((Serializable)((Object)"a")) ? 1 : 0) != 0);
        this.cache1.putMap(Collections.singletonMap("a", "value2"));
        Assert.assertEquals((long)1L, (long)this.cache1.getCacheSize());
        Assert.assertEquals((Object)"value2", (Object)this.cache1.get((Serializable)((Object)"a")));
        for (i = 0; i < 5 && !((String)this.cache2.get((Serializable)((Object)"a"))).equals("value2"); ++i) {
            Thread.sleep(200L);
        }
        Assert.assertEquals((long)1L, (long)this.cache2.getCacheSize());
        Assert.assertEquals((Object)"value2", (Object)this.cache2.get((Serializable)((Object)"a")));
    }

    @Test
    public void testRemove() throws Exception {
        int i;
        Assert.assertEquals((long)0L, (long)this.cache1.getCacheSize());
        Assert.assertEquals((long)0L, (long)this.cache2.getCacheSize());
        this.cache1.put((Serializable)((Object)"a"), (Serializable)((Object)"value"));
        Assert.assertEquals((long)1L, (long)this.cache1.getCacheSize());
        for (i = 0; i < 5 && this.cache2.getCacheSize() <= 0; ++i) {
            Thread.sleep(200L);
        }
        Assert.assertEquals((long)1L, (long)this.cache2.getCacheSize());
        Assert.assertEquals((Object)"value", (Object)this.cache1.remove((Serializable)((Object)"a")));
        Assert.assertEquals((long)0L, (long)this.cache1.getCacheSize());
        Assert.assertNull((Object)this.cache1.get((Serializable)((Object)"a")));
        for (i = 0; i < 5 && this.cache2.getCacheSize() != 0; ++i) {
            Thread.sleep(200L);
        }
        Assert.assertEquals((long)0L, (long)this.cache2.getCacheSize());
        Assert.assertNull((Object)this.cache2.get((Serializable)((Object)"a")));
        Assert.assertNull((Object)this.cache1.remove((Serializable)((Object)"a")));
    }

    @Test
    public void testClearCache() throws Exception {
        int i;
        Assert.assertEquals((long)0L, (long)this.cache1.getCacheSize());
        Assert.assertEquals((long)0L, (long)this.cache2.getCacheSize());
        this.cache1.put((Serializable)((Object)"a"), (Serializable)((Object)"value"));
        this.cache1.put((Serializable)((Object)"b"), (Serializable)((Object)"value"));
        this.cache1.put((Serializable)((Object)"c"), (Serializable)((Object)"value"));
        Assert.assertEquals((long)3L, (long)this.cache1.getCacheSize());
        for (i = 0; i < 5 && this.cache2.getCacheSize() != 3; ++i) {
            Thread.sleep(200L);
        }
        Assert.assertEquals((long)3L, (long)this.cache2.getCacheSize());
        this.cache1.clearCache();
        Assert.assertEquals((long)0L, (long)this.cache1.getCacheSize());
        Assert.assertNull((Object)this.cache1.get((Serializable)((Object)"a")));
        Assert.assertNull((Object)this.cache1.get((Serializable)((Object)"b")));
        Assert.assertNull((Object)this.cache1.get((Serializable)((Object)"c")));
        for (i = 0; i < 5 && this.cache2.getCacheSize() != 0; ++i) {
            Thread.sleep(200L);
        }
        Assert.assertEquals((long)0L, (long)this.cache2.getCacheSize());
        Assert.assertNull((Object)this.cache2.get((Serializable)((Object)"a")));
        Assert.assertNull((Object)this.cache2.get((Serializable)((Object)"b")));
        Assert.assertNull((Object)this.cache2.get((Serializable)((Object)"c")));
    }

    @Test
    public void testIsolation() throws Exception {
        int i;
        SimpleReplicatedExoCache cache3 = new SimpleReplicatedExoCache(this.container.getContext(), (RPCService)this.service1);
        SimpleReplicatedExoCache cache4 = new SimpleReplicatedExoCache(this.container.getContext(), (RPCService)this.service2);
        cache3.setName("TestSimpleReplicatedExoCache.testIsolation");
        cache4.setName("TestSimpleReplicatedExoCache.testIsolation");
        Assert.assertEquals((long)0L, (long)this.cache1.getCacheSize());
        Assert.assertEquals((long)0L, (long)this.cache2.getCacheSize());
        Assert.assertEquals((long)0L, (long)cache3.getCacheSize());
        Assert.assertEquals((long)0L, (long)cache4.getCacheSize());
        this.cache1.put((Serializable)((Object)"a"), (Serializable)((Object)"value"));
        Assert.assertEquals((long)1L, (long)this.cache1.getCacheSize());
        for (i = 0; i < 5 && this.cache2.getCacheSize() <= 0; ++i) {
            Thread.sleep(200L);
        }
        Assert.assertEquals((long)1L, (long)this.cache2.getCacheSize());
        Assert.assertEquals((long)0L, (long)cache3.getCacheSize());
        Assert.assertEquals((long)0L, (long)cache4.getCacheSize());
        cache4.put((Serializable)((Object)"a"), (Serializable)((Object)"value2"));
        Assert.assertEquals((long)1L, (long)this.cache1.getCacheSize());
        for (i = 0; i < 5 && cache3.getCacheSize() <= 0; ++i) {
            Thread.sleep(200L);
        }
        Assert.assertEquals((long)1L, (long)this.cache1.getCacheSize());
        Assert.assertEquals((long)1L, (long)this.cache2.getCacheSize());
        Assert.assertEquals((long)1L, (long)cache3.getCacheSize());
        Assert.assertEquals((long)1L, (long)cache4.getCacheSize());
        Assert.assertEquals((Object)"value", (Object)this.cache1.get((Serializable)((Object)"a")));
        Assert.assertEquals((Object)"value", (Object)this.cache2.get((Serializable)((Object)"a")));
        Assert.assertEquals((Object)"value2", (Object)cache3.get((Serializable)((Object)"a")));
        Assert.assertEquals((Object)"value2", (Object)cache4.get((Serializable)((Object)"a")));
        Assert.assertEquals((Object)"value2", (Object)cache4.remove((Serializable)((Object)"a")));
        for (i = 0; i < 5 && cache3.getCacheSize() != 0; ++i) {
            Thread.sleep(200L);
        }
        Assert.assertEquals((long)1L, (long)this.cache1.getCacheSize());
        Assert.assertEquals((long)1L, (long)this.cache2.getCacheSize());
        Assert.assertEquals((long)0L, (long)cache3.getCacheSize());
        Assert.assertEquals((long)0L, (long)cache4.getCacheSize());
        Assert.assertEquals((Object)"value", (Object)this.cache1.get((Serializable)((Object)"a")));
        Assert.assertEquals((Object)"value", (Object)this.cache2.get((Serializable)((Object)"a")));
        Assert.assertNull((Object)cache3.get((Serializable)((Object)"a")));
        Assert.assertNull((Object)cache4.get((Serializable)((Object)"a")));
        cache4.putMap(Collections.singletonMap("a", "value2"));
        for (i = 0; i < 5 && cache3.getCacheSize() <= 0; ++i) {
            Thread.sleep(200L);
        }
        Assert.assertEquals((long)1L, (long)this.cache1.getCacheSize());
        Assert.assertEquals((long)1L, (long)this.cache2.getCacheSize());
        Assert.assertEquals((long)1L, (long)cache3.getCacheSize());
        Assert.assertEquals((long)1L, (long)cache4.getCacheSize());
        Assert.assertEquals((Object)"value", (Object)this.cache1.get((Serializable)((Object)"a")));
        Assert.assertEquals((Object)"value", (Object)this.cache2.get((Serializable)((Object)"a")));
        Assert.assertEquals((Object)"value2", (Object)cache3.get((Serializable)((Object)"a")));
        Assert.assertEquals((Object)"value2", (Object)cache4.get((Serializable)((Object)"a")));
        cache4.clearCache();
        for (i = 0; i < 5 && cache3.getCacheSize() != 0; ++i) {
            Thread.sleep(200L);
        }
        Assert.assertEquals((long)1L, (long)this.cache1.getCacheSize());
        Assert.assertEquals((long)1L, (long)this.cache2.getCacheSize());
        Assert.assertEquals((long)0L, (long)cache3.getCacheSize());
        Assert.assertEquals((long)0L, (long)cache4.getCacheSize());
        Assert.assertEquals((Object)"value", (Object)this.cache1.get((Serializable)((Object)"a")));
        Assert.assertEquals((Object)"value", (Object)this.cache2.get((Serializable)((Object)"a")));
        Assert.assertNull((Object)cache3.get((Serializable)((Object)"a")));
        Assert.assertNull((Object)cache4.get((Serializable)((Object)"a")));
    }
}

