/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cache;

public enum CacheMode {
    NONE("", true, 3),
    LOCAL("local", true, 3),
    REPLICATION("replication", true, 0),
    ASYNCREPLICATION("asyncReplication", false, 0),
    ASYNCINVALIDATION("asyncInvalidation", false, 1),
    SYNCINVALIDATION("syncInvalidation", true, 1),
    DISTRIBUTED("distributed", true, 2);

    private static final int CACHE_MODE_REPLICATED = 0;
    private static final int CACHE_MODE_INVALIDATED = 1;
    private static final int CACHE_MODE_DISTRIBUTED = 2;
    private static final int CACHE_MODE_LOCAL = 3;
    private final String name;
    private final boolean sync;
    private final int topology;

    private CacheMode(String name, boolean sync, int topology) {
        this.name = name;
        this.sync = sync;
        this.topology = topology;
    }

    public boolean isReplicated() {
        return this.topology == 0;
    }

    public boolean isInvalidated() {
        return this.topology == 1;
    }

    public boolean isDistributed() {
        return this.topology == 2;
    }

    public boolean isLocal() {
        return this.topology == 3;
    }

    public String getName() {
        return this.name;
    }

    public boolean isSync() {
        return this.sync;
    }
}

