/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cache.test;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import junit.framework.TestCase;
import org.exoplatform.services.cache.CacheListener;
import org.exoplatform.services.cache.CacheListenerContext;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.cache.FIFOExoCache;
import org.exoplatform.services.cache.concurrent.ConcurrentFIFOExoCache;
import org.exoplatform.services.log.Log;

public class ScalabilityTestLoad
extends TestCase {
    private int multiplier = 10;
    List<CacheProvider> providers = Arrays.asList(fifo, concurrentFIFO);
    List<CacheProvider> providers2 = Arrays.asList(fifo, concurrentFIFO, fifoWithListener, concurrentFIFOWithListener);
    private static CacheProvider concurrentFIFO = new CacheProvider("Concurrent FIFO cache"){

        @Override
        public ExoCache<Serializable, Object> createCache(int cacheSize) {
            return new ConcurrentFIFOExoCache(cacheSize, ScalabilityTestLoad.createLog());
        }
    };
    private static CacheProvider fifo = new CacheProvider("FIFO cache"){

        @Override
        public ExoCache<Serializable, Object> createCache(int cacheSize) {
            return new FIFOExoCache(cacheSize);
        }
    };
    private static CacheProvider concurrentFIFOWithListener = new CacheProvider("Concurrent FIFO cache with listener"){

        @Override
        public ExoCache<Serializable, Object> createCache(int cacheSize) {
            ConcurrentFIFOExoCache cache = new ConcurrentFIFOExoCache(cacheSize, ScalabilityTestLoad.createLog());
            cache.addCacheListener((CacheListener)new SimpleCacheListener());
            return cache;
        }
    };
    private static CacheProvider fifoWithListener = new CacheProvider("FIFO cache with listener"){

        @Override
        public ExoCache<Serializable, Object> createCache(int cacheSize) {
            FIFOExoCache cache = new FIFOExoCache(cacheSize);
            cache.addCacheListener((CacheListener)new SimpleCacheListener());
            return cache;
        }
    };

    private static void doTest(String name, List<CacheProvider> providers, int cacheSize, Config config) {
        System.out.println("-----------------------------------------");
        System.out.println("Test " + name + " cacheSize=" + cacheSize + " threadSize=" + config.threadSize + " objectSize=" + config.objectSize + " getSize=" + config.getSize + " putSize=" + config.putSize + " removalSize=" + config.removalSize);
        for (CacheProvider provider : providers) {
            Test test = new Test(provider.createCache(cacheSize), config);
            long time = test.perform();
            System.out.println("Cache " + provider.name + ": " + time + "ms");
        }
        System.out.println("");
    }

    public void testReadMostly1() {
        ScalabilityTestLoad.doTest("Read mostly 1", this.providers, 50, new Config(4, 100, 100000 * this.multiplier, 1000 * this.multiplier, 1000 * this.multiplier));
        ScalabilityTestLoad.doTest("Read mostly 1", this.providers, 50, new Config(8, 100, 100000 * this.multiplier, 1000 * this.multiplier, 1000 * this.multiplier));
        ScalabilityTestLoad.doTest("Read mostly 1", this.providers, 50, new Config(16, 100, 100000 * this.multiplier, 1000 * this.multiplier, 1000 * this.multiplier));
        ScalabilityTestLoad.doTest("Read mostly 1", this.providers, 50, new Config(32, 100, 100000 * this.multiplier, 1000 * this.multiplier, 1000 * this.multiplier));
    }

    public void testReadMostly2() {
        ScalabilityTestLoad.doTest("Read mostly 2", this.providers, 500, new Config(4, 100, 100000 * this.multiplier, 1000 * this.multiplier, 1000 * this.multiplier));
        ScalabilityTestLoad.doTest("Read mostly 2", this.providers, 500, new Config(8, 100, 100000 * this.multiplier, 1000 * this.multiplier, 1000 * this.multiplier));
        ScalabilityTestLoad.doTest("Read mostly 2", this.providers, 500, new Config(16, 100, 100000 * this.multiplier, 1000 * this.multiplier, 1000 * this.multiplier));
        ScalabilityTestLoad.doTest("Read mostly 2", this.providers, 500, new Config(32, 100, 100000 * this.multiplier, 1000 * this.multiplier, 1000 * this.multiplier));
    }

    public void testWrite1() {
        ScalabilityTestLoad.doTest("Write only 1", this.providers, 50, new Config(4, 100, 0, 1000 * this.multiplier, 1000 * this.multiplier));
        ScalabilityTestLoad.doTest("Write only 1", this.providers, 50, new Config(8, 100, 0, 1000 * this.multiplier, 1000 * this.multiplier));
        ScalabilityTestLoad.doTest("Write only 1", this.providers, 50, new Config(16, 100, 0, 1000 * this.multiplier, 1000 * this.multiplier));
        ScalabilityTestLoad.doTest("Write only 1", this.providers, 50, new Config(32, 100, 0, 1000 * this.multiplier, 1000 * this.multiplier));
    }

    public void testWrite2() {
        ScalabilityTestLoad.doTest("Write only 2", this.providers, 500, new Config(4, 100, 0, 1000 * this.multiplier, 1000 * this.multiplier));
        ScalabilityTestLoad.doTest("Write only 2", this.providers, 500, new Config(8, 100, 0, 1000 * this.multiplier, 1000 * this.multiplier));
        ScalabilityTestLoad.doTest("Write only 2", this.providers, 500, new Config(16, 100, 0, 1000 * this.multiplier, 1000 * this.multiplier));
        ScalabilityTestLoad.doTest("Write only 2", this.providers, 500, new Config(32, 100, 0, 1000 * this.multiplier, 1000 * this.multiplier));
    }

    public void testContention() {
        ScalabilityTestLoad.doTest("Contention", this.providers2, 500, new Config(4, 100, 100000 * this.multiplier, 1000 * this.multiplier, 1000 * this.multiplier));
        ScalabilityTestLoad.doTest("Contention", this.providers2, 500, new Config(8, 100, 100000 * this.multiplier, 500 * this.multiplier, 500 * this.multiplier));
        ScalabilityTestLoad.doTest("Contention", this.providers2, 500, new Config(16, 100, 100000 * this.multiplier, 250 * this.multiplier, 250 * this.multiplier));
        ScalabilityTestLoad.doTest("Contention", this.providers2, 500, new Config(32, 100, 100000 * this.multiplier, 125 * this.multiplier, 125 * this.multiplier));
    }

    private static Log createLog() {
        return null;
    }

    private static abstract class CacheProvider {
        String name;

        private CacheProvider(String name) {
            this.name = name;
        }

        abstract ExoCache<Serializable, Object> createCache(int var1);
    }

    private static class Config {
        private final int threadSize;
        private final int objectSize;
        private final int putSize;
        private final int getSize;
        private final int removalSize;

        private Config(int threadSize, int objectSize, int getSize, int putSize, int removalSize) {
            this.threadSize = threadSize;
            this.objectSize = objectSize;
            this.putSize = putSize;
            this.getSize = getSize;
            this.removalSize = removalSize;
        }
    }

    private static class Test {
        private final Config config;
        private final ExecutorService executor;
        private final ExecutorCompletionService<Worker> completionService;
        private final Worker[] workers;
        private final ExoCache<Serializable, Object> cache;

        private Test(ExoCache<Serializable, Object> cache, Config config) {
            this.config = config;
            this.executor = Executors.newFixedThreadPool(config.threadSize);
            this.completionService = new ExecutorCompletionService(this.executor);
            this.cache = cache;
            Worker[] workers = new Worker[config.threadSize];
            for (int i = 0; i < config.threadSize; ++i) {
                workers[i] = new Worker();
            }
            this.workers = workers;
        }

        private void start() {
            for (Worker worker : this.workers) {
                this.completionService.submit(worker);
            }
        }

        private void stop() {
            try {
                for (int i = 0; i < this.config.threadSize; ++i) {
                    this.completionService.take().get();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                TestCase.fail();
            }
        }

        public long perform() {
            long time = -System.currentTimeMillis();
            this.start();
            this.stop();
            if (this.cache instanceof ConcurrentFIFOExoCache) {
                ((ConcurrentFIFOExoCache)this.cache).assertConsistent();
            }
            return time += System.currentTimeMillis();
        }

        private class Worker
        implements Callable<Worker> {
            private final Serializable[] keys;
            private final Object[] objects;
            private final Random random = new Random();

            private Worker() {
                this.keys = new Serializable[Test.this.config.objectSize];
                this.objects = new Object[Test.this.config.objectSize];
                for (int i = 0; i < Test.this.config.objectSize; ++i) {
                    this.keys[i] = new Key();
                    this.objects[i] = new Object();
                }
            }

            @Override
            public Worker call() throws Exception {
                int gets = Test.this.config.getSize;
                int puts = Test.this.config.putSize;
                int removals = Test.this.config.removalSize;
                while (gets > 0 || puts > 0 || removals > 0) {
                    int entry = Math.abs(this.random.nextInt()) % this.objects.length;
                    int decision = Math.abs(this.random.nextInt()) % (gets + puts + removals);
                    Serializable key = this.keys[entry];
                    if (decision < gets) {
                        Test.this.cache.get(key);
                        --gets;
                        continue;
                    }
                    if (decision >= gets && decision < gets + puts) {
                        Object object = this.objects[entry];
                        Test.this.cache.put(key, object);
                        --puts;
                        continue;
                    }
                    Test.this.cache.remove(key);
                    --removals;
                }
                return this;
            }
        }

        private static class Key
        implements Serializable {
            private Key() {
            }
        }
    }

    private static class SimpleCacheListener
    implements CacheListener<Serializable, Object> {
        private SimpleCacheListener() {
        }

        public void onGet(CacheListenerContext context, Serializable key, Object obj) throws Exception {
        }

        public void onExpire(CacheListenerContext context, Serializable key, Object obj) throws Exception {
            this.doWait();
        }

        public void onRemove(CacheListenerContext context, Serializable key, Object obj) throws Exception {
            this.doWait();
        }

        public void onPut(CacheListenerContext context, Serializable key, Object obj) throws Exception {
            this.doWait();
        }

        public void onClearCache(CacheListenerContext context) throws Exception {
            this.doWait();
        }

        private void doWait() throws Exception {
            Thread.sleep(1L);
        }
    }
}

