/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.listener;

import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.container.component.ThreadContextHandler;
import org.exoplatform.container.spi.DefinitionByType;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.listener.Asynchronous;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.listener.ListenerBase;
import org.exoplatform.services.listener.ListenerThreadFactory;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.naming.InitialContextInitializer;
import org.picocontainer.Startable;

@DefinitionByType
public class ListenerService
implements Startable {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.kernel.component.common.ListenerService");
    private final ExecutorService executor;
    private final Map<String, List<ListenerBase>> listeners = new ConcurrentHashMap<String, List<ListenerBase>>();
    private final ExoContainer container;

    public ListenerService(ExoContainerContext ctx) {
        this(ctx, null, null);
    }

    public ListenerService(ExoContainerContext ctx, InitialContextInitializer initializer) {
        this(ctx, initializer, null);
    }

    public ListenerService(ExoContainerContext ctx, InitParams params) {
        this(ctx, null, params);
    }

    public ListenerService(ExoContainerContext ctx, InitialContextInitializer initializer, InitParams params) {
        this.container = ctx.getContainer();
        int poolSize = 1;
        if (params != null && params.getValueParam("asynchPoolSize") != null) {
            poolSize = Integer.parseInt(params.getValueParam("asynchPoolSize").getValue());
        }
        this.executor = Executors.newFixedThreadPool(poolSize, new ListenerThreadFactory());
    }

    public <S, D> void addListener(Listener<S, D> listener) {
        this.addListener(listener.getName(), listener);
    }

    public void addListener(String eventName, ListenerBase listener) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Adding listener {} on event {}", new Object[]{listener.getName(), eventName});
        }
        Class<?> listenerClass = listener.getClass();
        do {
            if (!listenerClass.isAnnotationPresent(Asynchronous.class)) continue;
            listener = new AsynchronousListener(listener);
            break;
        } while ((listenerClass = listenerClass.getSuperclass()) != null);
        this.listeners.computeIfAbsent(eventName, k -> new Vector()).add(listener);
    }

    public <S, D> void broadcast(String name, S source, D data) {
        List<ListenerBase> list = this.listeners.get(name);
        if (list == null) {
            return;
        }
        for (ListenerBase listener : list) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("broadcasting event " + name + " on " + listener.getName()));
            }
            try {
                listener.onEvent(new Event<S, D>(name, source, data));
            }
            catch (Exception e) {
                LOG.warn("Exception on broadcasting events occurred while broadcasting event {}. Continue braodcasting events.", new Object[]{name, e});
            }
        }
    }

    public <T extends Event> void broadcast(T event) {
        List<ListenerBase> list = this.listeners.get(event.getEventName());
        if (list == null) {
            return;
        }
        for (ListenerBase listener : list) {
            try {
                listener.onEvent(event);
            }
            catch (Exception e) {
                LOG.warn("Exception on broadcasting events occurred while broadcasting event {}. Continue braodcasting events.", new Object[]{event.getEventName(), e});
            }
        }
    }

    public void stop() {
        this.executor.shutdown();
    }

    protected class AsynchronousListener<S, D>
    implements ListenerBase<S, D> {
        private ListenerBase<S, D> listener;

        public AsynchronousListener(ListenerBase<S, D> listener) {
            this.listener = listener;
        }

        @Override
        public void onEvent(Event<S, D> event) {
            ListenerService.this.executor.execute(new RunListener<S, D>(this.listener, event));
        }
    }

    protected class RunListener<S, D>
    implements Runnable {
        private ListenerBase<S, D> listener;
        private Event<S, D> event;
        private final ThreadContextHandler handler;

        public RunListener(ListenerBase<S, D> listener, Event<S, D> event) {
            this.listener = listener;
            this.event = event;
            this.handler = new ThreadContextHandler(ListenerService.this.container);
            this.handler.store();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ExoContainerContext.setCurrentContainer((ExoContainer)ListenerService.this.container);
            RequestLifeCycle.begin((ExoContainer)ListenerService.this.container);
            try {
                this.handler.push();
                this.listener.onEvent(this.event);
            }
            catch (Exception e) {
                LOG.error((Object)("Exception on broadcasting events occurs: " + e.getMessage()), (Throwable)e);
            }
            finally {
                try {
                    this.handler.restore();
                    RequestLifeCycle.end();
                }
                finally {
                    ExoContainerContext.setCurrentContainer(null);
                }
            }
        }
    }
}

