/**
 * This file is part of the Meeds project (https://meeds.io/).
 *
 * Copyright (C) 2020 - 2025 Meeds Association contact@meeds.io
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */
package org.exoplatform.container.management;

import org.exoplatform.management.spi.*;
import org.exoplatform.management.spi.ManagedResource;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ManagementProviderImpl implements ManagementProvider
{

   /** . */
   final List<org.exoplatform.container.management.ManagedResource> managedResources = new ArrayList<org.exoplatform.container.management.ManagedResource>();

   /** . */
   final List<Object> resources = new ArrayList<Object>();

   public Object manage(ManagedResource context)
   {
      org.exoplatform.container.management.ManagedResource mr = new org.exoplatform.container.management.ManagedResource(context.getResource(), context, context.getMetaData());
      managedResources.add(mr);
      resources.add(mr.resource);
      return mr.key;
   }

   public void unmanage(Object key)
   {
      for (Iterator<org.exoplatform.container.management.ManagedResource> i = managedResources.iterator();i.hasNext();)
      {
         org.exoplatform.container.management.ManagedResource mr = i.next();
         if (mr.key == key)
         {
            i.remove();
            break;
         }
      }
   }
}
