/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container;

import org.exoplatform.container.ComponentWithRequestLifeCycle;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.RootContainer;
import org.exoplatform.container.component.ComponentRequestLifecycle;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.container.jmx.AbstractTestContainer;

public class TestRequestLifeCycle
extends AbstractTestContainer {
    private ExoContainer parent;
    private ExoContainer child;
    private ComponentWithRequestLifeCycle a;
    private ComponentWithRequestLifeCycle b;

    protected void setUp() throws Exception {
        RootContainer parent = this.createRootContainer("request-lifecycle-configuration.xml");
        ExoContainer child = new ExoContainer((ExoContainer)parent);
        ComponentWithRequestLifeCycle a = (ComponentWithRequestLifeCycle)parent.getComponentInstance((Object)"A");
        TestRequestLifeCycle.assertNotNull((Object)a);
        child.registerComponentInstance((Object)"B", (Object)new ComponentWithRequestLifeCycle());
        ComponentWithRequestLifeCycle b = (ComponentWithRequestLifeCycle)child.getComponentInstance((Object)"B");
        this.parent = parent;
        this.child = child;
        this.a = a;
        this.b = b;
    }

    public void testObject() {
        RequestLifeCycle.begin((ComponentRequestLifecycle)this.a);
        this.a.assertLifeCycle(true, null);
        this.b.assertEmpty();
        RequestLifeCycle.end();
        this.a.assertLifeCycle(false, null);
        this.b.assertEmpty();
    }

    public void testContainerObject() {
        RequestLifeCycle.begin((ExoContainer)this.parent, (boolean)false);
        this.a.assertLifeCycle(true, this.parent);
        this.b.assertEmpty();
        RequestLifeCycle.begin((ComponentRequestLifecycle)this.a);
        this.a.assertEmpty();
        this.b.assertEmpty();
        RequestLifeCycle.end();
        this.a.assertEmpty();
        this.b.assertEmpty();
        RequestLifeCycle.end();
        this.a.assertLifeCycle(false, this.parent);
        this.b.assertEmpty();
    }

    public void testObjectContainer() {
        RequestLifeCycle.begin((ComponentRequestLifecycle)this.a);
        this.a.assertLifeCycle(true, null);
        this.b.assertEmpty();
        RequestLifeCycle.begin((ExoContainer)this.parent, (boolean)false);
        this.a.assertEmpty();
        this.b.assertEmpty();
        RequestLifeCycle.end();
        this.a.assertEmpty();
        this.b.assertEmpty();
        RequestLifeCycle.end();
        this.a.assertLifeCycle(false, null);
        this.b.assertEmpty();
    }

    public void testParent() {
        RequestLifeCycle.begin((ExoContainer)this.parent, (boolean)false);
        this.a.assertLifeCycle(true, this.parent);
        this.b.assertEmpty();
        RequestLifeCycle.end();
        this.a.assertLifeCycle(false, this.parent);
        this.b.assertEmpty();
    }

    public void testLocalParent() {
        RequestLifeCycle.begin((ExoContainer)this.parent, (boolean)true);
        this.a.assertLifeCycle(true, this.parent);
        this.b.assertEmpty();
        RequestLifeCycle.end();
        this.a.assertLifeCycle(false, this.parent);
        this.b.assertEmpty();
    }

    public void testChild() {
        RequestLifeCycle.begin((ExoContainer)this.child, (boolean)false);
        this.a.assertLifeCycle(true, this.child);
        this.b.assertLifeCycle(true, this.child);
        RequestLifeCycle.end();
        this.a.assertLifeCycle(false, this.child);
        this.b.assertLifeCycle(false, this.child);
    }

    public void testLocalChild() {
        RequestLifeCycle.begin((ExoContainer)this.child, (boolean)true);
        this.a.assertEmpty();
        this.b.assertLifeCycle(true, this.child);
        RequestLifeCycle.end();
        this.a.assertEmpty();
        this.b.assertLifeCycle(false, this.child);
    }

    public void testParentParent() {
        RequestLifeCycle.begin((ExoContainer)this.parent, (boolean)false);
        this.a.assertLifeCycle(true, this.parent);
        this.b.assertEmpty();
        RequestLifeCycle.begin((ExoContainer)this.parent, (boolean)false);
        this.a.assertEmpty();
        this.b.assertEmpty();
        RequestLifeCycle.end();
        this.a.assertEmpty();
        this.b.assertEmpty();
        RequestLifeCycle.end();
        this.a.assertLifeCycle(false, this.parent);
        this.b.assertEmpty();
    }

    public void testChildChild() {
        RequestLifeCycle.begin((ExoContainer)this.child, (boolean)false);
        this.a.assertLifeCycle(true, this.child);
        this.b.assertLifeCycle(true, this.child);
        RequestLifeCycle.begin((ExoContainer)this.child, (boolean)false);
        this.a.assertEmpty();
        this.b.assertEmpty();
        RequestLifeCycle.end();
        this.a.assertEmpty();
        this.b.assertEmpty();
        RequestLifeCycle.end();
        this.a.assertLifeCycle(false, this.child);
        this.b.assertLifeCycle(false, this.child);
    }

    public void testChildParent() {
        RequestLifeCycle.begin((ExoContainer)this.child, (boolean)false);
        this.a.assertLifeCycle(true, this.child);
        this.b.assertLifeCycle(true, this.child);
        RequestLifeCycle.begin((ExoContainer)this.parent, (boolean)false);
        this.a.assertEmpty();
        this.b.assertEmpty();
        RequestLifeCycle.end();
        this.a.assertEmpty();
        this.b.assertEmpty();
        RequestLifeCycle.end();
        this.a.assertLifeCycle(false, this.child);
        this.b.assertLifeCycle(false, this.child);
    }

    public void testLocalChildParent() {
        RequestLifeCycle.begin((ExoContainer)this.child, (boolean)true);
        this.a.assertEmpty();
        this.b.assertLifeCycle(true, this.child);
        RequestLifeCycle.begin((ExoContainer)this.parent, (boolean)true);
        this.a.assertLifeCycle(true, this.parent);
        this.b.assertEmpty();
        RequestLifeCycle.end();
        this.a.assertLifeCycle(false, this.parent);
        this.b.assertEmpty();
        RequestLifeCycle.end();
        this.a.assertEmpty();
        this.b.assertLifeCycle(false, this.child);
    }

    public void testParentChild() {
        RequestLifeCycle.begin((ExoContainer)this.parent, (boolean)false);
        this.a.assertLifeCycle(true, this.parent);
        this.b.assertEmpty();
        RequestLifeCycle.begin((ExoContainer)this.child, (boolean)false);
        this.a.assertEmpty();
        this.b.assertLifeCycle(true, this.child);
        RequestLifeCycle.end();
        this.a.assertEmpty();
        this.b.assertLifeCycle(false, this.child);
        RequestLifeCycle.end();
        this.a.assertLifeCycle(false, this.parent);
        this.b.assertEmpty();
    }

    public void testLocalParentChild() {
        RequestLifeCycle.begin((ExoContainer)this.parent, (boolean)true);
        this.a.assertLifeCycle(true, this.parent);
        this.b.assertEmpty();
        RequestLifeCycle.begin((ExoContainer)this.child, (boolean)true);
        this.a.assertEmpty();
        this.b.assertLifeCycle(true, this.child);
        RequestLifeCycle.end();
        this.a.assertEmpty();
        this.b.assertLifeCycle(false, this.child);
        RequestLifeCycle.end();
        this.a.assertLifeCycle(false, this.parent);
        this.b.assertEmpty();
    }

    public void testIsStartedLifeCycleOnContainer() {
        TestRequestLifeCycle.assertFalse((boolean)this.a.isStarted(this.child));
        TestRequestLifeCycle.assertFalse((boolean)this.b.isStarted(this.child));
        TestRequestLifeCycle.assertFalse((boolean)RequestLifeCycle.isStarted((ExoContainer)this.child, (boolean)false));
        RequestLifeCycle.begin((ExoContainer)this.child, (boolean)false);
        TestRequestLifeCycle.assertTrue((boolean)RequestLifeCycle.isStarted((ExoContainer)this.child, (boolean)false));
        TestRequestLifeCycle.assertTrue((boolean)this.a.isStarted(this.child));
        TestRequestLifeCycle.assertTrue((boolean)this.b.isStarted(this.child));
        this.a.setStarted(false);
        TestRequestLifeCycle.assertFalse((boolean)this.a.isStarted(this.child));
        TestRequestLifeCycle.assertTrue((boolean)this.b.isStarted(this.child));
        RequestLifeCycle.begin((ExoContainer)this.child, (boolean)false);
        TestRequestLifeCycle.assertTrue((boolean)this.a.isStarted(this.child));
        TestRequestLifeCycle.assertTrue((boolean)this.b.isStarted(this.child));
        RequestLifeCycle.end();
        TestRequestLifeCycle.assertTrue((boolean)this.a.isStarted(this.child));
        TestRequestLifeCycle.assertTrue((boolean)this.b.isStarted(this.child));
        RequestLifeCycle.end();
        TestRequestLifeCycle.assertFalse((boolean)this.a.isStarted(this.child));
        TestRequestLifeCycle.assertFalse((boolean)this.b.isStarted(this.child));
    }

    public void testIsStartedLifeCycle() {
        TestRequestLifeCycle.assertFalse((boolean)this.a.isStarted(this.child));
        TestRequestLifeCycle.assertFalse((boolean)RequestLifeCycle.isStarted((ComponentRequestLifecycle)this.a));
        RequestLifeCycle.begin((ComponentRequestLifecycle)this.a);
        TestRequestLifeCycle.assertTrue((boolean)RequestLifeCycle.isStarted((ComponentRequestLifecycle)this.a));
        TestRequestLifeCycle.assertTrue((boolean)this.a.isStarted(this.child));
        this.a.setStarted(false);
        TestRequestLifeCycle.assertFalse((boolean)this.a.isStarted(this.child));
        RequestLifeCycle.begin((ComponentRequestLifecycle)this.a);
        TestRequestLifeCycle.assertTrue((boolean)this.a.isStarted(this.child));
        RequestLifeCycle.end();
        TestRequestLifeCycle.assertTrue((boolean)this.a.isStarted(this.child));
        RequestLifeCycle.end();
        TestRequestLifeCycle.assertFalse((boolean)this.a.isStarted(this.child));
    }
}

