/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container.management.metadata;

import java.util.HashMap;
import java.util.Map;
import junit.framework.TestCase;
import org.exoplatform.container.management.MetaDataBuilder;
import org.exoplatform.container.management.metadata.Bar;
import org.exoplatform.container.management.metadata.Foo;
import org.exoplatform.management.annotations.ImpactType;
import org.exoplatform.management.spi.ManagedMethodMetaData;
import org.exoplatform.management.spi.ManagedTypeMetaData;

public class TestMetaData
extends TestCase {
    private Map<String, ManagedMethodMetaData> getMethodMap(ManagedTypeMetaData type) {
        HashMap<String, ManagedMethodMetaData> methodMap = new HashMap<String, ManagedMethodMetaData>();
        for (ManagedMethodMetaData method : type.getMethods()) {
            methodMap.put(method.getName(), method);
        }
        return methodMap;
    }

    public void testImpact() {
        MetaDataBuilder builder = new MetaDataBuilder(Foo.class);
        ManagedTypeMetaData type = builder.build();
        Map<String, ManagedMethodMetaData> methodMap = this.getMethodMap(type);
        ManagedMethodMetaData read = methodMap.get("read");
        TestMetaData.assertEquals((Object)ImpactType.READ, (Object)read.getImpact());
        ManagedMethodMetaData write = methodMap.get("write");
        TestMetaData.assertEquals((Object)ImpactType.WRITE, (Object)write.getImpact());
        ManagedMethodMetaData idempotentWrite = methodMap.get("idempotentWrite");
        TestMetaData.assertEquals((Object)ImpactType.IDEMPOTENT_WRITE, (Object)idempotentWrite.getImpact());
    }

    public void testMethodNameOverride() {
        MetaDataBuilder builder = new MetaDataBuilder(Bar.class);
        try {
            builder.build();
            TestMetaData.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

