/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container.component;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.component.ComponentRequestLifecycle;
import org.exoplatform.container.component.RequestLifeCycle;

class RequestLifeCycleStack
extends LinkedList<RequestLifeCycle> {
    private final Set<ComponentRequestLifecycle> allComponents = new HashSet<ComponentRequestLifecycle>();

    RequestLifeCycleStack() {
    }

    void begin(ComponentRequestLifecycle lifeCycle) {
        if (this.allComponents.contains(lifeCycle)) {
            if (!lifeCycle.isStarted(null)) {
                lifeCycle.startRequest(null);
            }
            this.addLast(new RequestLifeCycle(null, Collections.emptyList()));
        } else {
            RequestLifeCycle requestLF = new RequestLifeCycle(null, Collections.singletonList(lifeCycle));
            this.allComponents.add(lifeCycle);
            this.addLast(requestLF);
            requestLF.doBegin();
        }
    }

    void begin(ExoContainer container, boolean local) {
        List<ComponentRequestLifecycle> components = this.getAllComponentsRequestLifecycle(container, local);
        for (ComponentRequestLifecycle c : this.allComponents) {
            if (c.isStarted(container)) continue;
            c.startRequest(container);
        }
        components.removeAll(this.allComponents);
        this.allComponents.addAll(components);
        RequestLifeCycle lifeCycle = new RequestLifeCycle(container, components);
        this.addLast(lifeCycle);
        lifeCycle.doBegin();
    }

    Map<Object, Throwable> end() {
        RequestLifeCycle lifeCycle = (RequestLifeCycle)this.removeLast();
        IdentityHashMap<Object, Throwable> result = lifeCycle.doEnd();
        this.allComponents.removeAll(result.keySet());
        return result;
    }

    boolean isStarted(ExoContainer container, boolean local) {
        List<ComponentRequestLifecycle> components = this.getAllComponentsRequestLifecycle(container, local);
        for (ComponentRequestLifecycle c : components) {
            if (this.isStarted(c)) continue;
            return false;
        }
        return true;
    }

    boolean isStarted(ComponentRequestLifecycle lifeCycle) {
        return this.allComponents.contains(lifeCycle) && lifeCycle.isStarted(null);
    }

    private List<ComponentRequestLifecycle> getAllComponentsRequestLifecycle(ExoContainer container, boolean local) {
        ArrayList<ComponentRequestLifecycle> components = new ArrayList<ComponentRequestLifecycle>(container.getComponentInstancesOfType(ComponentRequestLifecycle.class));
        if (!local) {
            for (ExoContainer current = container.getParent(); current != null; current = current.getParent()) {
                components.addAll(current.getComponentInstancesOfType(ComponentRequestLifecycle.class));
            }
        }
        return components;
    }
}

