/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container;

import java.util.Arrays;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.RootContainer;
import org.exoplatform.container.component.ThreadContext;
import org.exoplatform.container.component.ThreadContextHandler;
import org.exoplatform.container.component.ThreadContextHolder;
import org.exoplatform.container.jmx.AbstractTestContainer;

public class TestThreadContextHandler
extends AbstractTestContainer {
    private ThreadContextHandler handler;
    private TestHolder holder;
    private TestHolder6 holder6;

    protected void setUp() throws Exception {
        RootContainer container = this.createRootContainer("thread-context-handler-configuration.xml");
        this.handler = new ThreadContextHandler((ExoContainer)container);
        this.holder = (TestHolder)container.getComponentInstanceOfType(TestHolder.class);
        this.holder6 = (TestHolder6)container.getComponentInstanceOfType(TestHolder6.class);
    }

    public void testTLNullValue() {
        TestThreadContextHandler.assertNull((Object)this.holder.tl.get());
        TestThreadContextHandler.assertNull((Object)this.holder6.tl.get());
        TestThreadContextHandler.assertNull((Object)this.holder6.tl2.get());
        TestThreadContextHandler.assertNull((Object)this.holder6.tl3.get());
        this.handler.store();
        this.holder.tl.set("foo");
        this.holder6.tl.set("foo");
        this.holder6.tl2.set("foo");
        this.holder6.tl3.set("foo");
        this.handler.push();
        TestThreadContextHandler.assertNull((Object)this.holder.tl.get());
        TestThreadContextHandler.assertNull((Object)this.holder6.tl.get());
        TestThreadContextHandler.assertNull((Object)this.holder6.tl2.get());
        TestThreadContextHandler.assertNull((Object)this.holder6.tl3.get());
        this.handler.restore();
        TestThreadContextHandler.assertEquals((String)"foo", (String)this.holder.tl.get());
        TestThreadContextHandler.assertEquals((String)"foo", (String)this.holder6.tl.get());
        TestThreadContextHandler.assertEquals((String)"foo", (String)this.holder6.tl2.get());
        TestThreadContextHandler.assertEquals((String)"foo", (String)this.holder6.tl3.get());
    }

    public void testTLNotNullValue() {
        this.holder.tl.set("foo");
        this.holder6.tl.set("foo");
        this.holder6.tl2.set("foo");
        this.holder6.tl3.set("foo");
        this.handler.store();
        TestThreadContextHandler.assertEquals((String)"foo", (String)this.holder.tl.get());
        TestThreadContextHandler.assertEquals((String)"foo", (String)this.holder6.tl.get());
        TestThreadContextHandler.assertEquals((String)"foo", (String)this.holder6.tl2.get());
        TestThreadContextHandler.assertEquals((String)"foo", (String)this.holder6.tl3.get());
        this.holder.tl.set("foo2");
        this.holder6.tl.set("foo2");
        this.holder6.tl2.set("foo2");
        this.holder6.tl3.set("foo2");
        this.handler.push();
        TestThreadContextHandler.assertEquals((String)"foo", (String)this.holder.tl.get());
        TestThreadContextHandler.assertEquals((String)"foo", (String)this.holder6.tl.get());
        TestThreadContextHandler.assertEquals((String)"foo", (String)this.holder6.tl2.get());
        TestThreadContextHandler.assertEquals((String)"foo", (String)this.holder6.tl3.get());
        this.handler.restore();
        TestThreadContextHandler.assertEquals((String)"foo2", (String)this.holder.tl.get());
        TestThreadContextHandler.assertEquals((String)"foo2", (String)this.holder6.tl.get());
        TestThreadContextHandler.assertEquals((String)"foo2", (String)this.holder6.tl2.get());
        TestThreadContextHandler.assertEquals((String)"foo2", (String)this.holder6.tl3.get());
    }

    public static class TestHolder
    implements ThreadContextHolder {
        public ThreadLocal<String> tl = new ThreadLocal();

        public ThreadContext getThreadContext() {
            return new ThreadContext(new ThreadLocal[]{this.tl});
        }
    }

    public static class TestHolder6
    implements ThreadContextHolder {
        public ThreadLocal<String> tl = new ThreadLocal();
        public ThreadLocal<String> tl2 = new ThreadLocal();
        public ThreadLocal<String> tl3 = new ThreadLocal();

        public ThreadContext getThreadContext() {
            return ThreadContext.merge(Arrays.asList(new ThreadContext(new ThreadLocal[]{this.tl}), null, new ThreadContext(new ThreadLocal[0]), new ThreadContext(null), new ThreadContext(new ThreadLocal[]{this.tl2, null, this.tl3})));
        }
    }

    public static class TestHolder5
    implements ThreadContextHolder {
        public ThreadLocal<String> tl = new ThreadLocal();

        public ThreadContext getThreadContext() {
            return new ThreadContext(new ThreadLocal[]{this.tl, null, this.tl});
        }
    }

    public static class TestHolder4
    implements ThreadContextHolder {
        public ThreadContext getThreadContext() {
            return new ThreadContext(null);
        }
    }

    public static class TestHolder3
    implements ThreadContextHolder {
        public ThreadContext getThreadContext() {
            return new ThreadContext(new ThreadLocal[0]);
        }
    }

    public static class TestHolder2
    implements ThreadContextHolder {
        public ThreadContext getThreadContext() {
            return null;
        }
    }
}

