/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container.jmx;

import javax.management.MBeanAttributeInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.modelmbean.ModelMBeanOperationInfo;
import org.exoplatform.container.jmx.AbstractExoMBeanTest;
import org.exoplatform.management.annotations.Impact;
import org.exoplatform.management.annotations.ImpactType;
import org.exoplatform.management.annotations.Managed;
import org.exoplatform.management.annotations.ManagedDescription;
import org.exoplatform.management.annotations.ManagedName;

public class TestExoMBeanOperation
extends AbstractExoMBeanTest {
    public void test1() throws Exception {
        AbstractExoMBeanTest.Bean bean = this.register("domain:name=mbean", MBean1.class);
        MBeanOperationInfo[] operationInfos = bean.info.getOperations();
        TestExoMBeanOperation.assertNotNull((Object)operationInfos);
        TestExoMBeanOperation.assertEquals((int)0, (int)operationInfos.length);
        MBeanAttributeInfo[] mbeanAttributeInfos = bean.info.getAttributes();
        TestExoMBeanOperation.assertNotNull((Object)mbeanAttributeInfos);
        TestExoMBeanOperation.assertEquals((int)0, (int)mbeanAttributeInfos.length);
    }

    public void test2() throws Exception {
        AbstractExoMBeanTest.Bean bean = this.register("domain:name=mbean", MBean2.class);
        MBeanOperationInfo[] operationInfos = bean.info.getOperations();
        TestExoMBeanOperation.assertNotNull((Object)operationInfos);
        TestExoMBeanOperation.assertEquals((int)1, (int)operationInfos.length);
        MBeanOperationInfo operationInfo = operationInfos[0];
        TestExoMBeanOperation.assertNotNull((Object)operationInfo);
        TestExoMBeanOperation.assertEquals((String)"op", (String)operationInfo.getName());
        TestExoMBeanOperation.assertEquals((String)"op_desc", (String)operationInfo.getDescription());
        TestExoMBeanOperation.assertEquals((String)"java.lang.String", (String)operationInfo.getReturnType());
        MBeanParameterInfo[] parameterInfos = operationInfo.getSignature();
        TestExoMBeanOperation.assertNotNull((Object)parameterInfos);
        TestExoMBeanOperation.assertEquals((int)1, (int)parameterInfos.length);
        MBeanParameterInfo parameterInfo = parameterInfos[0];
        TestExoMBeanOperation.assertNotNull((Object)parameterInfo);
        TestExoMBeanOperation.assertEquals((String)"arg_desc", (String)parameterInfo.getDescription());
        TestExoMBeanOperation.assertEquals((String)"java.lang.Integer", (String)parameterInfo.getType());
        MBeanAttributeInfo[] mbeanAttributeInfos = bean.info.getAttributes();
        TestExoMBeanOperation.assertNotNull((Object)mbeanAttributeInfos);
        TestExoMBeanOperation.assertEquals((int)0, (int)mbeanAttributeInfos.length);
        TestExoMBeanOperation.assertEquals((Object)"5", (Object)this.server.invoke(bean.name, "op", new Object[]{5}, new String[]{"java.lang.Integer"}));
    }

    public void test3() throws Exception {
        AbstractExoMBeanTest.Bean bean = this.register("domain:name=mbean", MBean3.class);
        MBeanOperationInfo[] operationInfos = bean.info.getOperations();
        TestExoMBeanOperation.assertNotNull((Object)operationInfos);
        TestExoMBeanOperation.assertEquals((int)1, (int)operationInfos.length);
        MBeanOperationInfo operationInfo = operationInfos[0];
        TestExoMBeanOperation.assertNotNull((Object)operationInfo);
        TestExoMBeanOperation.assertEquals((String)"op", (String)operationInfo.getName());
        TestExoMBeanOperation.assertEquals((String)"java.lang.String", (String)operationInfo.getReturnType());
        MBeanParameterInfo[] parameterInfos = operationInfo.getSignature();
        TestExoMBeanOperation.assertNotNull((Object)parameterInfos);
        TestExoMBeanOperation.assertEquals((int)1, (int)parameterInfos.length);
        MBeanParameterInfo parameterInfo = parameterInfos[0];
        TestExoMBeanOperation.assertNotNull((Object)parameterInfo);
        TestExoMBeanOperation.assertEquals((String)"_arg", (String)parameterInfo.getName());
        TestExoMBeanOperation.assertEquals((String)"java.lang.Integer", (String)parameterInfo.getType());
        MBeanAttributeInfo[] mbeanAttributeInfos = bean.info.getAttributes();
        TestExoMBeanOperation.assertNotNull((Object)mbeanAttributeInfos);
        TestExoMBeanOperation.assertEquals((int)0, (int)mbeanAttributeInfos.length);
        TestExoMBeanOperation.assertEquals((Object)"7", (Object)this.server.invoke(bean.name, "op", new Object[]{7}, new String[]{"java.lang.Integer"}));
    }

    public void test4() throws Exception {
        AbstractExoMBeanTest.Bean bean = this.register("domain:name=mbean", MBean4.class);
        MBeanOperationInfo[] operationInfos = bean.info.getOperations();
        TestExoMBeanOperation.assertNotNull((Object)operationInfos);
        TestExoMBeanOperation.assertEquals((int)2, (int)operationInfos.length);
        ModelMBeanOperationInfo operation1Info = bean.info.getOperation("op1");
        TestExoMBeanOperation.assertNotNull((Object)operation1Info);
        TestExoMBeanOperation.assertEquals((String)"op1", (String)operation1Info.getName());
        TestExoMBeanOperation.assertEquals((String)"java.lang.String", (String)operation1Info.getReturnType());
        MBeanParameterInfo[] operation1ParameterInfos = operation1Info.getSignature();
        TestExoMBeanOperation.assertNotNull((Object)operation1ParameterInfos);
        TestExoMBeanOperation.assertEquals((int)1, (int)operation1ParameterInfos.length);
        MBeanParameterInfo operation1ParameterInfo = operation1ParameterInfos[0];
        TestExoMBeanOperation.assertNotNull((Object)operation1ParameterInfo);
        TestExoMBeanOperation.assertEquals((String)"java.lang.Boolean", (String)operation1ParameterInfo.getType());
        ModelMBeanOperationInfo operation2Info = bean.info.getOperation("op2");
        TestExoMBeanOperation.assertNotNull((Object)operation2Info);
        TestExoMBeanOperation.assertEquals((String)"op2", (String)operation2Info.getName());
        TestExoMBeanOperation.assertEquals((String)"java.lang.String", (String)operation2Info.getReturnType());
        MBeanParameterInfo[] operation2ParameterInfos = operation2Info.getSignature();
        TestExoMBeanOperation.assertNotNull((Object)operation2ParameterInfos);
        TestExoMBeanOperation.assertEquals((int)1, (int)operation2ParameterInfos.length);
        MBeanParameterInfo operation2ParameterInfo = operation2ParameterInfos[0];
        TestExoMBeanOperation.assertNotNull((Object)operation2ParameterInfo);
        TestExoMBeanOperation.assertEquals((String)"java.lang.Integer", (String)operation2ParameterInfo.getType());
        MBeanAttributeInfo[] mbeanAttributeInfos = bean.info.getAttributes();
        TestExoMBeanOperation.assertNotNull((Object)mbeanAttributeInfos);
        TestExoMBeanOperation.assertEquals((int)0, (int)mbeanAttributeInfos.length);
        TestExoMBeanOperation.assertEquals((Object)"true", (Object)this.server.invoke(bean.name, "op1", new Object[]{true}, new String[]{"java.lang.Boolean"}));
        TestExoMBeanOperation.assertEquals((Object)"7", (Object)this.server.invoke(bean.name, "op2", new Object[]{7}, new String[]{"java.lang.Integer"}));
    }

    public void test5() {
        this.assertNotBuildable(MBean5.class);
    }

    public void test6() throws Exception {
        AbstractExoMBeanTest.Bean bean = this.register("domain:name=mbean", MBean6.class);
        MBeanOperationInfo[] operationInfos = bean.info.getOperations();
        TestExoMBeanOperation.assertNotNull((Object)operationInfos);
        TestExoMBeanOperation.assertEquals((int)4, (int)operationInfos.length);
        ModelMBeanOperationInfo readInfo = bean.info.getOperation("read");
        TestExoMBeanOperation.assertNotNull((Object)readInfo);
        TestExoMBeanOperation.assertEquals((int)0, (int)readInfo.getImpact());
        ModelMBeanOperationInfo writeInfo = bean.info.getOperation("write");
        TestExoMBeanOperation.assertNotNull((Object)writeInfo);
        TestExoMBeanOperation.assertEquals((int)1, (int)writeInfo.getImpact());
        ModelMBeanOperationInfo idempotentWriteInfo = bean.info.getOperation("idempotentWrite");
        TestExoMBeanOperation.assertNotNull((Object)idempotentWriteInfo);
        TestExoMBeanOperation.assertEquals((int)1, (int)idempotentWriteInfo.getImpact());
        ModelMBeanOperationInfo defaultImpactInfo = bean.info.getOperation("defaultImpact");
        TestExoMBeanOperation.assertNotNull((Object)defaultImpactInfo);
        TestExoMBeanOperation.assertEquals((int)1, (int)defaultImpactInfo.getImpact());
    }

    @Managed
    public static class MBean1 {
        public String op(Object arg) {
            return null;
        }
    }

    @Managed
    public static class MBean2 {
        @Managed
        @ManagedDescription(value="op_desc")
        public String op(@ManagedDescription(value="arg_desc") Integer arg) {
            return Integer.toString(arg);
        }
    }

    @Managed
    public static class MBean3 {
        @Managed
        public String op(@ManagedName(value="_arg") Integer arg) {
            return Integer.toString(arg);
        }
    }

    @Managed
    public static class MBean4
    extends ParentMBean4 {
        @Managed
        public String op2(Integer arg) {
            return Integer.toString(arg);
        }
    }

    @Managed
    public static class MBean5 {
        @Managed
        @ManagedName(value="foo")
        public String op2(Integer arg) {
            return Integer.toString(arg);
        }
    }

    @Managed
    public static class MBean6 {
        @Managed
        @Impact(value=ImpactType.READ)
        public void read() {
        }

        @Managed
        @Impact(value=ImpactType.WRITE)
        public void write() {
        }

        @Managed
        @Impact(value=ImpactType.IDEMPOTENT_WRITE)
        public void idempotentWrite() {
        }

        @Managed
        public void defaultImpact() {
        }
    }

    public static class ParentMBean4 {
        @Managed
        public String op1(Boolean arg) {
            return Boolean.toString(arg);
        }
    }
}

