/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.xml.test;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.exoplatform.xml.object.XMLCollection;
import org.exoplatform.xml.object.XMLObject;
import org.jibx.runtime.BindingDirectory;
import org.jibx.runtime.IBindingFactory;
import org.jibx.runtime.IMarshallingContext;
import org.jibx.runtime.IUnmarshallingContext;

public class TestDataXML
extends TestCase {
    public void testMarshallAndUnmarshall() throws Exception {
        String projectdir = System.getProperty("basedir");
        IBindingFactory bfact = BindingDirectory.getFactory(XMLObject.class);
        IUnmarshallingContext uctx = bfact.createUnmarshallingContext();
        URL url = TestDataXML.class.getResource("../../../../object.xml");
        Object obj = uctx.unmarshalDocument(url.openStream(), null);
        IMarshallingContext mctx = bfact.createMarshallingContext();
        mctx.setIndent(2);
        mctx.marshalDocument(obj, "UTF-8", null, (OutputStream)new FileOutputStream(projectdir + "/target/object.xml"));
    }

    public void testConvert() throws Exception {
        String projectdir = System.getProperty("basedir");
        XMLObject xmlobj = new XMLObject((Object)new TestObject());
        String xml1 = new String(xmlobj.toByteArray("UTF-8"));
        FileOutputStream os = new FileOutputStream(projectdir + "/target/test-object-1.xml");
        os.write(xml1.getBytes());
        os.close();
        File file = new File(projectdir + "/target/test-object-1.xml");
        FileInputStream is = new FileInputStream(file);
        FileChannel fchan = is.getChannel();
        ByteBuffer buff = ByteBuffer.allocate((int)file.length());
        fchan.read(buff);
        buff.rewind();
        byte[] data = buff.array();
        buff.clear();
        fchan.close();
        is.close();
        TestObject tobject = (TestObject)XMLObject.getObject((InputStream)new ByteArrayInputStream(data));
        TestDataXML.assertTrue((tobject.nested.intarray.length == 10 ? 1 : 0) != 0);
        os = new FileOutputStream(projectdir + "/target/test-object-2.xml");
        xmlobj = new XMLObject((Object)tobject);
        String xml2 = new String(xmlobj.toByteArray("UTF-8"));
        os.write(xml2.getBytes());
        os.close();
        TestDataXML.assertTrue((boolean)xml1.equals(xml2));
        is.close();
        ArrayList<Object> list = new ArrayList<Object>();
        list.add("test.....................");
        list.add(new Date());
        XMLCollection xmllist = new XMLCollection(list);
        os = new FileOutputStream(projectdir + "/target/list.xml");
        os.write(xmllist.toByteArray("UTF-8"));
        os.close();
    }

    public static class TestObject {
        public static final String staticField = "staticField";
        String field = "hello";
        String method;
        Map map = new HashMap();
        List list = new ArrayList();
        NestedObject nested = new NestedObject();

        public TestObject() {
            HashMap<String, String> nestedMap = new HashMap<String, String>();
            nestedMap.put("nestedMapKey", "nestedMapvalue");
            this.map.put("string", "string");
            this.map.put("int", new Integer(10000));
            this.map.put("my", nestedMap);
            this.list.add("a list value");
            this.list.add("a list value");
        }

        public String getMethod() {
            return this.method;
        }

        public void setMethod(String s) {
            this.method = s;
        }
    }

    public static class NestedObject {
        String field = "field";
        String method;
        String xmlstring = "<xmlstring>this is a test</xmlstring>";
        int[] intarray = new int[10];
        int integer = 10;
        Map map = new HashMap();

        public NestedObject() {
            this.intarray[0] = 1;
            this.intarray[2] = 2;
        }

        public String getMethod() {
            return this.method;
        }

        public void setMethod(String s) {
            this.method = s;
        }
    }
}

