/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container.monitor.jvm;

import java.io.File;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import javax.management.MBeanServer;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.container.ar.Archive;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class J2EEServerInfo {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.kernel.container.J2EEServerInfo");
    public static final String EXO_CONF_PARAM = "exo.conf.dir";
    public static final String EXO_CONF_DIR_NAME_PARAM = "exo.conf.dir.name";
    public static final String EXO_ARCHIVE_DIRS_PARAM = "exo.archive.dirs";
    private String serverName_;
    private String serverHome_;
    private String exoConfDir_;
    private List<String> appDeployDirectories_;
    private Set<Archive> appDeployArchives_;
    private MBeanServer mbeanServer;

    public J2EEServerInfo() {
        this(false);
    }

    public J2EEServerInfo(boolean logEnabled) {
        String archiveDirs;
        String exoConfHome;
        String confDirName;
        block43: {
            this.appDeployArchives_ = new HashSet<Archive>(Arrays.asList(Archive.EAR, Archive.WAR));
            String jonasHome = System.getProperty("jonas.base");
            String jbossHome = System.getProperty("jboss.home.dir");
            String jettyHome = System.getProperty("jetty.home");
            String websphereHome = System.getProperty("was.install.root");
            String weblogicHome = System.getProperty("wls.home");
            String glassfishHome = System.getProperty("com.sun.aas.instanceRoot");
            String catalinaHome = System.getProperty("catalina.home");
            String testHome = System.getProperty("maven.exoplatform.dir");
            confDirName = System.getProperty(EXO_CONF_DIR_NAME_PARAM, "exo-conf");
            if (jonasHome != null) {
                this.serverName_ = "jonas";
                this.serverHome_ = jonasHome;
            } else {
                if (jbossHome != null) {
                    block42: {
                        this.serverName_ = "jboss";
                        this.serverHome_ = jbossHome;
                        String jbossConfigUrl = System.getProperty("jboss.server.config.url");
                        if (jbossConfigUrl != null) {
                            try {
                                this.exoConfDir_ = new File(new File(new URI(jbossConfigUrl)), confDirName).getAbsolutePath();
                                this.appDeployDirectories_ = Collections.singletonList(new File(new File(new URI(jbossConfigUrl)).getParentFile(), "deploy").getAbsolutePath());
                            }
                            catch (SecurityException e) {
                                if (logEnabled && LOG.isTraceEnabled()) {
                                    LOG.trace((Object)("An exception occurred: " + e.getMessage()));
                                }
                                break block42;
                            }
                            catch (URISyntaxException e) {
                                if (logEnabled && LOG.isTraceEnabled()) {
                                    LOG.trace((Object)("An exception occurred: " + e.getMessage()));
                                }
                                break block42;
                            }
                            catch (IllegalArgumentException e) {
                                if (logEnabled && LOG.isTraceEnabled()) {
                                    LOG.trace((Object)("An exception occurred: " + e.getMessage()));
                                }
                                break block42;
                            }
                        }
                        String jbossConfigDir = System.getProperty("jboss.server.config.dir");
                        if (jbossConfigDir != null) {
                            try {
                                this.exoConfDir_ = new File(jbossConfigDir, confDirName).getAbsolutePath();
                                this.appDeployDirectories_ = Collections.singletonList(new File(new File(jbossConfigDir).getParentFile(), "deployments").getAbsolutePath());
                            }
                            catch (SecurityException e) {
                                if (!logEnabled || !LOG.isTraceEnabled()) break block42;
                                LOG.trace((Object)("An exception occurred: " + e.getMessage()));
                            }
                        }
                    }
                    try {
                        Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass("org.jboss.mx.util.MBeanServerLocator");
                        Method m = clazz.getMethod("locateJBoss", new Class[0]);
                        this.mbeanServer = (MBeanServer)m.invoke(null, new Object[0]);
                    }
                    catch (ClassNotFoundException ignore) {
                        if (logEnabled && LOG.isDebugEnabled()) {
                            LOG.debug((Object)ignore.getLocalizedMessage(), (Throwable)ignore);
                        }
                        break block43;
                    }
                    catch (Exception ignore) {
                        if (logEnabled && LOG.isErrorEnabled()) {
                            LOG.error((Object)ignore.getLocalizedMessage(), (Throwable)ignore);
                        }
                        break block43;
                    }
                }
                if (jettyHome != null) {
                    this.serverName_ = "jetty";
                    this.serverHome_ = jettyHome;
                    this.appDeployDirectories_ = Collections.singletonList(new File(jettyHome, "webapps").getAbsolutePath());
                    this.appDeployArchives_ = Collections.singleton(Archive.WAR);
                } else if (websphereHome != null) {
                    this.serverName_ = "websphere";
                    this.serverHome_ = websphereHome;
                } else if (weblogicHome != null) {
                    this.serverName_ = "weblogic";
                    this.serverHome_ = weblogicHome;
                } else if (glassfishHome != null) {
                    this.serverName_ = "glassfish";
                    this.serverHome_ = glassfishHome;
                } else if (catalinaHome != null) {
                    this.serverName_ = "tomcat";
                    this.serverHome_ = catalinaHome;
                    this.appDeployDirectories_ = Collections.singletonList(new File(catalinaHome, "webapps").getAbsolutePath());
                    this.appDeployArchives_ = Collections.singleton(new Archive("war", PropertyManager.isDevelopping(), false, null));
                } else if (testHome != null) {
                    this.serverName_ = "test";
                    this.serverHome_ = testHome;
                } else {
                    this.serverName_ = "standalone";
                    this.serverHome_ = System.getProperty("user.dir");
                }
            }
        }
        if (this.exoConfDir_ == null) {
            this.exoConfDir_ = this.serverHome_ + "/" + confDirName;
        }
        if (this.mbeanServer == null) {
            this.mbeanServer = ManagementFactory.getPlatformMBeanServer();
        }
        if ((exoConfHome = System.getProperty(EXO_CONF_PARAM)) != null && exoConfHome.length() > 0) {
            if (logEnabled && LOG.isInfoEnabled()) {
                LOG.info((Object)("Override exo-conf directory '" + this.exoConfDir_ + "' with location '" + exoConfHome + "'"));
            }
            this.exoConfDir_ = exoConfHome;
        }
        if ((archiveDirs = System.getProperty(EXO_ARCHIVE_DIRS_PARAM)) != null) {
            StringTokenizer st = new StringTokenizer(archiveDirs, ",");
            if (st.hasMoreTokens()) {
                if (logEnabled && LOG.isInfoEnabled()) {
                    LOG.info((Object)("The location of the archives has been set to '" + archiveDirs + "'"));
                }
                ArrayList<String> dirs = new ArrayList<String>();
                while (st.hasMoreTokens()) {
                    String dir = st.nextToken().trim().replace('\\', '/');
                    String path = new File(this.serverHome_, dir).getAbsolutePath();
                    if (logEnabled && LOG.isDebugEnabled()) {
                        LOG.debug("Location of the archives: {}", new Object[]{path});
                    }
                    dirs.add(path);
                }
                this.appDeployDirectories_ = dirs;
            } else {
                this.appDeployDirectories_ = null;
            }
        }
        if (this.appDeployDirectories_ == null && logEnabled && LOG.isInfoEnabled()) {
            LOG.info((Object)"No location of the archives has been set");
        }
        this.serverHome_ = this.serverHome_.replace('\\', '/');
        this.exoConfDir_ = this.exoConfDir_.replace('\\', '/');
    }

    public MBeanServer getMBeanServer() {
        return this.mbeanServer;
    }

    public String getServerName() {
        return this.serverName_;
    }

    public String getServerHome() {
        return this.serverHome_;
    }

    public String getExoConfigurationDirectory() {
        return this.exoConfDir_;
    }

    public List<String> getApplicationDeployDirectories() {
        return this.appDeployDirectories_;
    }

    public Set<Archive> getApplicationDeployArchives() {
        return this.appDeployArchives_;
    }

    public boolean isJBoss() {
        return "jboss".equals(this.serverName_);
    }
}

