/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container;

import java.io.Serializable;
import org.exoplatform.container.spi.ComponentAdapter;
import org.exoplatform.container.spi.ContainerException;

public abstract class AbstractComponentAdapter<T>
implements ComponentAdapter<T>,
Serializable {
    private static final long serialVersionUID = -8879158955898247836L;
    private Object componentKey;
    private Class<T> componentImplementation;

    protected AbstractComponentAdapter(Object componentKey, Class<T> componentImplementation) throws ContainerException {
        if (componentImplementation == null) {
            throw new NullPointerException("componentImplementation");
        }
        this.componentKey = componentKey;
        this.componentImplementation = componentImplementation;
        this.checkTypeCompatibility();
    }

    @Override
    public Object getComponentKey() {
        if (this.componentKey == null) {
            throw new NullPointerException("componentKey");
        }
        return this.componentKey;
    }

    @Override
    public Class<T> getComponentImplementation() {
        return this.componentImplementation;
    }

    protected void checkTypeCompatibility() throws ContainerException {
        Class componentType;
        if (this.componentKey instanceof Class && !(componentType = (Class)this.componentKey).isAnnotation() && !componentType.isAssignableFrom(this.componentImplementation)) {
            throw new ContainerException("The type:" + componentType.getName() + "  was not assignable from the class " + this.componentImplementation.getName());
        }
    }

    public String toString() {
        return this.getClass().getName() + "[" + String.valueOf(this.getComponentKey()) + "]";
    }
}

