/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container.definition;

import java.net.URLDecoder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.container.RootContainer;
import org.exoplatform.container.definition.PortalContainerConfig;
import org.exoplatform.container.definition.PortalContainerDefinition;
import org.exoplatform.container.definition.PortalContainerDefinitionChange;
import org.exoplatform.container.jmx.AbstractTestContainer;

public class TestPortalContainerConfig
extends AbstractTestContainer {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInitValues() {
        RootContainer rootContainer = this.createRootContainer("empty-config.xml");
        PortalContainerConfig config = (PortalContainerConfig)rootContainer.getComponentInstanceOfType(PortalContainerConfig.class);
        TestPortalContainerConfig.assertNull((Object)config);
        rootContainer = this.createRootContainer("portal-container-config-with-no-default-values.xml");
        config = (PortalContainerConfig)rootContainer.getComponentInstanceOfType(PortalContainerConfig.class);
        TestPortalContainerConfig.assertEquals((String)PortalContainerConfig.DEFAULT_PORTAL_CONTAINER_NAME, (String)config.getDefaultPortalContainer());
        TestPortalContainerConfig.assertEquals((String)PortalContainerConfig.DEFAULT_REST_CONTEXT_NAME, (String)config.getDefaultRestContext());
        TestPortalContainerConfig.assertEquals((String)PortalContainerConfig.DEFAULT_REALM_NAME, (String)config.getDefaultRealmName());
        TestPortalContainerConfig.assertTrue((boolean)config.isPortalContainerName("portal"));
        TestPortalContainerConfig.assertFalse((boolean)config.isPortalContainerName("myPortal"));
        TestPortalContainerConfig.assertFalse((boolean)config.isPortalContainerName("myPortal-dpcdef"));
        TestPortalContainerConfig.assertFalse((boolean)config.hasDefinition());
        rootContainer = this.createRootContainer("portal-container-config-with-default-values.xml");
        config = (PortalContainerConfig)rootContainer.getComponentInstanceOfType(PortalContainerConfig.class);
        TestPortalContainerConfig.assertEquals((String)"myPortal", (String)config.getDefaultPortalContainer());
        TestPortalContainerConfig.assertEquals((String)"myRest", (String)config.getDefaultRestContext());
        TestPortalContainerConfig.assertEquals((String)"my-exo-domain", (String)config.getDefaultRealmName());
        TestPortalContainerConfig.assertFalse((boolean)config.isPortalContainerName("portal"));
        TestPortalContainerConfig.assertTrue((boolean)config.isPortalContainerName("myPortal"));
        TestPortalContainerConfig.assertFalse((boolean)config.isPortalContainerName("myPortal-dpcdef"));
        TestPortalContainerConfig.assertFalse((boolean)config.hasDefinition());
        try {
            rootContainer = this.createRootContainer("portal-container-config-with-default-values-and-with-default-portal-def.xml");
            config = (PortalContainerConfig)rootContainer.getComponentInstanceOfType(PortalContainerConfig.class);
            TestPortalContainerConfig.assertEquals((String)"myPortal-dpcdef", (String)config.getDefaultPortalContainer());
            TestPortalContainerConfig.assertEquals((String)"myRest-dpcdef", (String)config.getDefaultRestContext());
            TestPortalContainerConfig.assertEquals((String)"my-exo-domain-dpcdef", (String)config.getDefaultRealmName());
            TestPortalContainerConfig.assertFalse((boolean)config.isPortalContainerName("portal"));
            TestPortalContainerConfig.assertFalse((boolean)config.isPortalContainerName("myPortal"));
            TestPortalContainerConfig.assertTrue((boolean)config.isPortalContainerName("myPortal-dpcdef"));
            TestPortalContainerConfig.assertFalse((boolean)config.hasDefinition());
        }
        finally {
            this.clearSystemProperties();
        }
        try {
            rootContainer = this.createRootContainer("portal-container-config-with-default-values-and-with-portal-def.xml");
            config = (PortalContainerConfig)rootContainer.getComponentInstanceOfType(PortalContainerConfig.class);
            TestPortalContainerConfig.assertEquals((String)"myPortal", (String)config.getDefaultPortalContainer());
            TestPortalContainerConfig.assertEquals((String)"myRest", (String)config.getDefaultRestContext());
            TestPortalContainerConfig.assertEquals((String)"my-exo-domain", (String)config.getDefaultRealmName());
            TestPortalContainerConfig.assertTrue((boolean)config.hasDefinition());
        }
        finally {
            System.getProperties().remove("_ignore.unregistered.webapp.true");
            System.getProperties().remove("_ignore.unregistered.webapp.false");
            PropertyManager.refresh();
        }
        rootContainer = this.createRootContainer("portal-container-config-with-default-values-and-with-portal-defs.xml");
        config = (PortalContainerConfig)rootContainer.getComponentInstanceOfType(PortalContainerConfig.class);
        TestPortalContainerConfig.assertEquals((String)"myPortal", (String)config.getDefaultPortalContainer());
        TestPortalContainerConfig.assertEquals((String)"myRest", (String)config.getDefaultRestContext());
        TestPortalContainerConfig.assertEquals((String)"my-exo-domain", (String)config.getDefaultRealmName());
        TestPortalContainerConfig.assertTrue((boolean)config.hasDefinition());
        try {
            rootContainer = this.createRootContainer("portal-container-config-with-default-values-and-with-portal-def-with-default-portal-def.xml");
            config = (PortalContainerConfig)rootContainer.getComponentInstanceOfType(PortalContainerConfig.class);
            TestPortalContainerConfig.assertEquals((String)"myPortal-dpcdef", (String)config.getDefaultPortalContainer());
            TestPortalContainerConfig.assertEquals((String)"myRest-dpcdef", (String)config.getDefaultRestContext());
            TestPortalContainerConfig.assertEquals((String)"my-exo-domain-dpcdef", (String)config.getDefaultRealmName());
            TestPortalContainerConfig.assertTrue((boolean)config.hasDefinition());
        }
        finally {
            System.getProperties().remove("_portal.container");
            PropertyManager.refresh();
        }
        rootContainer = this.createRootContainer("portal-container-config-with-no-default-values-but-with-portal-def.xml");
        config = (PortalContainerConfig)rootContainer.getComponentInstanceOfType(PortalContainerConfig.class);
        TestPortalContainerConfig.assertEquals((String)"myPortal-pcdef", (String)config.getDefaultPortalContainer());
        TestPortalContainerConfig.assertEquals((String)"myRest-pcdef", (String)config.getDefaultRestContext());
        TestPortalContainerConfig.assertEquals((String)"my-exo-domain-pcdef", (String)config.getDefaultRealmName());
        TestPortalContainerConfig.assertTrue((boolean)config.hasDefinition());
        try {
            rootContainer = this.createRootContainer("portal-container-config-with-no-default-values-but-with-portal-defs.xml");
            config = (PortalContainerConfig)rootContainer.getComponentInstanceOfType(PortalContainerConfig.class);
            TestPortalContainerConfig.assertEquals((String)"portal", (String)config.getDefaultPortalContainer());
            TestPortalContainerConfig.assertEquals((String)"myRest", (String)config.getDefaultRestContext());
            TestPortalContainerConfig.assertEquals((String)"my-exo-domain", (String)config.getDefaultRealmName());
            TestPortalContainerConfig.assertTrue((boolean)config.hasDefinition());
        }
        finally {
            System.getProperties().remove("_value.true");
            PropertyManager.refresh();
        }
        rootContainer = this.createRootContainer("portal-container-config-with-no-default-values-but-with-portal-defs2.xml");
        config = (PortalContainerConfig)rootContainer.getComponentInstanceOfType(PortalContainerConfig.class);
        TestPortalContainerConfig.assertEquals((String)"myPortal-pcdef", (String)config.getDefaultPortalContainer());
        TestPortalContainerConfig.assertEquals((String)"myRest-pcdef", (String)config.getDefaultRestContext());
        TestPortalContainerConfig.assertEquals((String)"my-exo-domain-pcdef", (String)config.getDefaultRealmName());
        TestPortalContainerConfig.assertTrue((boolean)config.hasDefinition());
    }

    public void testChanges() {
        Set<String> s;
        try {
            this.createRootContainer("portal-container-config-with-no-default-values-but-with-portal-defs.xml");
            s = TestPortalContainerDefinitionChange.NAMES.get("change1");
            TestPortalContainerConfig.assertNotNull(s);
            TestPortalContainerConfig.assertEquals((int)2, (int)s.size());
            TestPortalContainerConfig.assertTrue((boolean)s.contains("portal"));
            TestPortalContainerConfig.assertTrue((boolean)s.contains("myPortal-pcdef"));
            s = TestPortalContainerDefinitionChange.NAMES.get("change2");
            TestPortalContainerConfig.assertNotNull(s);
            TestPortalContainerConfig.assertEquals((int)1, (int)s.size());
            TestPortalContainerConfig.assertTrue((boolean)s.contains("portal"));
            s = TestPortalContainerDefinitionChange.NAMES.get("change3");
            TestPortalContainerConfig.assertNotNull(s);
            TestPortalContainerConfig.assertEquals((int)1, (int)s.size());
            TestPortalContainerConfig.assertTrue((boolean)s.contains("myPortal-pcdef"));
            s = TestPortalContainerDefinitionChange.NAMES.get("change4");
            TestPortalContainerConfig.assertNotNull(s);
            TestPortalContainerConfig.assertEquals((int)2, (int)s.size());
            TestPortalContainerConfig.assertTrue((boolean)s.contains("portal"));
            TestPortalContainerConfig.assertTrue((boolean)s.contains("myPortal-pcdef"));
            s = TestPortalContainerDefinitionChange.NAMES.get("change5");
            TestPortalContainerConfig.assertNotNull(s);
            TestPortalContainerConfig.assertEquals((int)1, (int)s.size());
            TestPortalContainerConfig.assertTrue((boolean)s.contains("portal"));
            s = TestPortalContainerDefinitionChange.NAMES.get("change6");
            TestPortalContainerConfig.assertNull(s);
        }
        finally {
            TestPortalContainerDefinitionChange.NAMES.clear();
            System.getProperties().remove("_value.true");
            PropertyManager.refresh();
        }
        try {
            this.createRootContainer("portal-container-config-with-no-default-values-but-with-portal-defs.xml", "change6");
            s = TestPortalContainerDefinitionChange.NAMES.get("change6");
            TestPortalContainerConfig.assertNotNull(s);
            TestPortalContainerConfig.assertEquals((int)1, (int)s.size());
            TestPortalContainerConfig.assertTrue((boolean)s.contains("portal"));
        }
        finally {
            TestPortalContainerDefinitionChange.NAMES.clear();
            System.getProperties().remove("_value.true");
            PropertyManager.refresh();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDependencies() {
        int index;
        List deps;
        String[] profiles;
        RootContainer rootContainer = this.createRootContainer("portal-container-config-with-no-default-values.xml");
        PortalContainerConfig config = (PortalContainerConfig)rootContainer.getComponentInstanceOfType(PortalContainerConfig.class);
        TestPortalContainerConfig.assertNull((Object)config.getDependencies(PortalContainerConfig.DEFAULT_PORTAL_CONTAINER_NAME));
        TestPortalContainerConfig.assertNull((Object)config.getDependencies("foo"));
        TestPortalContainerConfig.assertNull((Object)config.getDependencies("myPortal"));
        TestPortalContainerConfig.assertNull((Object)config.getDependencies("myPortal-pcdef"));
        List names = config.getPortalContainerNames("foo");
        TestPortalContainerConfig.assertTrue((names != null && !names.isEmpty() ? 1 : 0) != 0);
        TestPortalContainerConfig.assertEquals((String)PortalContainerConfig.DEFAULT_PORTAL_CONTAINER_NAME, (String)((String)names.get(0)));
        names = config.getPortalContainerNames("myPortal");
        TestPortalContainerConfig.assertTrue((names != null && !names.isEmpty() ? 1 : 0) != 0);
        TestPortalContainerConfig.assertEquals((String)PortalContainerConfig.DEFAULT_PORTAL_CONTAINER_NAME, (String)((String)names.get(0)));
        names = config.getPortalContainerNames("myPortal-pcdef");
        TestPortalContainerConfig.assertTrue((names != null && !names.isEmpty() ? 1 : 0) != 0);
        TestPortalContainerConfig.assertEquals((String)PortalContainerConfig.DEFAULT_PORTAL_CONTAINER_NAME, (String)((String)names.get(0)));
        TestPortalContainerConfig.assertEquals((String)PortalContainerConfig.DEFAULT_PORTAL_CONTAINER_NAME, (String)config.getPortalContainerName("foo"));
        TestPortalContainerConfig.assertEquals((String)PortalContainerConfig.DEFAULT_PORTAL_CONTAINER_NAME, (String)config.getPortalContainerName("myPortal"));
        TestPortalContainerConfig.assertEquals((String)PortalContainerConfig.DEFAULT_PORTAL_CONTAINER_NAME, (String)config.getPortalContainerName("myPortal-pcdef"));
        TestPortalContainerConfig.assertEquals((String)PortalContainerConfig.DEFAULT_REST_CONTEXT_NAME, (String)config.getRestContextName("foo"));
        TestPortalContainerConfig.assertEquals((String)PortalContainerConfig.DEFAULT_REST_CONTEXT_NAME, (String)config.getRestContextName("myPortal"));
        TestPortalContainerConfig.assertEquals((String)PortalContainerConfig.DEFAULT_REST_CONTEXT_NAME, (String)config.getRestContextName("myPortal-pcdef"));
        TestPortalContainerConfig.assertEquals((String)PortalContainerConfig.DEFAULT_REALM_NAME, (String)config.getRealmName("foo"));
        TestPortalContainerConfig.assertEquals((String)PortalContainerConfig.DEFAULT_REALM_NAME, (String)config.getRealmName("myPortal"));
        TestPortalContainerConfig.assertEquals((String)PortalContainerConfig.DEFAULT_REALM_NAME, (String)config.getRealmName("myPortal-pcdef"));
        TestPortalContainerConfig.assertFalse((boolean)config.isPortalContainerName("foo"));
        TestPortalContainerConfig.assertFalse((boolean)config.isPortalContainerName("myPortal"));
        TestPortalContainerConfig.assertFalse((boolean)config.isPortalContainerName("myPortal-pcdef"));
        TestPortalContainerConfig.assertTrue((boolean)config.isPortalContainerName(PortalContainerConfig.DEFAULT_PORTAL_CONTAINER_NAME));
        TestPortalContainerConfig.assertTrue((boolean)config.isScopeValid(PortalContainerConfig.DEFAULT_PORTAL_CONTAINER_NAME, "foo"));
        TestPortalContainerConfig.assertFalse((boolean)config.isScopeValid("foo", "foo"));
        TestPortalContainerConfig.assertFalse((boolean)config.isScopeValid("myPortal", "foo"));
        TestPortalContainerConfig.assertFalse((boolean)config.isScopeValid("myPortal-pcdef", "foo"));
        TestPortalContainerConfig.assertFalse((boolean)config.hasDefinition());
        rootContainer = this.createRootContainer("portal-container-config-with-no-default-values.xml", "disable-pc");
        config = (PortalContainerConfig)rootContainer.getComponentInstanceOfType(PortalContainerConfig.class);
        TestPortalContainerConfig.assertEquals((String)PortalContainerConfig.DEFAULT_PORTAL_CONTAINER_NAME, (String)config.getPortalContainerName("foo"));
        TestPortalContainerConfig.assertTrue((boolean)config.isPortalContainerName(PortalContainerConfig.DEFAULT_PORTAL_CONTAINER_NAME));
        TestPortalContainerConfig.assertTrue((boolean)config.isScopeValid(PortalContainerConfig.DEFAULT_PORTAL_CONTAINER_NAME, "foo"));
        names = config.getPortalContainerNames("foo");
        TestPortalContainerConfig.assertTrue((names != null && !names.isEmpty() ? 1 : 0) != 0);
        TestPortalContainerConfig.assertEquals((String)PortalContainerConfig.DEFAULT_PORTAL_CONTAINER_NAME, (String)((String)names.get(0)));
        for (String profile : profiles = new String[]{"AddDependencies", "AddDependenciesBefore-No-Target", "AddDependenciesBefore-With-Fake-Target", "AddDependenciesAfter-No-Target", "AddDependenciesAfter-With-Fake-Target"}) {
            rootContainer = this.createRootContainer("portal-container-config-with-no-default-values2.xml", profile);
            config = (PortalContainerConfig)rootContainer.getComponentInstanceOfType(PortalContainerConfig.class);
            deps = config.getDependencies(PortalContainerConfig.DEFAULT_PORTAL_CONTAINER_NAME);
            TestPortalContainerConfig.assertTrue((deps != null && deps.size() == 1 && deps.contains("foo") ? 1 : 0) != 0);
            deps = config.getDependencies("foo");
            TestPortalContainerConfig.assertTrue((deps != null && deps.size() == 1 && deps.contains("foo") ? 1 : 0) != 0);
            deps = config.getDependencies("myPortal");
            TestPortalContainerConfig.assertTrue((deps != null && deps.size() == 1 && deps.contains("foo") ? 1 : 0) != 0);
            deps = config.getDependencies("myPortal-pcdef");
            TestPortalContainerConfig.assertTrue((deps != null && deps.size() == 1 && deps.contains("foo") ? 1 : 0) != 0);
            names = config.getPortalContainerNames("foo");
            TestPortalContainerConfig.assertTrue((names != null && !names.isEmpty() ? 1 : 0) != 0);
            TestPortalContainerConfig.assertEquals((String)PortalContainerConfig.DEFAULT_PORTAL_CONTAINER_NAME, (String)((String)names.get(0)));
            names = config.getPortalContainerNames("myPortal");
            TestPortalContainerConfig.assertTrue((names != null && !names.isEmpty() ? 1 : 0) != 0);
            TestPortalContainerConfig.assertEquals((String)PortalContainerConfig.DEFAULT_PORTAL_CONTAINER_NAME, (String)((String)names.get(0)));
            names = config.getPortalContainerNames("myPortal-pcdef");
            TestPortalContainerConfig.assertTrue((names != null && !names.isEmpty() ? 1 : 0) != 0);
            TestPortalContainerConfig.assertEquals((String)PortalContainerConfig.DEFAULT_PORTAL_CONTAINER_NAME, (String)((String)names.get(0)));
            TestPortalContainerConfig.assertEquals((String)PortalContainerConfig.DEFAULT_PORTAL_CONTAINER_NAME, (String)config.getPortalContainerName("foo"));
            TestPortalContainerConfig.assertEquals((String)PortalContainerConfig.DEFAULT_PORTAL_CONTAINER_NAME, (String)config.getPortalContainerName("myPortal"));
            TestPortalContainerConfig.assertEquals((String)PortalContainerConfig.DEFAULT_PORTAL_CONTAINER_NAME, (String)config.getPortalContainerName("myPortal-pcdef"));
            TestPortalContainerConfig.assertEquals((String)PortalContainerConfig.DEFAULT_REST_CONTEXT_NAME, (String)config.getRestContextName("foo"));
            TestPortalContainerConfig.assertEquals((String)PortalContainerConfig.DEFAULT_REST_CONTEXT_NAME, (String)config.getRestContextName("myPortal"));
            TestPortalContainerConfig.assertEquals((String)PortalContainerConfig.DEFAULT_REST_CONTEXT_NAME, (String)config.getRestContextName("myPortal-pcdef"));
            TestPortalContainerConfig.assertEquals((String)PortalContainerConfig.DEFAULT_REALM_NAME, (String)config.getRealmName("foo"));
            TestPortalContainerConfig.assertEquals((String)PortalContainerConfig.DEFAULT_REALM_NAME, (String)config.getRealmName("myPortal"));
            TestPortalContainerConfig.assertEquals((String)PortalContainerConfig.DEFAULT_REALM_NAME, (String)config.getRealmName("myPortal-pcdef"));
            TestPortalContainerConfig.assertFalse((boolean)config.isPortalContainerName("foo"));
            TestPortalContainerConfig.assertFalse((boolean)config.isPortalContainerName("myPortal"));
            TestPortalContainerConfig.assertFalse((boolean)config.isPortalContainerName("myPortal-pcdef"));
            TestPortalContainerConfig.assertTrue((boolean)config.isPortalContainerName(PortalContainerConfig.DEFAULT_PORTAL_CONTAINER_NAME));
            TestPortalContainerConfig.assertFalse((boolean)config.isScopeValid("foo", "foo"));
            TestPortalContainerConfig.assertFalse((boolean)config.isScopeValid("myPortal", "foo"));
            TestPortalContainerConfig.assertFalse((boolean)config.isScopeValid("myPortal-pcdef", "foo"));
            TestPortalContainerConfig.assertTrue((boolean)config.isScopeValid(PortalContainerConfig.DEFAULT_PORTAL_CONTAINER_NAME, "foo"));
            TestPortalContainerConfig.assertFalse((boolean)config.hasDefinition());
            rootContainer = this.createRootContainer("portal-container-config-with-no-default-values2.xml", profile, "disable-pc");
            config = (PortalContainerConfig)rootContainer.getComponentInstanceOfType(PortalContainerConfig.class);
            TestPortalContainerConfig.assertEquals((String)PortalContainerConfig.DEFAULT_PORTAL_CONTAINER_NAME, (String)config.getPortalContainerName("foo"));
            TestPortalContainerConfig.assertTrue((boolean)config.isPortalContainerName(PortalContainerConfig.DEFAULT_PORTAL_CONTAINER_NAME));
            TestPortalContainerConfig.assertTrue((boolean)config.isScopeValid(PortalContainerConfig.DEFAULT_PORTAL_CONTAINER_NAME, "foo"));
            names = config.getPortalContainerNames("foo");
            TestPortalContainerConfig.assertTrue((names != null && !names.isEmpty() ? 1 : 0) != 0);
            TestPortalContainerConfig.assertEquals((String)PortalContainerConfig.DEFAULT_PORTAL_CONTAINER_NAME, (String)((String)names.get(0)));
        }
        String[] ignoreWebappProfiles = new String[]{"ignore.unregistered.webapp-default", "ignore.unregistered.webapp-false", "ignore.unregistered.webapp-true"};
        for (int i = 0; i < ignoreWebappProfiles.length; ++i) {
            try {
                rootContainer = this.createRootContainer("portal-container-config-with-default-values-and-with-portal-def.xml", ignoreWebappProfiles[i]);
                config = (PortalContainerConfig)rootContainer.getComponentInstanceOfType(PortalContainerConfig.class);
                TestPortalContainerConfig.assertNull((Object)config.getDependencies("foo"));
                TestPortalContainerConfig.assertNull((Object)config.getDependencies("myPortal"));
                TestPortalContainerConfig.assertNull((Object)config.getDependencies("myPortal-pcdef"));
                names = config.getPortalContainerNames("foo");
                if (i < ignoreWebappProfiles.length - 1) {
                    TestPortalContainerConfig.assertTrue((names != null && !names.isEmpty() ? 1 : 0) != 0);
                    TestPortalContainerConfig.assertEquals((int)2, (int)names.size());
                    TestPortalContainerConfig.assertTrue((boolean)names.contains("myPortal"));
                    TestPortalContainerConfig.assertTrue((boolean)names.contains("myPortal-pcdef"));
                    TestPortalContainerConfig.assertEquals((String)"myPortal", (String)config.getPortalContainerName("foo"));
                } else {
                    TestPortalContainerConfig.assertTrue((names != null && names.isEmpty() ? 1 : 0) != 0);
                    TestPortalContainerConfig.assertNull((Object)config.getPortalContainerName("foo"));
                }
                names = config.getPortalContainerNames("myPortal");
                TestPortalContainerConfig.assertTrue((names != null && !names.isEmpty() ? 1 : 0) != 0);
                TestPortalContainerConfig.assertEquals((String)"myPortal", (String)((String)names.get(0)));
                names = config.getPortalContainerNames("myPortal-pcdef");
                TestPortalContainerConfig.assertTrue((names != null && !names.isEmpty() ? 1 : 0) != 0);
                TestPortalContainerConfig.assertEquals((String)"myPortal-pcdef", (String)((String)names.get(0)));
                TestPortalContainerConfig.assertEquals((String)"myPortal", (String)config.getPortalContainerName("myPortal"));
                TestPortalContainerConfig.assertEquals((String)"myPortal-pcdef", (String)config.getPortalContainerName("myPortal-pcdef"));
                TestPortalContainerConfig.assertEquals((String)"myRest", (String)config.getRestContextName("foo"));
                TestPortalContainerConfig.assertEquals((String)"myRest", (String)config.getRestContextName("myPortal"));
                TestPortalContainerConfig.assertEquals((String)"myRest-pcdef", (String)config.getRestContextName("myPortal-pcdef"));
                TestPortalContainerConfig.assertEquals((String)"my-exo-domain", (String)config.getRealmName("foo"));
                TestPortalContainerConfig.assertEquals((String)"my-exo-domain", (String)config.getRealmName("myPortal"));
                TestPortalContainerConfig.assertEquals((String)"my-exo-domain-pcdef", (String)config.getRealmName("myPortal-pcdef"));
                TestPortalContainerConfig.assertFalse((boolean)config.isPortalContainerName("foo"));
                TestPortalContainerConfig.assertTrue((boolean)config.isPortalContainerName("myPortal"));
                TestPortalContainerConfig.assertTrue((boolean)config.isPortalContainerName("myPortal-pcdef"));
                TestPortalContainerConfig.assertFalse((boolean)config.isScopeValid("foo", "foo"));
                if (i < ignoreWebappProfiles.length - 1) {
                    TestPortalContainerConfig.assertTrue((boolean)config.isScopeValid("myPortal", "foo"));
                    TestPortalContainerConfig.assertTrue((boolean)config.isScopeValid("myPortal-pcdef", "foo"));
                } else {
                    TestPortalContainerConfig.assertFalse((boolean)config.isScopeValid("myPortal", "foo"));
                    TestPortalContainerConfig.assertFalse((boolean)config.isScopeValid("myPortal-pcdef", "foo"));
                }
                TestPortalContainerConfig.assertTrue((boolean)config.isScopeValid("myPortal", "myPortal"));
                TestPortalContainerConfig.assertTrue((boolean)config.isScopeValid("myPortal-pcdef", "myPortal-pcdef"));
                TestPortalContainerConfig.assertTrue((boolean)config.hasDefinition());
                continue;
            }
            finally {
                System.getProperties().remove("_ignore.unregistered.webapp.true");
                System.getProperties().remove("_ignore.unregistered.webapp.false");
                PropertyManager.refresh();
            }
        }
        try {
            rootContainer = this.createRootContainer("portal-container-config-with-default-values-and-with-portal-def.xml", "disable-pc");
            config = (PortalContainerConfig)rootContainer.getComponentInstanceOfType(PortalContainerConfig.class);
            TestPortalContainerConfig.assertNull((Object)config.getPortalContainerName("myPortal-pcdef"));
            TestPortalContainerConfig.assertEquals((String)"myPortal", (String)config.getPortalContainerName("myPortal"));
            TestPortalContainerConfig.assertFalse((boolean)config.isPortalContainerName("myPortal-pcdef"));
            TestPortalContainerConfig.assertTrue((boolean)config.isPortalContainerName("myPortal"));
            TestPortalContainerConfig.assertFalse((boolean)config.isScopeValid("myPortal-pcdef", "myPortal-pcdef"));
            TestPortalContainerConfig.assertFalse((boolean)config.isScopeValid("myPortal-pcdef", "myPortal"));
            TestPortalContainerConfig.assertFalse((boolean)config.isScopeValid("myPortal", "myPortal-pcdef"));
            TestPortalContainerConfig.assertTrue((boolean)config.isScopeValid("myPortal", "myPortal"));
            names = config.getPortalContainerNames("myPortal-pcdef");
            TestPortalContainerConfig.assertTrue((names != null && names.isEmpty() ? 1 : 0) != 0);
            names = config.getPortalContainerNames("myPortal");
            TestPortalContainerConfig.assertTrue((names != null && !names.isEmpty() ? 1 : 0) != 0);
            TestPortalContainerConfig.assertEquals((int)1, (int)names.size());
            TestPortalContainerConfig.assertTrue((boolean)names.contains("myPortal"));
        }
        finally {
            System.getProperties().remove("_ignore.unregistered.webapp.true");
            System.getProperties().remove("_ignore.unregistered.webapp.false");
            PropertyManager.refresh();
        }
        try {
            rootContainer = this.createRootContainer("portal-container-config-with-default-values-and-with-portal-def.xml", "disable-pc2");
            config = (PortalContainerConfig)rootContainer.getComponentInstanceOfType(PortalContainerConfig.class);
            TestPortalContainerConfig.assertEquals((String)"myPortal-pcdef", (String)config.getPortalContainerName("myPortal-pcdef"));
            TestPortalContainerConfig.assertNull((Object)config.getPortalContainerName("myPortal"));
            TestPortalContainerConfig.assertTrue((boolean)config.isPortalContainerName("myPortal-pcdef"));
            TestPortalContainerConfig.assertFalse((boolean)config.isPortalContainerName("myPortal"));
            TestPortalContainerConfig.assertTrue((boolean)config.isScopeValid("myPortal-pcdef", "myPortal-pcdef"));
            TestPortalContainerConfig.assertFalse((boolean)config.isScopeValid("myPortal-pcdef", "myPortal"));
            TestPortalContainerConfig.assertFalse((boolean)config.isScopeValid("myPortal", "myPortal-pcdef"));
            TestPortalContainerConfig.assertFalse((boolean)config.isScopeValid("myPortal", "myPortal"));
            names = config.getPortalContainerNames("myPortal-pcdef");
            TestPortalContainerConfig.assertTrue((names != null && !names.isEmpty() ? 1 : 0) != 0);
            TestPortalContainerConfig.assertEquals((int)1, (int)names.size());
            TestPortalContainerConfig.assertTrue((boolean)names.contains("myPortal-pcdef"));
            names = config.getPortalContainerNames("myPortal");
            TestPortalContainerConfig.assertTrue((names != null && names.isEmpty() ? 1 : 0) != 0);
            config.disablePortalContainer("myPortal-pcdef");
            TestPortalContainerConfig.assertNull((Object)config.getPortalContainerName("myPortal-pcdef"));
            TestPortalContainerConfig.assertNull((Object)config.getPortalContainerName("myPortal"));
            TestPortalContainerConfig.assertFalse((boolean)config.isPortalContainerName("myPortal-pcdef"));
            TestPortalContainerConfig.assertFalse((boolean)config.isPortalContainerName("myPortal"));
            TestPortalContainerConfig.assertFalse((boolean)config.isScopeValid("myPortal-pcdef", "myPortal-pcdef"));
            TestPortalContainerConfig.assertFalse((boolean)config.isScopeValid("myPortal-pcdef", "myPortal"));
            TestPortalContainerConfig.assertFalse((boolean)config.isScopeValid("myPortal", "myPortal-pcdef"));
            TestPortalContainerConfig.assertFalse((boolean)config.isScopeValid("myPortal", "myPortal"));
            names = config.getPortalContainerNames("myPortal-pcdef");
            TestPortalContainerConfig.assertTrue((names != null && names.isEmpty() ? 1 : 0) != 0);
            names = config.getPortalContainerNames("myPortal");
            TestPortalContainerConfig.assertTrue((names != null && names.isEmpty() ? 1 : 0) != 0);
            config.registerPortalContainerName("myPortal-pcdef");
            TestPortalContainerConfig.assertNull((Object)config.getPortalContainerName("myPortal-pcdef"));
            TestPortalContainerConfig.assertNull((Object)config.getPortalContainerName("myPortal"));
            TestPortalContainerConfig.assertFalse((boolean)config.isPortalContainerName("myPortal-pcdef"));
            TestPortalContainerConfig.assertFalse((boolean)config.isPortalContainerName("myPortal"));
            TestPortalContainerConfig.assertFalse((boolean)config.isScopeValid("myPortal-pcdef", "myPortal-pcdef"));
            TestPortalContainerConfig.assertFalse((boolean)config.isScopeValid("myPortal-pcdef", "myPortal"));
            TestPortalContainerConfig.assertFalse((boolean)config.isScopeValid("myPortal", "myPortal-pcdef"));
            TestPortalContainerConfig.assertFalse((boolean)config.isScopeValid("myPortal", "myPortal"));
            names = config.getPortalContainerNames("myPortal-pcdef");
            TestPortalContainerConfig.assertTrue((names != null && names.isEmpty() ? 1 : 0) != 0);
            names = config.getPortalContainerNames("myPortal");
            TestPortalContainerConfig.assertTrue((names != null && names.isEmpty() ? 1 : 0) != 0);
        }
        finally {
            System.getProperties().remove("_ignore.unregistered.webapp.true");
            System.getProperties().remove("_ignore.unregistered.webapp.false");
            PropertyManager.refresh();
        }
        rootContainer = this.createRootContainer("portal-container-config-with-default-values-and-with-empty-portal-def.xml");
        config = (PortalContainerConfig)rootContainer.getComponentInstanceOfType(PortalContainerConfig.class);
        TestPortalContainerConfig.assertNull((Object)config.getDependencies("foo"));
        TestPortalContainerConfig.assertNull((Object)config.getDependencies("myPortal"));
        TestPortalContainerConfig.assertNull((Object)config.getDependencies("myPortal-pcdef"));
        names = config.getPortalContainerNames("foo");
        TestPortalContainerConfig.assertTrue((names != null && !names.isEmpty() ? 1 : 0) != 0);
        TestPortalContainerConfig.assertEquals((String)"myPortal", (String)((String)names.get(0)));
        names = config.getPortalContainerNames("myPortal");
        TestPortalContainerConfig.assertTrue((names != null && !names.isEmpty() ? 1 : 0) != 0);
        TestPortalContainerConfig.assertEquals((String)"myPortal", (String)((String)names.get(0)));
        names = config.getPortalContainerNames("myPortal-pcdef");
        TestPortalContainerConfig.assertTrue((names != null && !names.isEmpty() ? 1 : 0) != 0);
        TestPortalContainerConfig.assertEquals((String)"myPortal", (String)((String)names.get(0)));
        TestPortalContainerConfig.assertEquals((String)"myPortal", (String)config.getPortalContainerName("foo"));
        TestPortalContainerConfig.assertEquals((String)"myPortal", (String)config.getPortalContainerName("myPortal"));
        TestPortalContainerConfig.assertEquals((String)"myPortal", (String)config.getPortalContainerName("myPortal-pcdef"));
        TestPortalContainerConfig.assertEquals((String)"myRest", (String)config.getRestContextName("foo"));
        TestPortalContainerConfig.assertEquals((String)"myRest", (String)config.getRestContextName("myPortal"));
        TestPortalContainerConfig.assertEquals((String)"myRest", (String)config.getRestContextName("myPortal-pcdef"));
        TestPortalContainerConfig.assertEquals((String)"my-exo-domain", (String)config.getRealmName("foo"));
        TestPortalContainerConfig.assertEquals((String)"my-exo-domain", (String)config.getRealmName("myPortal"));
        TestPortalContainerConfig.assertEquals((String)"my-exo-domain", (String)config.getRealmName("myPortal-pcdef"));
        TestPortalContainerConfig.assertFalse((boolean)config.isPortalContainerName("foo"));
        TestPortalContainerConfig.assertTrue((boolean)config.isPortalContainerName("myPortal"));
        TestPortalContainerConfig.assertFalse((boolean)config.isPortalContainerName("myPortal-pcdef"));
        rootContainer = this.createRootContainer("portal-container-config-with-default-values-and-with-empty-portal-def.xml", "disable-pc");
        config = (PortalContainerConfig)rootContainer.getComponentInstanceOfType(PortalContainerConfig.class);
        TestPortalContainerConfig.assertEquals((String)"myPortal", (String)config.getPortalContainerName("foo"));
        TestPortalContainerConfig.assertTrue((boolean)config.isPortalContainerName("myPortal"));
        TestPortalContainerConfig.assertTrue((boolean)config.isScopeValid("myPortal", "foo"));
        names = config.getPortalContainerNames("foo");
        TestPortalContainerConfig.assertTrue((names != null && !names.isEmpty() ? 1 : 0) != 0);
        TestPortalContainerConfig.assertEquals((String)"myPortal", (String)((String)names.get(0)));
        try {
            rootContainer = this.createRootContainer("portal-container-config-with-default-values-and-with-empty-portal-def2.xml");
            config = (PortalContainerConfig)rootContainer.getComponentInstanceOfType(PortalContainerConfig.class);
            TestPortalContainerConfig.assertNull((Object)config.getDependencies("foo"));
            TestPortalContainerConfig.assertNull((Object)config.getDependencies("myPortal"));
            TestPortalContainerConfig.assertNull((Object)config.getDependencies("myPortal-pcdef"));
            names = config.getPortalContainerNames("foo");
            TestPortalContainerConfig.assertTrue((names != null && !names.isEmpty() ? 1 : 0) != 0);
            TestPortalContainerConfig.assertEquals((int)2, (int)names.size());
            TestPortalContainerConfig.assertTrue((boolean)names.contains("myPortal"));
            TestPortalContainerConfig.assertTrue((boolean)names.contains("myPortal-pcdef"));
            names = config.getPortalContainerNames("myPortal");
            TestPortalContainerConfig.assertTrue((names != null && !names.isEmpty() ? 1 : 0) != 0);
            TestPortalContainerConfig.assertEquals((String)"myPortal", (String)((String)names.get(0)));
            names = config.getPortalContainerNames("myPortal-pcdef");
            TestPortalContainerConfig.assertTrue((names != null && !names.isEmpty() ? 1 : 0) != 0);
            TestPortalContainerConfig.assertEquals((String)"myPortal-pcdef", (String)((String)names.get(0)));
            TestPortalContainerConfig.assertEquals((String)"myPortal", (String)config.getPortalContainerName("foo"));
            TestPortalContainerConfig.assertEquals((String)"myPortal", (String)config.getPortalContainerName("myPortal"));
            TestPortalContainerConfig.assertEquals((String)"myPortal-pcdef", (String)config.getPortalContainerName("myPortal-pcdef"));
            TestPortalContainerConfig.assertEquals((String)"myRest", (String)config.getRestContextName("foo"));
            TestPortalContainerConfig.assertEquals((String)"myRest", (String)config.getRestContextName("myPortal"));
            TestPortalContainerConfig.assertEquals((String)"myRest", (String)config.getRestContextName("myPortal-pcdef"));
            TestPortalContainerConfig.assertEquals((String)"my-exo-domain", (String)config.getRealmName("foo"));
            TestPortalContainerConfig.assertEquals((String)"my-exo-domain", (String)config.getRealmName("myPortal"));
            TestPortalContainerConfig.assertEquals((String)"my-exo-domain", (String)config.getRealmName("myPortal-pcdef"));
            TestPortalContainerConfig.assertFalse((boolean)config.isPortalContainerName("foo"));
            TestPortalContainerConfig.assertTrue((boolean)config.isPortalContainerName("myPortal"));
            TestPortalContainerConfig.assertTrue((boolean)config.isPortalContainerName("myPortal-pcdef"));
            TestPortalContainerConfig.assertFalse((boolean)config.isScopeValid("foo", "foo"));
            TestPortalContainerConfig.assertTrue((boolean)config.isScopeValid("myPortal", "foo"));
            TestPortalContainerConfig.assertTrue((boolean)config.isScopeValid("myPortal-pcdef", "foo"));
            TestPortalContainerConfig.assertTrue((boolean)config.isScopeValid("myPortal", "myPortal"));
            TestPortalContainerConfig.assertTrue((boolean)config.isScopeValid("myPortal-pcdef", "myPortal-pcdef"));
            TestPortalContainerConfig.assertTrue((boolean)config.hasDefinition());
        }
        finally {
            this.clearSystemProperties();
            PropertyManager.refresh();
        }
        try {
            rootContainer = this.createRootContainer("portal-container-config-with-default-values-and-with-empty-portal-def2.xml", "disable-pc");
            config = (PortalContainerConfig)rootContainer.getComponentInstanceOfType(PortalContainerConfig.class);
            TestPortalContainerConfig.assertNull((Object)config.getPortalContainerName("myPortal-pcdef"));
            TestPortalContainerConfig.assertFalse((boolean)config.isPortalContainerName("myPortal-pcdef"));
            TestPortalContainerConfig.assertFalse((boolean)config.isScopeValid("myPortal-pcdef", "myPortal-pcdef"));
            names = config.getPortalContainerNames("myPortal-pcdef");
            TestPortalContainerConfig.assertTrue((names != null && names.isEmpty() ? 1 : 0) != 0);
        }
        finally {
            this.clearSystemProperties();
        }
        try {
            rootContainer = this.createRootContainer("portal-container-config-with-default-values-and-with-portal-def-with-default-portal-def.xml");
            config = (PortalContainerConfig)rootContainer.getComponentInstanceOfType(PortalContainerConfig.class);
            deps = config.getDependencies("foo");
            TestPortalContainerConfig.assertNull((Object)deps);
            deps = config.getDependencies("myPortal");
            TestPortalContainerConfig.assertNull((Object)deps);
            deps = config.getDependencies("myPortal-pcdef");
            TestPortalContainerConfig.assertTrue((deps != null && deps.size() == 1 && deps.contains("fooX") ? 1 : 0) != 0);
            names = config.getPortalContainerNames("fooX");
            TestPortalContainerConfig.assertTrue((names != null && !names.isEmpty() ? 1 : 0) != 0);
            TestPortalContainerConfig.assertEquals((int)2, (int)names.size());
            TestPortalContainerConfig.assertTrue((boolean)names.contains("myPortal-dpcdef"));
            TestPortalContainerConfig.assertTrue((boolean)names.contains("myPortal-pcdef"));
            names = config.getPortalContainerNames("foo");
            TestPortalContainerConfig.assertTrue((names != null && !names.isEmpty() ? 1 : 0) != 0);
            TestPortalContainerConfig.assertEquals((int)2, (int)names.size());
            TestPortalContainerConfig.assertTrue((boolean)names.contains("myPortal-dpcdef"));
            TestPortalContainerConfig.assertTrue((boolean)names.contains("myPortal-pcdef"));
            names = config.getPortalContainerNames("myPortal");
            TestPortalContainerConfig.assertTrue((names != null && !names.isEmpty() ? 1 : 0) != 0);
            TestPortalContainerConfig.assertEquals((int)2, (int)names.size());
            TestPortalContainerConfig.assertTrue((boolean)names.contains("myPortal-dpcdef"));
            TestPortalContainerConfig.assertTrue((boolean)names.contains("myPortal-pcdef"));
            names = config.getPortalContainerNames("myPortal-pcdef");
            TestPortalContainerConfig.assertTrue((names != null && !names.isEmpty() ? 1 : 0) != 0);
            TestPortalContainerConfig.assertEquals((String)"myPortal-pcdef", (String)((String)names.get(0)));
            TestPortalContainerConfig.assertEquals((String)"myPortal-dpcdef", (String)config.getPortalContainerName("foo"));
            TestPortalContainerConfig.assertEquals((String)"myPortal-dpcdef", (String)config.getPortalContainerName("myPortal"));
            TestPortalContainerConfig.assertEquals((String)"myPortal-pcdef", (String)config.getPortalContainerName("myPortal-pcdef"));
            TestPortalContainerConfig.assertEquals((String)"myRest-dpcdef", (String)config.getRestContextName("foo"));
            TestPortalContainerConfig.assertEquals((String)"myRest-dpcdef", (String)config.getRestContextName("myPortal"));
            TestPortalContainerConfig.assertEquals((String)"myRest-pcdef", (String)config.getRestContextName("myPortal-pcdef"));
            TestPortalContainerConfig.assertEquals((String)"my-exo-domain-dpcdef", (String)config.getRealmName("foo"));
            TestPortalContainerConfig.assertEquals((String)"my-exo-domain-dpcdef", (String)config.getRealmName("myPortal"));
            TestPortalContainerConfig.assertEquals((String)"my-exo-domain-pcdef", (String)config.getRealmName("myPortal-pcdef"));
            TestPortalContainerConfig.assertFalse((boolean)config.isPortalContainerName("foo"));
            TestPortalContainerConfig.assertFalse((boolean)config.isPortalContainerName("myPortal"));
            TestPortalContainerConfig.assertTrue((boolean)config.isPortalContainerName("myPortal-dpcdef"));
            TestPortalContainerConfig.assertTrue((boolean)config.isPortalContainerName("myPortal-pcdef"));
            TestPortalContainerConfig.assertFalse((boolean)config.isScopeValid("foo", "fooX"));
            TestPortalContainerConfig.assertFalse((boolean)config.isScopeValid("myPortal", "fooX"));
            TestPortalContainerConfig.assertTrue((boolean)config.isScopeValid("myPortal-dpcdef", "fooX"));
            TestPortalContainerConfig.assertTrue((boolean)config.isScopeValid("myPortal-pcdef", "fooX"));
            TestPortalContainerConfig.assertTrue((boolean)config.hasDefinition());
        }
        finally {
            this.clearSystemProperties();
        }
        try {
            rootContainer = this.createRootContainer("portal-container-config-with-default-values-and-with-portal-def-with-default-portal-def.xml", "disable-pc");
            config = (PortalContainerConfig)rootContainer.getComponentInstanceOfType(PortalContainerConfig.class);
            TestPortalContainerConfig.assertEquals((String)"myPortal-dpcdef", (String)config.getPortalContainerName("foo"));
            TestPortalContainerConfig.assertEquals((String)"myPortal-dpcdef", (String)config.getPortalContainerName("myPortal"));
            TestPortalContainerConfig.assertEquals((String)"myPortal-dpcdef", (String)config.getPortalContainerName("myPortal-dpcdef"));
            TestPortalContainerConfig.assertNull((Object)config.getPortalContainerName("myPortal-pcdef"));
            TestPortalContainerConfig.assertFalse((boolean)config.isPortalContainerName("foo"));
            TestPortalContainerConfig.assertFalse((boolean)config.isPortalContainerName("myPortal"));
            TestPortalContainerConfig.assertTrue((boolean)config.isPortalContainerName("myPortal-dpcdef"));
            TestPortalContainerConfig.assertFalse((boolean)config.isPortalContainerName("myPortal-pcdef"));
            TestPortalContainerConfig.assertFalse((boolean)config.isScopeValid("foo", "fooX"));
            TestPortalContainerConfig.assertFalse((boolean)config.isScopeValid("myPortal", "fooX"));
            TestPortalContainerConfig.assertTrue((boolean)config.isScopeValid("myPortal-dpcdef", "fooX"));
            TestPortalContainerConfig.assertFalse((boolean)config.isScopeValid("myPortal-pcdef", "fooX"));
            TestPortalContainerConfig.assertTrue((boolean)config.isScopeValid("myPortal-dpcdef", "myPortal-dpcdef"));
            TestPortalContainerConfig.assertFalse((boolean)config.isScopeValid("myPortal-pcdef", "myPortal-pcdef"));
            names = config.getPortalContainerNames("myPortal-pcdef");
            TestPortalContainerConfig.assertTrue((names != null && names.isEmpty() ? 1 : 0) != 0);
            names = config.getPortalContainerNames("myPortal-dpcdef");
            TestPortalContainerConfig.assertTrue((names != null && !names.isEmpty() ? 1 : 0) != 0);
            TestPortalContainerConfig.assertEquals((int)1, (int)names.size());
            TestPortalContainerConfig.assertTrue((boolean)names.contains("myPortal-dpcdef"));
            names = config.getPortalContainerNames("fooX");
            TestPortalContainerConfig.assertTrue((names != null && !names.isEmpty() ? 1 : 0) != 0);
            TestPortalContainerConfig.assertEquals((int)1, (int)names.size());
            TestPortalContainerConfig.assertTrue((boolean)names.contains("myPortal-dpcdef"));
        }
        finally {
            this.clearSystemProperties();
        }
        try {
            rootContainer = this.createRootContainer("portal-container-config-with-default-values-and-with-portal-def-with-default-portal-def.xml", "disable-pc2");
            config = (PortalContainerConfig)rootContainer.getComponentInstanceOfType(PortalContainerConfig.class);
            TestPortalContainerConfig.assertEquals((String)"myPortal-pcdef", (String)config.getPortalContainerName("foo"));
            TestPortalContainerConfig.assertEquals((String)"myPortal-pcdef", (String)config.getPortalContainerName("myPortal"));
            TestPortalContainerConfig.assertNull((Object)config.getPortalContainerName("myPortal-dpcdef"));
            TestPortalContainerConfig.assertEquals((String)"myPortal-pcdef", (String)config.getPortalContainerName("myPortal-pcdef"));
            TestPortalContainerConfig.assertFalse((boolean)config.isPortalContainerName("foo"));
            TestPortalContainerConfig.assertFalse((boolean)config.isPortalContainerName("myPortal"));
            TestPortalContainerConfig.assertFalse((boolean)config.isPortalContainerName("myPortal-dpcdef"));
            TestPortalContainerConfig.assertTrue((boolean)config.isPortalContainerName("myPortal-pcdef"));
            TestPortalContainerConfig.assertFalse((boolean)config.isScopeValid("foo", "fooX"));
            TestPortalContainerConfig.assertFalse((boolean)config.isScopeValid("myPortal", "fooX"));
            TestPortalContainerConfig.assertFalse((boolean)config.isScopeValid("myPortal-dpcdef", "fooX"));
            TestPortalContainerConfig.assertTrue((boolean)config.isScopeValid("myPortal-pcdef", "fooX"));
            TestPortalContainerConfig.assertFalse((boolean)config.isScopeValid("myPortal-dpcdef", "myPortal-dpcdef"));
            TestPortalContainerConfig.assertTrue((boolean)config.isScopeValid("myPortal-pcdef", "myPortal-pcdef"));
            names = config.getPortalContainerNames("myPortal-pcdef");
            TestPortalContainerConfig.assertTrue((names != null && !names.isEmpty() ? 1 : 0) != 0);
            TestPortalContainerConfig.assertEquals((int)1, (int)names.size());
            TestPortalContainerConfig.assertTrue((boolean)names.contains("myPortal-pcdef"));
            names = config.getPortalContainerNames("myPortal-dpcdef");
            TestPortalContainerConfig.assertTrue((names != null && names.isEmpty() ? 1 : 0) != 0);
            names = config.getPortalContainerNames("fooX");
            TestPortalContainerConfig.assertTrue((names != null && !names.isEmpty() ? 1 : 0) != 0);
            TestPortalContainerConfig.assertEquals((int)1, (int)names.size());
            TestPortalContainerConfig.assertTrue((boolean)names.contains("myPortal-pcdef"));
        }
        finally {
            this.clearSystemProperties();
        }
        for (String profile : profiles = new String[]{"AddDependencies", "AddDependenciesBefore-No-Target", "AddDependenciesBefore-With-Fake-Target", "AddDependenciesBefore-With-Target", "AddDependenciesAfter-No-Target", "AddDependenciesAfter-With-Fake-Target", "AddDependenciesAfter-With-Target"}) {
            try {
                rootContainer = this.createRootContainer("portal-container-config-with-default-values-and-with-portal-def-with-default-portal-def.xml", "with-profiles", profile);
                config = (PortalContainerConfig)rootContainer.getComponentInstanceOfType(PortalContainerConfig.class);
                deps = config.getDependencies("foo");
                TestPortalContainerConfig.assertNull((Object)deps);
                deps = config.getDependencies("myPortal");
                TestPortalContainerConfig.assertNull((Object)deps);
                deps = config.getDependencies("myPortal-pcdef");
                TestPortalContainerConfig.assertTrue((deps != null && deps.size() == 2 && deps.contains("fooX") && deps.contains("foo") ? 1 : 0) != 0);
                index = deps.indexOf("foo");
                if (profile.equals("AddDependenciesBefore-No-Target") || profile.equals("AddDependenciesBefore-With-Fake-Target") || profile.equals("AddDependenciesBefore-With-Target")) {
                    TestPortalContainerConfig.assertEquals((int)0, (int)index);
                } else {
                    TestPortalContainerConfig.assertEquals((int)1, (int)index);
                }
                names = config.getPortalContainerNames("fooX");
                TestPortalContainerConfig.assertTrue((names != null && !names.isEmpty() ? 1 : 0) != 0);
                TestPortalContainerConfig.assertEquals((int)2, (int)names.size());
                TestPortalContainerConfig.assertTrue((boolean)names.contains("myPortal-dpcdef"));
                TestPortalContainerConfig.assertTrue((boolean)names.contains("myPortal-pcdef"));
                names = config.getPortalContainerNames("foo");
                TestPortalContainerConfig.assertTrue((names != null && !names.isEmpty() ? 1 : 0) != 0);
                TestPortalContainerConfig.assertEquals((int)2, (int)names.size());
                TestPortalContainerConfig.assertTrue((boolean)names.contains("myPortal-dpcdef"));
                TestPortalContainerConfig.assertTrue((boolean)names.contains("myPortal-pcdef"));
                names = config.getPortalContainerNames("myPortal");
                TestPortalContainerConfig.assertTrue((names != null && !names.isEmpty() ? 1 : 0) != 0);
                TestPortalContainerConfig.assertEquals((int)2, (int)names.size());
                TestPortalContainerConfig.assertTrue((boolean)names.contains("myPortal-dpcdef"));
                TestPortalContainerConfig.assertTrue((boolean)names.contains("myPortal-pcdef"));
                names = config.getPortalContainerNames("myPortal-pcdef");
                TestPortalContainerConfig.assertTrue((names != null && !names.isEmpty() ? 1 : 0) != 0);
                TestPortalContainerConfig.assertEquals((String)"myPortal-pcdef", (String)((String)names.get(0)));
                TestPortalContainerConfig.assertEquals((String)"myPortal-pcdef", (String)config.getPortalContainerName("foo"));
                TestPortalContainerConfig.assertEquals((String)"myPortal-dpcdef", (String)config.getPortalContainerName("myPortal"));
                TestPortalContainerConfig.assertEquals((String)"myPortal-pcdef", (String)config.getPortalContainerName("myPortal-pcdef"));
                TestPortalContainerConfig.assertEquals((String)"myRest-dpcdef", (String)config.getRestContextName("foo"));
                TestPortalContainerConfig.assertEquals((String)"myRest-dpcdef", (String)config.getRestContextName("myPortal"));
                TestPortalContainerConfig.assertEquals((String)"myRest-pcdef", (String)config.getRestContextName("myPortal-pcdef"));
                TestPortalContainerConfig.assertEquals((String)"my-exo-domain-dpcdef", (String)config.getRealmName("foo"));
                TestPortalContainerConfig.assertEquals((String)"my-exo-domain-dpcdef", (String)config.getRealmName("myPortal"));
                TestPortalContainerConfig.assertEquals((String)"my-exo-domain-pcdef", (String)config.getRealmName("myPortal-pcdef"));
                TestPortalContainerConfig.assertFalse((boolean)config.isPortalContainerName("foo"));
                TestPortalContainerConfig.assertFalse((boolean)config.isPortalContainerName("myPortal"));
                TestPortalContainerConfig.assertTrue((boolean)config.isPortalContainerName("myPortal-pcdef"));
                TestPortalContainerConfig.assertFalse((boolean)config.isScopeValid("foo", "fooX"));
                TestPortalContainerConfig.assertFalse((boolean)config.isScopeValid("myPortal", "fooX"));
                TestPortalContainerConfig.assertTrue((boolean)config.isScopeValid("myPortal-pcdef", "fooX"));
                TestPortalContainerConfig.assertTrue((boolean)config.hasDefinition());
            }
            finally {
                this.clearSystemProperties();
            }
            try {
                rootContainer = this.createRootContainer("portal-container-config-with-default-values-and-with-portal-def-with-default-portal-def.xml", "with-profiles", profile, "disable-pc");
                config = (PortalContainerConfig)rootContainer.getComponentInstanceOfType(PortalContainerConfig.class);
                TestPortalContainerConfig.assertEquals((String)"myPortal-dpcdef", (String)config.getPortalContainerName("foo"));
                TestPortalContainerConfig.assertEquals((String)"myPortal-dpcdef", (String)config.getPortalContainerName("myPortal"));
                TestPortalContainerConfig.assertEquals((String)"myPortal-dpcdef", (String)config.getPortalContainerName("myPortal-dpcdef"));
                TestPortalContainerConfig.assertNull((Object)config.getPortalContainerName("myPortal-pcdef"));
                TestPortalContainerConfig.assertFalse((boolean)config.isPortalContainerName("foo"));
                TestPortalContainerConfig.assertFalse((boolean)config.isPortalContainerName("myPortal"));
                TestPortalContainerConfig.assertTrue((boolean)config.isPortalContainerName("myPortal-dpcdef"));
                TestPortalContainerConfig.assertFalse((boolean)config.isPortalContainerName("myPortal-pcdef"));
                TestPortalContainerConfig.assertFalse((boolean)config.isScopeValid("foo", "fooX"));
                TestPortalContainerConfig.assertFalse((boolean)config.isScopeValid("myPortal", "fooX"));
                TestPortalContainerConfig.assertTrue((boolean)config.isScopeValid("myPortal-dpcdef", "fooX"));
                TestPortalContainerConfig.assertFalse((boolean)config.isScopeValid("myPortal-pcdef", "fooX"));
                TestPortalContainerConfig.assertTrue((boolean)config.isScopeValid("myPortal-dpcdef", "myPortal-dpcdef"));
                TestPortalContainerConfig.assertFalse((boolean)config.isScopeValid("myPortal-pcdef", "myPortal-pcdef"));
                names = config.getPortalContainerNames("myPortal-pcdef");
                TestPortalContainerConfig.assertTrue((names != null && names.isEmpty() ? 1 : 0) != 0);
                names = config.getPortalContainerNames("myPortal-dpcdef");
                TestPortalContainerConfig.assertTrue((names != null && !names.isEmpty() ? 1 : 0) != 0);
                TestPortalContainerConfig.assertEquals((int)1, (int)names.size());
                TestPortalContainerConfig.assertTrue((boolean)names.contains("myPortal-dpcdef"));
                names = config.getPortalContainerNames("foo");
                TestPortalContainerConfig.assertTrue((names != null && !names.isEmpty() ? 1 : 0) != 0);
                TestPortalContainerConfig.assertEquals((int)1, (int)names.size());
                TestPortalContainerConfig.assertTrue((boolean)names.contains("myPortal-dpcdef"));
                names = config.getPortalContainerNames("fooX");
                TestPortalContainerConfig.assertTrue((names != null && !names.isEmpty() ? 1 : 0) != 0);
                TestPortalContainerConfig.assertEquals((int)1, (int)names.size());
                TestPortalContainerConfig.assertTrue((boolean)names.contains("myPortal-dpcdef"));
            }
            finally {
                this.clearSystemProperties();
            }
            try {
                rootContainer = this.createRootContainer("portal-container-config-with-default-values-and-with-portal-def-with-default-portal-def.xml", "with-profiles", profile, "disable-pc2");
                config = (PortalContainerConfig)rootContainer.getComponentInstanceOfType(PortalContainerConfig.class);
                TestPortalContainerConfig.assertEquals((String)"myPortal-pcdef", (String)config.getPortalContainerName("foo"));
                TestPortalContainerConfig.assertEquals((String)"myPortal-pcdef", (String)config.getPortalContainerName("myPortal"));
                TestPortalContainerConfig.assertNull((Object)config.getPortalContainerName("myPortal-dpcdef"));
                TestPortalContainerConfig.assertEquals((String)"myPortal-pcdef", (String)config.getPortalContainerName("myPortal-pcdef"));
                TestPortalContainerConfig.assertFalse((boolean)config.isPortalContainerName("foo"));
                TestPortalContainerConfig.assertFalse((boolean)config.isPortalContainerName("myPortal"));
                TestPortalContainerConfig.assertFalse((boolean)config.isPortalContainerName("myPortal-dpcdef"));
                TestPortalContainerConfig.assertTrue((boolean)config.isPortalContainerName("myPortal-pcdef"));
                TestPortalContainerConfig.assertFalse((boolean)config.isScopeValid("foo", "fooX"));
                TestPortalContainerConfig.assertFalse((boolean)config.isScopeValid("myPortal", "fooX"));
                TestPortalContainerConfig.assertFalse((boolean)config.isScopeValid("myPortal-dpcdef", "fooX"));
                TestPortalContainerConfig.assertTrue((boolean)config.isScopeValid("myPortal-pcdef", "fooX"));
                TestPortalContainerConfig.assertFalse((boolean)config.isScopeValid("myPortal-dpcdef", "myPortal-dpcdef"));
                TestPortalContainerConfig.assertTrue((boolean)config.isScopeValid("myPortal-pcdef", "myPortal-pcdef"));
                names = config.getPortalContainerNames("myPortal-pcdef");
                TestPortalContainerConfig.assertTrue((names != null && !names.isEmpty() ? 1 : 0) != 0);
                TestPortalContainerConfig.assertEquals((int)1, (int)names.size());
                TestPortalContainerConfig.assertTrue((boolean)names.contains("myPortal-pcdef"));
                names = config.getPortalContainerNames("myPortal-dpcdef");
                TestPortalContainerConfig.assertTrue((names != null && names.isEmpty() ? 1 : 0) != 0);
                names = config.getPortalContainerNames("foo");
                TestPortalContainerConfig.assertTrue((names != null && !names.isEmpty() ? 1 : 0) != 0);
                TestPortalContainerConfig.assertEquals((int)1, (int)names.size());
                TestPortalContainerConfig.assertTrue((boolean)names.contains("myPortal-pcdef"));
                names = config.getPortalContainerNames("fooX");
                TestPortalContainerConfig.assertTrue((names != null && !names.isEmpty() ? 1 : 0) != 0);
                TestPortalContainerConfig.assertEquals((int)1, (int)names.size());
                TestPortalContainerConfig.assertTrue((boolean)names.contains("myPortal-pcdef"));
            }
            finally {
                this.clearSystemProperties();
            }
        }
        rootContainer = this.createRootContainer("portal-container-config-with-default-values-and-with-portal-def2.xml");
        config = (PortalContainerConfig)rootContainer.getComponentInstanceOfType(PortalContainerConfig.class);
        TestPortalContainerConfig.assertNull((Object)config.getDependencies("foo"));
        TestPortalContainerConfig.assertNull((Object)config.getDependencies("myPortal"));
        deps = config.getDependencies("myPortal-pcdef");
        TestPortalContainerConfig.assertTrue((deps != null && deps.size() == 3 ? 1 : 0) != 0);
        names = config.getPortalContainerNames("foo");
        TestPortalContainerConfig.assertTrue((names != null && !names.isEmpty() ? 1 : 0) != 0);
        TestPortalContainerConfig.assertEquals((String)"myPortal-pcdef", (String)((String)names.get(0)));
        names = config.getPortalContainerNames("myPortal");
        TestPortalContainerConfig.assertTrue((names != null && !names.isEmpty() ? 1 : 0) != 0);
        TestPortalContainerConfig.assertEquals((String)"myPortal", (String)((String)names.get(0)));
        names = config.getPortalContainerNames("myPortal-pcdef");
        TestPortalContainerConfig.assertTrue((names != null && !names.isEmpty() ? 1 : 0) != 0);
        TestPortalContainerConfig.assertEquals((String)"myPortal-pcdef", (String)((String)names.get(0)));
        TestPortalContainerConfig.assertEquals((String)"myPortal-pcdef", (String)config.getPortalContainerName("foo"));
        TestPortalContainerConfig.assertEquals((String)"myPortal", (String)config.getPortalContainerName("myPortal"));
        TestPortalContainerConfig.assertEquals((String)"myPortal-pcdef", (String)config.getPortalContainerName("myPortal-pcdef"));
        TestPortalContainerConfig.assertEquals((String)"myRest", (String)config.getRestContextName("foo"));
        TestPortalContainerConfig.assertEquals((String)"myRest", (String)config.getRestContextName("myPortal"));
        TestPortalContainerConfig.assertEquals((String)"myRest-pcdef", (String)config.getRestContextName("myPortal-pcdef"));
        TestPortalContainerConfig.assertEquals((String)"my-exo-domain", (String)config.getRealmName("foo"));
        TestPortalContainerConfig.assertEquals((String)"my-exo-domain", (String)config.getRealmName("myPortal"));
        TestPortalContainerConfig.assertEquals((String)"my-exo-domain-pcdef", (String)config.getRealmName("myPortal-pcdef"));
        TestPortalContainerConfig.assertFalse((boolean)config.isPortalContainerName("foo"));
        TestPortalContainerConfig.assertTrue((boolean)config.isPortalContainerName("myPortal"));
        TestPortalContainerConfig.assertTrue((boolean)config.isPortalContainerName("myPortal-pcdef"));
        TestPortalContainerConfig.assertFalse((boolean)config.isScopeValid("foo", "foo"));
        TestPortalContainerConfig.assertFalse((boolean)config.isScopeValid("myPortal", "foo"));
        TestPortalContainerConfig.assertTrue((boolean)config.isScopeValid("myPortal-pcdef", "foo"));
        TestPortalContainerConfig.assertFalse((boolean)config.isScopeValid("myPortal-pcdef", "myPortal"));
        TestPortalContainerConfig.assertTrue((boolean)config.isScopeValid("myPortal-pcdef", "fooY"));
        TestPortalContainerConfig.assertTrue((boolean)config.hasDefinition());
        rootContainer = this.createRootContainer("portal-container-config-with-default-values-and-with-portal-def2.xml", "disable-pc");
        config = (PortalContainerConfig)rootContainer.getComponentInstanceOfType(PortalContainerConfig.class);
        TestPortalContainerConfig.assertEquals((String)"myPortal", (String)config.getPortalContainerName("foo"));
        TestPortalContainerConfig.assertEquals((String)"myPortal", (String)config.getPortalContainerName("myPortal"));
        TestPortalContainerConfig.assertNull((Object)config.getPortalContainerName("myPortal-pcdef"));
        TestPortalContainerConfig.assertTrue((boolean)config.isPortalContainerName("myPortal"));
        TestPortalContainerConfig.assertFalse((boolean)config.isPortalContainerName("myPortal-pcdef"));
        TestPortalContainerConfig.assertFalse((boolean)config.isScopeValid("myPortal-pcdef", "myPortal-pcdef"));
        TestPortalContainerConfig.assertFalse((boolean)config.isScopeValid("myPortal-pcdef", "myPortal"));
        TestPortalContainerConfig.assertFalse((boolean)config.isScopeValid("myPortal-pcdef", "foo"));
        TestPortalContainerConfig.assertFalse((boolean)config.isScopeValid("myPortal", "myPortal-pcdef"));
        TestPortalContainerConfig.assertTrue((boolean)config.isScopeValid("myPortal", "myPortal"));
        TestPortalContainerConfig.assertTrue((boolean)config.isScopeValid("myPortal", "foo"));
        names = config.getPortalContainerNames("myPortal-pcdef");
        TestPortalContainerConfig.assertTrue((names != null && names.isEmpty() ? 1 : 0) != 0);
        names = config.getPortalContainerNames("myPortal");
        TestPortalContainerConfig.assertTrue((names != null && !names.isEmpty() ? 1 : 0) != 0);
        TestPortalContainerConfig.assertEquals((int)1, (int)names.size());
        TestPortalContainerConfig.assertTrue((boolean)names.contains("myPortal"));
        names = config.getPortalContainerNames("foo");
        TestPortalContainerConfig.assertTrue((names != null && !names.isEmpty() ? 1 : 0) != 0);
        TestPortalContainerConfig.assertEquals((int)1, (int)names.size());
        TestPortalContainerConfig.assertTrue((boolean)names.contains("myPortal"));
        rootContainer = this.createRootContainer("portal-container-config-with-default-values-and-with-portal-def2.xml", "disable-pc2");
        config = (PortalContainerConfig)rootContainer.getComponentInstanceOfType(PortalContainerConfig.class);
        TestPortalContainerConfig.assertEquals((String)"myPortal-pcdef", (String)config.getPortalContainerName("foo"));
        TestPortalContainerConfig.assertEquals((String)"myPortal-pcdef", (String)config.getPortalContainerName("myPortal"));
        TestPortalContainerConfig.assertEquals((String)"myPortal-pcdef", (String)config.getPortalContainerName("myPortal-pcdef"));
        TestPortalContainerConfig.assertFalse((boolean)config.isPortalContainerName("myPortal"));
        TestPortalContainerConfig.assertTrue((boolean)config.isPortalContainerName("myPortal-pcdef"));
        TestPortalContainerConfig.assertTrue((boolean)config.isScopeValid("myPortal-pcdef", "myPortal-pcdef"));
        TestPortalContainerConfig.assertTrue((boolean)config.isScopeValid("myPortal-pcdef", "myPortal"));
        TestPortalContainerConfig.assertTrue((boolean)config.isScopeValid("myPortal-pcdef", "foo"));
        TestPortalContainerConfig.assertFalse((boolean)config.isScopeValid("myPortal", "myPortal-pcdef"));
        TestPortalContainerConfig.assertFalse((boolean)config.isScopeValid("myPortal", "myPortal"));
        TestPortalContainerConfig.assertFalse((boolean)config.isScopeValid("myPortal", "foo"));
        names = config.getPortalContainerNames("myPortal-pcdef");
        TestPortalContainerConfig.assertTrue((names != null && !names.isEmpty() ? 1 : 0) != 0);
        TestPortalContainerConfig.assertEquals((int)1, (int)names.size());
        TestPortalContainerConfig.assertTrue((boolean)names.contains("myPortal-pcdef"));
        names = config.getPortalContainerNames("myPortal");
        TestPortalContainerConfig.assertTrue((names != null && !names.isEmpty() ? 1 : 0) != 0);
        TestPortalContainerConfig.assertEquals((int)1, (int)names.size());
        TestPortalContainerConfig.assertTrue((boolean)names.contains("myPortal-pcdef"));
        names = config.getPortalContainerNames("foo");
        TestPortalContainerConfig.assertTrue((names != null && !names.isEmpty() ? 1 : 0) != 0);
        TestPortalContainerConfig.assertEquals((int)1, (int)names.size());
        TestPortalContainerConfig.assertTrue((boolean)names.contains("myPortal-pcdef"));
        for (String profile : profiles) {
            rootContainer = this.createRootContainer("portal-container-config-with-default-values-and-with-portal-def2.xml", "with-profiles", profile);
            config = (PortalContainerConfig)rootContainer.getComponentInstanceOfType(PortalContainerConfig.class);
            deps = config.getDependencies("foo");
            TestPortalContainerConfig.assertNull((Object)deps);
            deps = config.getDependencies("myPortal");
            TestPortalContainerConfig.assertNull((Object)deps);
            deps = config.getDependencies("myPortal-pcdef");
            TestPortalContainerConfig.assertTrue((deps != null && deps.size() == 4 ? 1 : 0) != 0);
            index = deps.indexOf("fooX");
            if (profile.equals("AddDependenciesBefore-No-Target") || profile.equals("AddDependenciesBefore-With-Fake-Target")) {
                TestPortalContainerConfig.assertEquals((int)0, (int)index);
            } else if (profile.equals("AddDependenciesBefore-With-Target")) {
                TestPortalContainerConfig.assertEquals((int)1, (int)index);
            } else if (profile.equals("AddDependenciesAfter-With-Target")) {
                TestPortalContainerConfig.assertEquals((int)2, (int)index);
            } else {
                TestPortalContainerConfig.assertEquals((int)3, (int)index);
            }
            names = config.getPortalContainerNames("foo");
            TestPortalContainerConfig.assertTrue((names != null && !names.isEmpty() ? 1 : 0) != 0);
            TestPortalContainerConfig.assertEquals((String)"myPortal-pcdef", (String)((String)names.get(0)));
            names = config.getPortalContainerNames("myPortal");
            TestPortalContainerConfig.assertTrue((names != null && !names.isEmpty() ? 1 : 0) != 0);
            TestPortalContainerConfig.assertEquals((String)"myPortal", (String)((String)names.get(0)));
            names = config.getPortalContainerNames("myPortal-pcdef");
            TestPortalContainerConfig.assertTrue((names != null && !names.isEmpty() ? 1 : 0) != 0);
            TestPortalContainerConfig.assertEquals((String)"myPortal-pcdef", (String)((String)names.get(0)));
            TestPortalContainerConfig.assertEquals((String)"myPortal-pcdef", (String)config.getPortalContainerName("foo"));
            TestPortalContainerConfig.assertEquals((String)"myPortal", (String)config.getPortalContainerName("myPortal"));
            TestPortalContainerConfig.assertEquals((String)"myPortal-pcdef", (String)config.getPortalContainerName("myPortal-pcdef"));
            TestPortalContainerConfig.assertEquals((String)"myRest", (String)config.getRestContextName("foo"));
            TestPortalContainerConfig.assertEquals((String)"myRest", (String)config.getRestContextName("myPortal"));
            TestPortalContainerConfig.assertEquals((String)"myRest-pcdef", (String)config.getRestContextName("myPortal-pcdef"));
            TestPortalContainerConfig.assertEquals((String)"my-exo-domain", (String)config.getRealmName("foo"));
            TestPortalContainerConfig.assertEquals((String)"my-exo-domain", (String)config.getRealmName("myPortal"));
            TestPortalContainerConfig.assertEquals((String)"my-exo-domain-pcdef", (String)config.getRealmName("myPortal-pcdef"));
            TestPortalContainerConfig.assertFalse((boolean)config.isPortalContainerName("foo"));
            TestPortalContainerConfig.assertTrue((boolean)config.isPortalContainerName("myPortal"));
            TestPortalContainerConfig.assertTrue((boolean)config.isPortalContainerName("myPortal-pcdef"));
            TestPortalContainerConfig.assertFalse((boolean)config.isScopeValid("foo", "foo"));
            TestPortalContainerConfig.assertFalse((boolean)config.isScopeValid("myPortal", "foo"));
            TestPortalContainerConfig.assertTrue((boolean)config.isScopeValid("myPortal-pcdef", "foo"));
            TestPortalContainerConfig.assertTrue((boolean)config.hasDefinition());
            rootContainer = this.createRootContainer("portal-container-config-with-default-values-and-with-portal-def2.xml", "with-profiles", profile, "disable-pc");
            config = (PortalContainerConfig)rootContainer.getComponentInstanceOfType(PortalContainerConfig.class);
            TestPortalContainerConfig.assertEquals((String)"myPortal", (String)config.getPortalContainerName("foo"));
            TestPortalContainerConfig.assertNull((Object)config.getPortalContainerName("myPortal-pcdef"));
            TestPortalContainerConfig.assertFalse((boolean)config.isPortalContainerName("myPortal-pcdef"));
            TestPortalContainerConfig.assertFalse((boolean)config.isScopeValid("myPortal-pcdef", "myPortal-pcdef"));
            names = config.getPortalContainerNames("myPortal-pcdef");
            TestPortalContainerConfig.assertTrue((names != null && names.isEmpty() ? 1 : 0) != 0);
            TestPortalContainerConfig.assertFalse((boolean)config.isScopeValid("myPortal-pcdef", "foo"));
            names = config.getPortalContainerNames("foo");
            TestPortalContainerConfig.assertTrue((names != null && !names.isEmpty() ? 1 : 0) != 0);
            TestPortalContainerConfig.assertEquals((int)1, (int)names.size());
            TestPortalContainerConfig.assertTrue((boolean)names.contains("myPortal"));
        }
        rootContainer = this.createRootContainer("portal-container-config-with-default-values-and-with-portal-def-with-default-portal-def2.xml");
        config = (PortalContainerConfig)rootContainer.getComponentInstanceOfType(PortalContainerConfig.class);
        deps = config.getDependencies("foo");
        TestPortalContainerConfig.assertNull((Object)deps);
        deps = config.getDependencies("myPortal");
        TestPortalContainerConfig.assertNull((Object)deps);
        deps = config.getDependencies("myPortal-pcdef");
        TestPortalContainerConfig.assertTrue((deps != null && deps.size() == 3 ? 1 : 0) != 0);
        names = config.getPortalContainerNames("fooX");
        TestPortalContainerConfig.assertTrue((names != null && !names.isEmpty() ? 1 : 0) != 0);
        TestPortalContainerConfig.assertEquals((int)1, (int)names.size());
        TestPortalContainerConfig.assertEquals((String)"myPortal", (String)((String)names.get(0)));
        names = config.getPortalContainerNames("foo");
        TestPortalContainerConfig.assertTrue((names != null && !names.isEmpty() ? 1 : 0) != 0);
        TestPortalContainerConfig.assertEquals((int)1, (int)names.size());
        TestPortalContainerConfig.assertEquals((String)"myPortal-pcdef", (String)((String)names.get(0)));
        names = config.getPortalContainerNames("myPortal");
        TestPortalContainerConfig.assertTrue((names != null && !names.isEmpty() ? 1 : 0) != 0);
        TestPortalContainerConfig.assertEquals((String)"myPortal", (String)((String)names.get(0)));
        names = config.getPortalContainerNames("myPortal-pcdef");
        TestPortalContainerConfig.assertTrue((names != null && !names.isEmpty() ? 1 : 0) != 0);
        TestPortalContainerConfig.assertEquals((String)"myPortal-pcdef", (String)((String)names.get(0)));
        TestPortalContainerConfig.assertEquals((String)"myPortal-pcdef", (String)config.getPortalContainerName("foo"));
        TestPortalContainerConfig.assertEquals((String)"myPortal", (String)config.getPortalContainerName("myPortal"));
        TestPortalContainerConfig.assertEquals((String)"myPortal-pcdef", (String)config.getPortalContainerName("myPortal-pcdef"));
        TestPortalContainerConfig.assertEquals((String)"myRest", (String)config.getRestContextName("foo"));
        TestPortalContainerConfig.assertEquals((String)"myRest", (String)config.getRestContextName("myPortal"));
        TestPortalContainerConfig.assertEquals((String)"myRest-pcdef", (String)config.getRestContextName("myPortal-pcdef"));
        TestPortalContainerConfig.assertEquals((String)"my-exo-domain", (String)config.getRealmName("foo"));
        TestPortalContainerConfig.assertEquals((String)"my-exo-domain", (String)config.getRealmName("myPortal"));
        TestPortalContainerConfig.assertEquals((String)"my-exo-domain-pcdef", (String)config.getRealmName("myPortal-pcdef"));
        TestPortalContainerConfig.assertFalse((boolean)config.isPortalContainerName("foo"));
        TestPortalContainerConfig.assertTrue((boolean)config.isPortalContainerName("myPortal"));
        TestPortalContainerConfig.assertTrue((boolean)config.isPortalContainerName("myPortal-pcdef"));
        TestPortalContainerConfig.assertFalse((boolean)config.isScopeValid("foo", "foo"));
        TestPortalContainerConfig.assertFalse((boolean)config.isScopeValid("myPortal", "foo"));
        TestPortalContainerConfig.assertTrue((boolean)config.isScopeValid("myPortal-pcdef", "foo"));
        TestPortalContainerConfig.assertTrue((boolean)config.hasDefinition());
        rootContainer = this.createRootContainer("portal-container-config-with-default-values-and-with-portal-def-with-default-portal-def2.xml", "disable-pc");
        config = (PortalContainerConfig)rootContainer.getComponentInstanceOfType(PortalContainerConfig.class);
        TestPortalContainerConfig.assertEquals((String)"myPortal", (String)config.getPortalContainerName("foo"));
        TestPortalContainerConfig.assertNull((Object)config.getPortalContainerName("myPortal-pcdef"));
        TestPortalContainerConfig.assertFalse((boolean)config.isPortalContainerName("myPortal-pcdef"));
        TestPortalContainerConfig.assertFalse((boolean)config.isScopeValid("myPortal-pcdef", "myPortal-pcdef"));
        names = config.getPortalContainerNames("myPortal-pcdef");
        TestPortalContainerConfig.assertTrue((names != null && names.isEmpty() ? 1 : 0) != 0);
        TestPortalContainerConfig.assertFalse((boolean)config.isScopeValid("myPortal-pcdef", "foo"));
        names = config.getPortalContainerNames("foo");
        TestPortalContainerConfig.assertTrue((names != null && !names.isEmpty() ? 1 : 0) != 0);
        TestPortalContainerConfig.assertEquals((int)1, (int)names.size());
        TestPortalContainerConfig.assertTrue((boolean)names.contains("myPortal"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSettings() throws Exception {
        RootContainer rootContainer = this.createRootContainer("portal-container-config-with-no-default-values.xml");
        PortalContainerConfig config = (PortalContainerConfig)rootContainer.getComponentInstanceOfType(PortalContainerConfig.class);
        TestPortalContainerConfig.assertNull((Object)config.getSetting("foo", "foo"));
        TestPortalContainerConfig.assertNull((Object)config.getSetting("myPortal", "foo"));
        TestPortalContainerConfig.assertNull((Object)config.getSetting("myPortal-pcdef", "foo"));
        TestPortalContainerConfig.assertEquals((Object)PortalContainerConfig.DEFAULT_PORTAL_CONTAINER_NAME, (Object)config.getSetting("foo", "name"));
        TestPortalContainerConfig.assertEquals((Object)PortalContainerConfig.DEFAULT_PORTAL_CONTAINER_NAME, (Object)config.getSetting("myPortal", "name"));
        TestPortalContainerConfig.assertEquals((Object)PortalContainerConfig.DEFAULT_PORTAL_CONTAINER_NAME, (Object)config.getSetting("myPortal-pcdef", "name"));
        TestPortalContainerConfig.assertEquals((Object)PortalContainerConfig.DEFAULT_REST_CONTEXT_NAME, (Object)config.getSetting("foo", "rest"));
        TestPortalContainerConfig.assertEquals((Object)PortalContainerConfig.DEFAULT_REST_CONTEXT_NAME, (Object)config.getSetting("myPortal", "rest"));
        TestPortalContainerConfig.assertEquals((Object)PortalContainerConfig.DEFAULT_REST_CONTEXT_NAME, (Object)config.getSetting("myPortal-pcdef", "rest"));
        TestPortalContainerConfig.assertEquals((Object)PortalContainerConfig.DEFAULT_REALM_NAME, (Object)config.getSetting("foo", "realm"));
        TestPortalContainerConfig.assertEquals((Object)PortalContainerConfig.DEFAULT_REALM_NAME, (Object)config.getSetting("myPortal", "realm"));
        TestPortalContainerConfig.assertEquals((Object)PortalContainerConfig.DEFAULT_REALM_NAME, (Object)config.getSetting("myPortal-pcdef", "realm"));
        try {
            rootContainer = this.createRootContainer("portal-container-config-with-no-default-values.xml", "with-profiles");
            config = (PortalContainerConfig)rootContainer.getComponentInstanceOfType(PortalContainerConfig.class);
            TestPortalContainerConfig.assertNull((Object)config.getSetting("foo", "foo"));
            TestPortalContainerConfig.assertNull((Object)config.getSetting("myPortal", "foo"));
            TestPortalContainerConfig.assertNull((Object)config.getSetting("myPortal-pcdef", "foo"));
            TestPortalContainerConfig.assertEquals((Object)PortalContainerConfig.DEFAULT_PORTAL_CONTAINER_NAME, (Object)config.getSetting("foo", "name"));
            TestPortalContainerConfig.assertEquals((Object)PortalContainerConfig.DEFAULT_PORTAL_CONTAINER_NAME, (Object)config.getSetting("myPortal", "name"));
            TestPortalContainerConfig.assertEquals((Object)PortalContainerConfig.DEFAULT_PORTAL_CONTAINER_NAME, (Object)config.getSetting("myPortal-pcdef", "name"));
            TestPortalContainerConfig.assertEquals((Object)PortalContainerConfig.DEFAULT_REST_CONTEXT_NAME, (Object)config.getSetting("foo", "rest"));
            TestPortalContainerConfig.assertEquals((Object)PortalContainerConfig.DEFAULT_REST_CONTEXT_NAME, (Object)config.getSetting("myPortal", "rest"));
            TestPortalContainerConfig.assertEquals((Object)PortalContainerConfig.DEFAULT_REST_CONTEXT_NAME, (Object)config.getSetting("myPortal-pcdef", "rest"));
            TestPortalContainerConfig.assertEquals((Object)PortalContainerConfig.DEFAULT_REALM_NAME, (Object)config.getSetting("foo", "realm"));
            TestPortalContainerConfig.assertEquals((Object)PortalContainerConfig.DEFAULT_REALM_NAME, (Object)config.getSetting("myPortal", "realm"));
            TestPortalContainerConfig.assertEquals((Object)PortalContainerConfig.DEFAULT_REALM_NAME, (Object)config.getSetting("myPortal-pcdef", "realm"));
            TestPortalContainerConfig.assertEquals((Object)"value1", (Object)config.getSetting("foo", "string"));
            TestPortalContainerConfig.assertEquals((Object)"value1", (Object)config.getSetting("foo", "stringX"));
        }
        finally {
            this.clearSystemProperties();
        }
        try {
            rootContainer = this.createRootContainer("portal-container-config-with-default-values.xml");
            config = (PortalContainerConfig)rootContainer.getComponentInstanceOfType(PortalContainerConfig.class);
            TestPortalContainerConfig.assertNull((Object)config.getSetting("foo", "foo"));
            TestPortalContainerConfig.assertNull((Object)config.getSetting("myPortal", "foo"));
            TestPortalContainerConfig.assertNull((Object)config.getSetting("myPortal-pcdef", "foo"));
            TestPortalContainerConfig.assertEquals((Object)"myPortal", (Object)config.getSetting("foo", "name"));
            TestPortalContainerConfig.assertEquals((Object)"myPortal", (Object)config.getSetting("myPortal", "name"));
            TestPortalContainerConfig.assertEquals((Object)"myPortal", (Object)config.getSetting("myPortal-pcdef", "name"));
            TestPortalContainerConfig.assertEquals((Object)"myRest", (Object)config.getSetting("foo", "rest"));
            TestPortalContainerConfig.assertEquals((Object)"myRest", (Object)config.getSetting("myPortal", "rest"));
            TestPortalContainerConfig.assertEquals((Object)"myRest", (Object)config.getSetting("myPortal-pcdef", "rest"));
            TestPortalContainerConfig.assertEquals((Object)"my-exo-domain", (Object)config.getSetting("foo", "realm"));
            TestPortalContainerConfig.assertEquals((Object)"my-exo-domain", (Object)config.getSetting("myPortal", "realm"));
            TestPortalContainerConfig.assertEquals((Object)"my-exo-domain", (Object)config.getSetting("myPortal-pcdef", "realm"));
        }
        finally {
            this.clearSystemProperties();
        }
        try {
            rootContainer = this.createRootContainer("portal-container-config-with-default-values-and-with-empty-default-portal-def.xml");
            config = (PortalContainerConfig)rootContainer.getComponentInstanceOfType(PortalContainerConfig.class);
            TestPortalContainerConfig.assertNull((Object)config.getSetting("foo", "foo"));
            TestPortalContainerConfig.assertNull((Object)config.getSetting("myPortal", "foo"));
            TestPortalContainerConfig.assertNull((Object)config.getSetting("myPortal-pcdef", "foo"));
            TestPortalContainerConfig.assertEquals((Object)"myPortal", (Object)config.getSetting("foo", "name"));
            TestPortalContainerConfig.assertEquals((Object)"myPortal", (Object)config.getSetting("myPortal", "name"));
            TestPortalContainerConfig.assertEquals((Object)"myPortal", (Object)config.getSetting("myPortal-pcdef", "name"));
            TestPortalContainerConfig.assertEquals((Object)"myRest", (Object)config.getSetting("foo", "rest"));
            TestPortalContainerConfig.assertEquals((Object)"myRest", (Object)config.getSetting("myPortal", "rest"));
            TestPortalContainerConfig.assertEquals((Object)"myRest", (Object)config.getSetting("myPortal-pcdef", "rest"));
            TestPortalContainerConfig.assertEquals((Object)"my-exo-domain", (Object)config.getSetting("foo", "realm"));
            TestPortalContainerConfig.assertEquals((Object)"my-exo-domain", (Object)config.getSetting("myPortal", "realm"));
            TestPortalContainerConfig.assertEquals((Object)"my-exo-domain", (Object)config.getSetting("myPortal-pcdef", "realm"));
        }
        finally {
            this.clearSystemProperties();
        }
        try {
            rootContainer = this.createRootContainer("portal-container-config-with-default-values-and-with-default-portal-def.xml");
            config = (PortalContainerConfig)rootContainer.getComponentInstanceOfType(PortalContainerConfig.class);
            TestPortalContainerConfig.assertNull((Object)config.getSetting("foo", "foo"));
            TestPortalContainerConfig.assertNull((Object)config.getSetting("myPortal", "foo"));
            TestPortalContainerConfig.assertNull((Object)config.getSetting("myPortal-pcdef", "foo"));
            TestPortalContainerConfig.assertEquals((Object)"myPortal-dpcdef", (Object)config.getSetting("foo", "name"));
            TestPortalContainerConfig.assertEquals((Object)"myPortal-dpcdef", (Object)config.getSetting("myPortal", "name"));
            TestPortalContainerConfig.assertEquals((Object)"myPortal-dpcdef", (Object)config.getSetting("myPortal-pcdef", "name"));
            TestPortalContainerConfig.assertEquals((Object)"myRest-dpcdef", (Object)config.getSetting("foo", "rest"));
            TestPortalContainerConfig.assertEquals((Object)"myRest-dpcdef", (Object)config.getSetting("myPortal", "rest"));
            TestPortalContainerConfig.assertEquals((Object)"myRest-dpcdef", (Object)config.getSetting("myPortal-pcdef", "rest"));
            TestPortalContainerConfig.assertEquals((Object)"my-exo-domain-dpcdef", (Object)config.getSetting("foo", "realm"));
            TestPortalContainerConfig.assertEquals((Object)"my-exo-domain-dpcdef", (Object)config.getSetting("myPortal", "realm"));
            TestPortalContainerConfig.assertEquals((Object)"my-exo-domain-dpcdef", (Object)config.getSetting("myPortal-pcdef", "realm"));
            TestPortalContainerConfig.assertEquals((Object)"value0", (Object)config.getSetting("foo", "string"));
            TestPortalContainerConfig.assertEquals((Object)new Integer(100), (Object)config.getSetting("foo", "int"));
            TestPortalContainerConfig.assertEquals((Object)new Long(100L), (Object)config.getSetting("foo", "long"));
            TestPortalContainerConfig.assertEquals((Object)new Double(100.0), (Object)config.getSetting("foo", "double"));
            TestPortalContainerConfig.assertEquals((Object)new Boolean(false), (Object)config.getSetting("foo", "boolean"));
            TestPortalContainerConfig.assertEquals((Object)"value0", (Object)config.getSetting("myPortal", "string"));
            TestPortalContainerConfig.assertEquals((Object)new Integer(100), (Object)config.getSetting("myPortal", "int"));
            TestPortalContainerConfig.assertEquals((Object)new Long(100L), (Object)config.getSetting("myPortal", "long"));
            TestPortalContainerConfig.assertEquals((Object)new Double(100.0), (Object)config.getSetting("myPortal", "double"));
            TestPortalContainerConfig.assertEquals((Object)new Boolean(false), (Object)config.getSetting("myPortal", "boolean"));
            TestPortalContainerConfig.assertEquals((Object)"value0", (Object)config.getSetting("myPortal-pcdef", "string"));
            TestPortalContainerConfig.assertEquals((Object)new Integer(100), (Object)config.getSetting("myPortal-pcdef", "int"));
            TestPortalContainerConfig.assertEquals((Object)new Long(100L), (Object)config.getSetting("myPortal-pcdef", "long"));
            TestPortalContainerConfig.assertEquals((Object)new Double(100.0), (Object)config.getSetting("myPortal-pcdef", "double"));
            TestPortalContainerConfig.assertEquals((Object)new Boolean(false), (Object)config.getSetting("myPortal-pcdef", "boolean"));
        }
        finally {
            this.clearSystemProperties();
        }
        try {
            rootContainer = this.createRootContainer("portal-container-config-with-default-values-and-with-portal-def.xml");
            config = (PortalContainerConfig)rootContainer.getComponentInstanceOfType(PortalContainerConfig.class);
            TestPortalContainerConfig.assertNull((Object)config.getSetting("foo", "foo"));
            TestPortalContainerConfig.assertNull((Object)config.getSetting("myPortal", "foo"));
            TestPortalContainerConfig.assertNull((Object)config.getSetting("myPortal-pcdef", "foo"));
            TestPortalContainerConfig.assertEquals((Object)"myPortal", (Object)config.getSetting("foo", "name"));
            TestPortalContainerConfig.assertEquals((Object)"myPortal", (Object)config.getSetting("myPortal", "name"));
            TestPortalContainerConfig.assertEquals((Object)"myPortal-pcdef", (Object)config.getSetting("myPortal-pcdef", "name"));
            TestPortalContainerConfig.assertEquals((Object)"myRest", (Object)config.getSetting("foo", "rest"));
            TestPortalContainerConfig.assertEquals((Object)"myRest", (Object)config.getSetting("myPortal", "rest"));
            TestPortalContainerConfig.assertEquals((Object)"myRest-pcdef", (Object)config.getSetting("myPortal-pcdef", "rest"));
            TestPortalContainerConfig.assertEquals((Object)"my-exo-domain", (Object)config.getSetting("foo", "realm"));
            TestPortalContainerConfig.assertEquals((Object)"my-exo-domain", (Object)config.getSetting("myPortal", "realm"));
            TestPortalContainerConfig.assertEquals((Object)"my-exo-domain-pcdef", (Object)config.getSetting("myPortal-pcdef", "realm"));
        }
        finally {
            System.getProperties().remove("_ignore.unregistered.webapp.true");
            System.getProperties().remove("_ignore.unregistered.webapp.false");
            PropertyManager.refresh();
        }
        try {
            rootContainer = this.createRootContainer("portal-container-config-with-default-values-and-with-portal-def-with-default-portal-def.xml");
            config = (PortalContainerConfig)rootContainer.getComponentInstanceOfType(PortalContainerConfig.class);
            TestPortalContainerConfig.assertNull((Object)config.getSetting("foo", "foo"));
            TestPortalContainerConfig.assertNull((Object)config.getSetting("myPortal", "foo"));
            TestPortalContainerConfig.assertNull((Object)config.getSetting("myPortal-pcdef", "foo"));
            TestPortalContainerConfig.assertEquals((Object)"myPortal-dpcdef", (Object)config.getSetting("foo", "name"));
            TestPortalContainerConfig.assertEquals((Object)"myPortal-dpcdef", (Object)config.getSetting("myPortal", "name"));
            TestPortalContainerConfig.assertEquals((Object)"myPortal-pcdef", (Object)config.getSetting("myPortal-pcdef", "name"));
            TestPortalContainerConfig.assertEquals((Object)"myRest-dpcdef", (Object)config.getSetting("foo", "rest"));
            TestPortalContainerConfig.assertEquals((Object)"myRest-dpcdef", (Object)config.getSetting("myPortal", "rest"));
            TestPortalContainerConfig.assertEquals((Object)"myRest-pcdef", (Object)config.getSetting("myPortal-pcdef", "rest"));
            TestPortalContainerConfig.assertEquals((Object)"my-exo-domain-dpcdef", (Object)config.getSetting("foo", "realm"));
            TestPortalContainerConfig.assertEquals((Object)"my-exo-domain-dpcdef", (Object)config.getSetting("myPortal", "realm"));
            TestPortalContainerConfig.assertEquals((Object)"my-exo-domain-pcdef", (Object)config.getSetting("myPortal-pcdef", "realm"));
        }
        finally {
            this.clearSystemProperties();
        }
        try {
            rootContainer = this.createRootContainer("portal-container-config-with-default-values-and-with-settings.xml");
            config = (PortalContainerConfig)rootContainer.getComponentInstanceOfType(PortalContainerConfig.class);
            TestPortalContainerConfig.assertNull((Object)config.getSetting("foo", "foo"));
            TestPortalContainerConfig.assertNull((Object)config.getSetting("myPortal", "foo"));
            TestPortalContainerConfig.assertEquals((Object)"value", (Object)config.getSetting("myPortal-pcdef", "foo"));
            TestPortalContainerConfig.assertNull((Object)config.getSetting("foo", "foo2"));
            TestPortalContainerConfig.assertNull((Object)config.getSetting("myPortal", "foo2"));
            TestPortalContainerConfig.assertNull((Object)config.getSetting("myPortal-pcdef", "foo2"));
            TestPortalContainerConfig.assertEquals((Object)"value", (Object)config.getSetting("myPortal-pcdef", "string"));
            TestPortalContainerConfig.assertEquals((Object)new Integer(10), (Object)config.getSetting("myPortal-pcdef", "int"));
            TestPortalContainerConfig.assertEquals((Object)new Long(10L), (Object)config.getSetting("myPortal-pcdef", "long"));
            TestPortalContainerConfig.assertEquals((Object)new Double(10.0), (Object)config.getSetting("myPortal-pcdef", "double"));
            TestPortalContainerConfig.assertEquals((Object)new Boolean(true), (Object)config.getSetting("myPortal-pcdef", "boolean"));
            TestPortalContainerConfig.assertEquals((Object)"myPortal", (Object)config.getSetting("foo", "name"));
            TestPortalContainerConfig.assertEquals((Object)"myPortal", (Object)config.getSetting("myPortal", "name"));
            TestPortalContainerConfig.assertEquals((Object)"myPortal-pcdef", (Object)config.getSetting("myPortal-pcdef", "name"));
            TestPortalContainerConfig.assertEquals((Object)"myRest", (Object)config.getSetting("foo", "rest"));
            TestPortalContainerConfig.assertEquals((Object)"myRest", (Object)config.getSetting("myPortal", "rest"));
            TestPortalContainerConfig.assertEquals((Object)"myRest-pcdef", (Object)config.getSetting("myPortal-pcdef", "rest"));
            TestPortalContainerConfig.assertEquals((Object)"my-exo-domain", (Object)config.getSetting("foo", "realm"));
            TestPortalContainerConfig.assertEquals((Object)"my-exo-domain", (Object)config.getSetting("myPortal", "realm"));
            TestPortalContainerConfig.assertEquals((Object)"my-exo-domain-pcdef", (Object)config.getSetting("myPortal-pcdef", "realm"));
        }
        finally {
            this.clearSystemProperties();
        }
        try {
            rootContainer = this.createRootContainer("portal-container-config-with-default-values-and-with-settings-with-default-portal-def.xml");
            config = (PortalContainerConfig)rootContainer.getComponentInstanceOfType(PortalContainerConfig.class);
            TestPortalContainerConfig.assertNull((Object)config.getSetting("foo", "foo"));
            TestPortalContainerConfig.assertNull((Object)config.getSetting("myPortal", "foo"));
            TestPortalContainerConfig.assertEquals((Object)"value", (Object)config.getSetting("myPortal-pcdef", "foo"));
            TestPortalContainerConfig.assertEquals((Object)"value", (Object)config.getSetting("foo", "foo2"));
            TestPortalContainerConfig.assertEquals((Object)"value", (Object)config.getSetting("myPortal", "foo2"));
            TestPortalContainerConfig.assertEquals((Object)"value", (Object)config.getSetting("myPortal-pcdef", "foo2"));
            TestPortalContainerConfig.assertNull((Object)config.getSetting("foo", "foo3"));
            TestPortalContainerConfig.assertNull((Object)config.getSetting("myPortal", "foo3"));
            TestPortalContainerConfig.assertNull((Object)config.getSetting("myPortal-pcdef", "foo3"));
            TestPortalContainerConfig.assertEquals((Object)"myPortal-dpcdef", (Object)config.getSetting("foo", "name"));
            TestPortalContainerConfig.assertEquals((Object)"myPortal-dpcdef", (Object)config.getSetting("myPortal", "name"));
            TestPortalContainerConfig.assertEquals((Object)"myPortal-pcdef", (Object)config.getSetting("myPortal-pcdef", "name"));
            TestPortalContainerConfig.assertEquals((Object)"myRest-dpcdef", (Object)config.getSetting("foo", "rest"));
            TestPortalContainerConfig.assertEquals((Object)"myRest-dpcdef", (Object)config.getSetting("myPortal", "rest"));
            TestPortalContainerConfig.assertEquals((Object)"myRest-pcdef", (Object)config.getSetting("myPortal-pcdef", "rest"));
            TestPortalContainerConfig.assertEquals((Object)"my-exo-domain-dpcdef", (Object)config.getSetting("foo", "realm"));
            TestPortalContainerConfig.assertEquals((Object)"my-exo-domain-dpcdef", (Object)config.getSetting("myPortal", "realm"));
            TestPortalContainerConfig.assertEquals((Object)"my-exo-domain-pcdef", (Object)config.getSetting("myPortal-pcdef", "realm"));
            TestPortalContainerConfig.assertEquals((Object)"value0", (Object)config.getSetting("foo", "string"));
            TestPortalContainerConfig.assertEquals((Object)new Integer(100), (Object)config.getSetting("foo", "int"));
            TestPortalContainerConfig.assertEquals((Object)new Long(100L), (Object)config.getSetting("foo", "long"));
            TestPortalContainerConfig.assertEquals((Object)new Double(100.0), (Object)config.getSetting("foo", "double"));
            TestPortalContainerConfig.assertEquals((Object)new Boolean(false), (Object)config.getSetting("foo", "boolean"));
            TestPortalContainerConfig.assertEquals((Object)"value0", (Object)config.getSetting("myPortal", "string"));
            TestPortalContainerConfig.assertEquals((Object)new Integer(100), (Object)config.getSetting("myPortal", "int"));
            TestPortalContainerConfig.assertEquals((Object)new Long(100L), (Object)config.getSetting("myPortal", "long"));
            TestPortalContainerConfig.assertEquals((Object)new Double(100.0), (Object)config.getSetting("myPortal", "double"));
            TestPortalContainerConfig.assertEquals((Object)new Boolean(false), (Object)config.getSetting("myPortal", "boolean"));
            TestPortalContainerConfig.assertEquals((Object)"value", (Object)config.getSetting("myPortal-pcdef", "string"));
            TestPortalContainerConfig.assertEquals((Object)new Integer(10), (Object)config.getSetting("myPortal-pcdef", "int"));
            TestPortalContainerConfig.assertEquals((Object)new Long(10L), (Object)config.getSetting("myPortal-pcdef", "long"));
            TestPortalContainerConfig.assertEquals((Object)new Double(10.0), (Object)config.getSetting("myPortal-pcdef", "double"));
            TestPortalContainerConfig.assertEquals((Object)new Boolean(true), (Object)config.getSetting("myPortal-pcdef", "boolean"));
        }
        finally {
            this.clearSystemProperties();
        }
        try {
            rootContainer = this.createRootContainer("portal-container-config-with-default-values-and-with-external-settings.xml");
            config = (PortalContainerConfig)rootContainer.getComponentInstanceOfType(PortalContainerConfig.class);
            TestPortalContainerConfig.assertNull((Object)config.getSetting("foo", "foo"));
            TestPortalContainerConfig.assertNull((Object)config.getSetting("myPortal", "foo"));
            TestPortalContainerConfig.assertNull((Object)config.getSetting("myPortal-pcdef", "foo"));
            TestPortalContainerConfig.assertNull((Object)config.getSetting("foo", "foo2"));
            TestPortalContainerConfig.assertNull((Object)config.getSetting("myPortal", "foo2"));
            TestPortalContainerConfig.assertEquals((Object)"value", (Object)config.getSetting("myPortal-pcdef", "foo2"));
            TestPortalContainerConfig.assertEquals((Object)"new value", (Object)config.getSetting("myPortal-pcdef", "string"));
            TestPortalContainerConfig.assertEquals((Object)"20", (Object)config.getSetting("myPortal-pcdef", "int"));
            TestPortalContainerConfig.assertEquals((Object)"20", (Object)config.getSetting("myPortal-pcdef", "long"));
            TestPortalContainerConfig.assertEquals((Object)"20", (Object)config.getSetting("myPortal-pcdef", "double"));
            TestPortalContainerConfig.assertEquals((Object)"false", (Object)config.getSetting("myPortal-pcdef", "boolean"));
            TestPortalContainerConfig.assertEquals((Object)"myPortal-pcdef-myRest-pcdef-my-exo-domain-pcdef-value-new value", (Object)config.getSetting("myPortal-pcdef", "complex-value"));
            TestPortalContainerConfig.assertEquals((Object)"myPortal", (Object)config.getSetting("foo", "name"));
            TestPortalContainerConfig.assertEquals((Object)"myPortal", (Object)config.getSetting("myPortal", "name"));
            TestPortalContainerConfig.assertEquals((Object)"myPortal-pcdef", (Object)config.getSetting("myPortal-pcdef", "name"));
            TestPortalContainerConfig.assertEquals((Object)"myRest", (Object)config.getSetting("foo", "rest"));
            TestPortalContainerConfig.assertEquals((Object)"myRest", (Object)config.getSetting("myPortal", "rest"));
            TestPortalContainerConfig.assertEquals((Object)"myRest-pcdef", (Object)config.getSetting("myPortal-pcdef", "rest"));
            TestPortalContainerConfig.assertEquals((Object)"my-exo-domain", (Object)config.getSetting("foo", "realm"));
            TestPortalContainerConfig.assertEquals((Object)"my-exo-domain", (Object)config.getSetting("myPortal", "realm"));
            TestPortalContainerConfig.assertEquals((Object)"my-exo-domain-pcdef", (Object)config.getSetting("myPortal-pcdef", "realm"));
        }
        finally {
            this.clearSystemProperties();
        }
        try {
            rootContainer = this.createRootContainer("portal-container-config-with-default-values-and-with-external-settings-with-default-portal-def.xml");
            config = (PortalContainerConfig)rootContainer.getComponentInstanceOfType(PortalContainerConfig.class);
            TestPortalContainerConfig.assertEquals((Object)"value0", (Object)config.getSetting("foo", "foo"));
            TestPortalContainerConfig.assertEquals((Object)"value0", (Object)config.getSetting("myPortal", "foo"));
            TestPortalContainerConfig.assertEquals((Object)"value0", (Object)config.getSetting("myPortal0", "foo"));
            TestPortalContainerConfig.assertEquals((Object)"value0", (Object)config.getSetting("myPortal-pcdef", "foo"));
            TestPortalContainerConfig.assertEquals((Object)"value0", (Object)config.getSetting("myPortal2", "foo"));
            TestPortalContainerConfig.assertNull((Object)config.getSetting("foo", "foo2"));
            TestPortalContainerConfig.assertNull((Object)config.getSetting("myPortal", "foo2"));
            TestPortalContainerConfig.assertNull((Object)config.getSetting("myPortal0", "foo2"));
            TestPortalContainerConfig.assertEquals((Object)"value", (Object)config.getSetting("myPortal-pcdef", "foo2"));
            TestPortalContainerConfig.assertNull((Object)config.getSetting("myPortal2", "foo2"));
            TestPortalContainerConfig.assertEquals((Object)"new value0", (Object)config.getSetting("foo", "string"));
            TestPortalContainerConfig.assertEquals((Object)"200", (Object)config.getSetting("foo", "int"));
            TestPortalContainerConfig.assertEquals((Object)"200", (Object)config.getSetting("foo", "long"));
            TestPortalContainerConfig.assertEquals((Object)"200", (Object)config.getSetting("foo", "double"));
            TestPortalContainerConfig.assertEquals((Object)"true", (Object)config.getSetting("foo", "boolean"));
            TestPortalContainerConfig.assertEquals((Object)"myPortal-myRest-my-exo-domain-value0-new value0", (Object)config.getSetting("foo", "complex-value2"));
            TestPortalContainerConfig.assertEquals((Object)"new value0", (Object)config.getSetting("myPortal", "string"));
            TestPortalContainerConfig.assertEquals((Object)"200", (Object)config.getSetting("myPortal", "int"));
            TestPortalContainerConfig.assertEquals((Object)"200", (Object)config.getSetting("myPortal", "long"));
            TestPortalContainerConfig.assertEquals((Object)"200", (Object)config.getSetting("myPortal", "double"));
            TestPortalContainerConfig.assertEquals((Object)"true", (Object)config.getSetting("myPortal", "boolean"));
            TestPortalContainerConfig.assertEquals((Object)"myPortal-myRest-my-exo-domain-value0-new value0", (Object)config.getSetting("myPortal", "complex-value2"));
            TestPortalContainerConfig.assertEquals((Object)"new value0", (Object)config.getSetting("myPortal0", "string"));
            TestPortalContainerConfig.assertEquals((Object)"200", (Object)config.getSetting("myPortal0", "int"));
            TestPortalContainerConfig.assertEquals((Object)"200", (Object)config.getSetting("myPortal0", "long"));
            TestPortalContainerConfig.assertEquals((Object)"200", (Object)config.getSetting("myPortal0", "double"));
            TestPortalContainerConfig.assertEquals((Object)"true", (Object)config.getSetting("myPortal0", "boolean"));
            TestPortalContainerConfig.assertEquals((Object)"myPortal0-myRest0-my-exo-domain0-value0-new value0", (Object)config.getSetting("myPortal0", "complex-value2"));
            TestPortalContainerConfig.assertEquals((Object)"new value", (Object)config.getSetting("myPortal-pcdef", "string"));
            TestPortalContainerConfig.assertEquals((Object)"20", (Object)config.getSetting("myPortal-pcdef", "int"));
            TestPortalContainerConfig.assertEquals((Object)"20", (Object)config.getSetting("myPortal-pcdef", "long"));
            TestPortalContainerConfig.assertEquals((Object)"20", (Object)config.getSetting("myPortal-pcdef", "double"));
            TestPortalContainerConfig.assertEquals((Object)"false", (Object)config.getSetting("myPortal-pcdef", "boolean"));
            TestPortalContainerConfig.assertEquals((Object)"myPortal-pcdef-myRest-pcdef-my-exo-domain-pcdef-value-new value", (Object)config.getSetting("myPortal-pcdef", "complex-value"));
            TestPortalContainerConfig.assertEquals((Object)"myPortal-pcdef-myRest-pcdef-my-exo-domain-pcdef-value0-new value", (Object)config.getSetting("myPortal-pcdef", "complex-value2"));
            TestPortalContainerConfig.assertEquals((Object)"new value0", (Object)config.getSetting("myPortal2", "string"));
            TestPortalContainerConfig.assertEquals((Object)"200", (Object)config.getSetting("myPortal2", "int"));
            TestPortalContainerConfig.assertEquals((Object)"200", (Object)config.getSetting("myPortal2", "long"));
            TestPortalContainerConfig.assertEquals((Object)"200", (Object)config.getSetting("myPortal2", "double"));
            TestPortalContainerConfig.assertEquals((Object)"true", (Object)config.getSetting("myPortal2", "boolean"));
            TestPortalContainerConfig.assertEquals((Object)"myPortal2-myRest2-my-exo-domain2-value0-new value0", (Object)config.getSetting("myPortal2", "complex-value2"));
            TestPortalContainerConfig.assertEquals((Object)"myPortal", (Object)config.getSetting("foo", "name"));
            TestPortalContainerConfig.assertEquals((Object)"myPortal", (Object)config.getSetting("myPortal", "name"));
            TestPortalContainerConfig.assertEquals((Object)"myPortal-pcdef", (Object)config.getSetting("myPortal-pcdef", "name"));
            TestPortalContainerConfig.assertEquals((Object)"myRest", (Object)config.getSetting("foo", "rest"));
            TestPortalContainerConfig.assertEquals((Object)"myRest", (Object)config.getSetting("myPortal", "rest"));
            TestPortalContainerConfig.assertEquals((Object)"myRest-pcdef", (Object)config.getSetting("myPortal-pcdef", "rest"));
            TestPortalContainerConfig.assertEquals((Object)"my-exo-domain", (Object)config.getSetting("foo", "realm"));
            TestPortalContainerConfig.assertEquals((Object)"my-exo-domain", (Object)config.getSetting("myPortal", "realm"));
            TestPortalContainerConfig.assertEquals((Object)"my-exo-domain-pcdef", (Object)config.getSetting("myPortal-pcdef", "realm"));
        }
        finally {
            this.clearSystemProperties();
        }
        String path = TestPortalContainerConfig.class.getResource("portal-container-config-with-default-values-and-with-external-settings2.xml").getPath();
        path = URLDecoder.decode(path, "UTF-8");
        path = path.substring(0, path.lastIndexOf(47));
        String oldPath = System.getProperty("exo.conf.dir");
        try {
            System.setProperty("exo.conf.dir", path);
            rootContainer = this.createRootContainer("portal-container-config-with-default-values-and-with-external-settings2.xml");
            config = (PortalContainerConfig)rootContainer.getComponentInstanceOfType(PortalContainerConfig.class);
            TestPortalContainerConfig.assertNull((Object)config.getSetting("foo", "foo"));
            TestPortalContainerConfig.assertNull((Object)config.getSetting("myPortal", "foo"));
            TestPortalContainerConfig.assertNull((Object)config.getSetting("myPortal-pcdef", "foo"));
            TestPortalContainerConfig.assertNull((Object)config.getSetting("foo", "foo2"));
            TestPortalContainerConfig.assertNull((Object)config.getSetting("myPortal", "foo2"));
            TestPortalContainerConfig.assertEquals((Object)"value 2", (Object)config.getSetting("myPortal-pcdef", "foo2"));
            TestPortalContainerConfig.assertEquals((Object)"new value 2", (Object)config.getSetting("myPortal-pcdef", "string"));
            TestPortalContainerConfig.assertEquals((Object)"22", (Object)config.getSetting("myPortal-pcdef", "int"));
            TestPortalContainerConfig.assertEquals((Object)"22", (Object)config.getSetting("myPortal-pcdef", "long"));
            TestPortalContainerConfig.assertEquals((Object)"22", (Object)config.getSetting("myPortal-pcdef", "double"));
            TestPortalContainerConfig.assertEquals((Object)"true", (Object)config.getSetting("myPortal-pcdef", "boolean"));
            TestPortalContainerConfig.assertEquals((Object)"myPortal-pcdef-myRest-pcdef-my-exo-domain-pcdef-value 2-new value 2", (Object)config.getSetting("myPortal-pcdef", "complex-value"));
            TestPortalContainerConfig.assertEquals((Object)"myPortal", (Object)config.getSetting("foo", "name"));
            TestPortalContainerConfig.assertEquals((Object)"myPortal", (Object)config.getSetting("myPortal", "name"));
            TestPortalContainerConfig.assertEquals((Object)"myPortal-pcdef", (Object)config.getSetting("myPortal-pcdef", "name"));
            TestPortalContainerConfig.assertEquals((Object)"myRest", (Object)config.getSetting("foo", "rest"));
            TestPortalContainerConfig.assertEquals((Object)"myRest", (Object)config.getSetting("myPortal", "rest"));
            TestPortalContainerConfig.assertEquals((Object)"myRest-pcdef", (Object)config.getSetting("myPortal-pcdef", "rest"));
            TestPortalContainerConfig.assertEquals((Object)"my-exo-domain", (Object)config.getSetting("foo", "realm"));
            TestPortalContainerConfig.assertEquals((Object)"my-exo-domain", (Object)config.getSetting("myPortal", "realm"));
            TestPortalContainerConfig.assertEquals((Object)"my-exo-domain-pcdef", (Object)config.getSetting("myPortal-pcdef", "realm"));
            rootContainer = this.createRootContainer("portal-container-config-with-default-values-and-with-external-settings-with-default-portal-def2.xml");
            config = (PortalContainerConfig)rootContainer.getComponentInstanceOfType(PortalContainerConfig.class);
            TestPortalContainerConfig.assertEquals((Object)"value01", (Object)config.getSetting("foo", "foo"));
            TestPortalContainerConfig.assertEquals((Object)"value01", (Object)config.getSetting("myPortal", "foo"));
            TestPortalContainerConfig.assertEquals((Object)"value01", (Object)config.getSetting("myPortal0", "foo"));
            TestPortalContainerConfig.assertEquals((Object)"value01", (Object)config.getSetting("myPortal-pcdef", "foo"));
            TestPortalContainerConfig.assertEquals((Object)"value01", (Object)config.getSetting("myPortal2", "foo"));
            TestPortalContainerConfig.assertNull((Object)config.getSetting("foo", "foo2"));
            TestPortalContainerConfig.assertNull((Object)config.getSetting("myPortal", "foo2"));
            TestPortalContainerConfig.assertNull((Object)config.getSetting("myPortal0", "foo2"));
            TestPortalContainerConfig.assertEquals((Object)"value 2", (Object)config.getSetting("myPortal-pcdef", "foo2"));
            TestPortalContainerConfig.assertNull((Object)config.getSetting("myPortal2", "foo2"));
            TestPortalContainerConfig.assertEquals((Object)"new value01", (Object)config.getSetting("foo", "string"));
            TestPortalContainerConfig.assertEquals((Object)"2001", (Object)config.getSetting("foo", "int"));
            TestPortalContainerConfig.assertEquals((Object)"2001", (Object)config.getSetting("foo", "long"));
            TestPortalContainerConfig.assertEquals((Object)"2001", (Object)config.getSetting("foo", "double"));
            TestPortalContainerConfig.assertEquals((Object)"false", (Object)config.getSetting("foo", "boolean"));
            TestPortalContainerConfig.assertEquals((Object)"myPortal-myRest-my-exo-domain-value01-new value01", (Object)config.getSetting("foo", "complex-value2"));
            TestPortalContainerConfig.assertEquals((Object)"new value01", (Object)config.getSetting("myPortal", "string"));
            TestPortalContainerConfig.assertEquals((Object)"2001", (Object)config.getSetting("myPortal", "int"));
            TestPortalContainerConfig.assertEquals((Object)"2001", (Object)config.getSetting("myPortal", "long"));
            TestPortalContainerConfig.assertEquals((Object)"2001", (Object)config.getSetting("myPortal", "double"));
            TestPortalContainerConfig.assertEquals((Object)"false", (Object)config.getSetting("myPortal", "boolean"));
            TestPortalContainerConfig.assertEquals((Object)"myPortal-myRest-my-exo-domain-value01-new value01", (Object)config.getSetting("myPortal", "complex-value2"));
            TestPortalContainerConfig.assertEquals((Object)"new value01", (Object)config.getSetting("myPortal0", "string"));
            TestPortalContainerConfig.assertEquals((Object)"2001", (Object)config.getSetting("myPortal0", "int"));
            TestPortalContainerConfig.assertEquals((Object)"2001", (Object)config.getSetting("myPortal0", "long"));
            TestPortalContainerConfig.assertEquals((Object)"2001", (Object)config.getSetting("myPortal0", "double"));
            TestPortalContainerConfig.assertEquals((Object)"false", (Object)config.getSetting("myPortal0", "boolean"));
            TestPortalContainerConfig.assertEquals((Object)"myPortal0-myRest0-my-exo-domain0-value01-new value01", (Object)config.getSetting("myPortal0", "complex-value2"));
            TestPortalContainerConfig.assertEquals((Object)"new value 2", (Object)config.getSetting("myPortal-pcdef", "string"));
            TestPortalContainerConfig.assertEquals((Object)"22", (Object)config.getSetting("myPortal-pcdef", "int"));
            TestPortalContainerConfig.assertEquals((Object)"22", (Object)config.getSetting("myPortal-pcdef", "long"));
            TestPortalContainerConfig.assertEquals((Object)"22", (Object)config.getSetting("myPortal-pcdef", "double"));
            TestPortalContainerConfig.assertEquals((Object)"true", (Object)config.getSetting("myPortal-pcdef", "boolean"));
            TestPortalContainerConfig.assertEquals((Object)"myPortal-pcdef-myRest-pcdef-my-exo-domain-pcdef-value 2-new value 2", (Object)config.getSetting("myPortal-pcdef", "complex-value"));
            TestPortalContainerConfig.assertEquals((Object)"myPortal-pcdef-myRest-pcdef-my-exo-domain-pcdef-value01-new value 2", (Object)config.getSetting("myPortal-pcdef", "complex-value2"));
            TestPortalContainerConfig.assertEquals((Object)"new value01", (Object)config.getSetting("myPortal2", "string"));
            TestPortalContainerConfig.assertEquals((Object)"2001", (Object)config.getSetting("myPortal2", "int"));
            TestPortalContainerConfig.assertEquals((Object)"2001", (Object)config.getSetting("myPortal2", "long"));
            TestPortalContainerConfig.assertEquals((Object)"2001", (Object)config.getSetting("myPortal2", "double"));
            TestPortalContainerConfig.assertEquals((Object)"false", (Object)config.getSetting("myPortal2", "boolean"));
            TestPortalContainerConfig.assertEquals((Object)"myPortal2-myRest2-my-exo-domain2-value01-new value01", (Object)config.getSetting("myPortal2", "complex-value2"));
            TestPortalContainerConfig.assertEquals((Object)"myPortal", (Object)config.getSetting("foo", "name"));
            TestPortalContainerConfig.assertEquals((Object)"myPortal", (Object)config.getSetting("myPortal", "name"));
            TestPortalContainerConfig.assertEquals((Object)"myPortal-pcdef", (Object)config.getSetting("myPortal-pcdef", "name"));
            TestPortalContainerConfig.assertEquals((Object)"myRest", (Object)config.getSetting("foo", "rest"));
            TestPortalContainerConfig.assertEquals((Object)"myRest", (Object)config.getSetting("myPortal", "rest"));
            TestPortalContainerConfig.assertEquals((Object)"myRest-pcdef", (Object)config.getSetting("myPortal-pcdef", "rest"));
            TestPortalContainerConfig.assertEquals((Object)"my-exo-domain", (Object)config.getSetting("foo", "realm"));
            TestPortalContainerConfig.assertEquals((Object)"my-exo-domain", (Object)config.getSetting("myPortal", "realm"));
            TestPortalContainerConfig.assertEquals((Object)"my-exo-domain-pcdef", (Object)config.getSetting("myPortal-pcdef", "realm"));
        }
        finally {
            if (oldPath == null) {
                System.getProperties().remove("exo.conf.dir");
            } else {
                System.setProperty("exo.conf.dir", oldPath);
            }
        }
        rootContainer = this.createRootContainer("portal-container-config-with-default-values-and-with-both-settings.xml");
        config = (PortalContainerConfig)rootContainer.getComponentInstanceOfType(PortalContainerConfig.class);
        TestPortalContainerConfig.assertNull((Object)config.getSetting("foo", "foo"));
        TestPortalContainerConfig.assertNull((Object)config.getSetting("myPortal", "foo"));
        TestPortalContainerConfig.assertEquals((Object)"value", (Object)config.getSetting("myPortal-pcdef", "foo"));
        TestPortalContainerConfig.assertNull((Object)config.getSetting("foo", "foo2"));
        TestPortalContainerConfig.assertNull((Object)config.getSetting("myPortal", "foo2"));
        TestPortalContainerConfig.assertEquals((Object)"value", (Object)config.getSetting("myPortal-pcdef", "foo2"));
        TestPortalContainerConfig.assertEquals((Object)"new value", (Object)config.getSetting("myPortal-pcdef", "string"));
        TestPortalContainerConfig.assertEquals((Object)new Integer(20), (Object)config.getSetting("myPortal-pcdef", "int"));
        TestPortalContainerConfig.assertEquals((Object)new Long(20L), (Object)config.getSetting("myPortal-pcdef", "long"));
        TestPortalContainerConfig.assertEquals((Object)new Double(20.0), (Object)config.getSetting("myPortal-pcdef", "double"));
        TestPortalContainerConfig.assertEquals((Object)new Boolean(false), (Object)config.getSetting("myPortal-pcdef", "boolean"));
        TestPortalContainerConfig.assertEquals((Object)"myPortal", (Object)config.getSetting("foo", "name"));
        TestPortalContainerConfig.assertEquals((Object)"myPortal", (Object)config.getSetting("myPortal", "name"));
        TestPortalContainerConfig.assertEquals((Object)"myPortal-pcdef", (Object)config.getSetting("myPortal-pcdef", "name"));
        TestPortalContainerConfig.assertEquals((Object)"myRest", (Object)config.getSetting("foo", "rest"));
        TestPortalContainerConfig.assertEquals((Object)"myRest", (Object)config.getSetting("myPortal", "rest"));
        TestPortalContainerConfig.assertEquals((Object)"myRest-pcdef", (Object)config.getSetting("myPortal-pcdef", "rest"));
        TestPortalContainerConfig.assertEquals((Object)"my-exo-domain", (Object)config.getSetting("foo", "realm"));
        TestPortalContainerConfig.assertEquals((Object)"my-exo-domain", (Object)config.getSetting("myPortal", "realm"));
        TestPortalContainerConfig.assertEquals((Object)"my-exo-domain-pcdef", (Object)config.getSetting("myPortal-pcdef", "realm"));
        try {
            System.setProperty("TestPortalContainerConfig-string", "system value");
            System.setProperty("TestPortalContainerConfig-int", "50");
            rootContainer = this.createRootContainer("portal-container-config-with-default-values-and-with-both-settings-with-default-portal-def.xml");
            config = (PortalContainerConfig)rootContainer.getComponentInstanceOfType(PortalContainerConfig.class);
            TestPortalContainerConfig.assertEquals((Object)"value0", (Object)config.getSetting("foo", "foo"));
            TestPortalContainerConfig.assertEquals((Object)"value0", (Object)config.getSetting("myPortal", "foo"));
            TestPortalContainerConfig.assertEquals((Object)"value0", (Object)config.getSetting("myPortal-pcdef", "foo"));
            TestPortalContainerConfig.assertEquals((Object)"value", (Object)config.getSetting("foo", "foo2"));
            TestPortalContainerConfig.assertEquals((Object)"value", (Object)config.getSetting("myPortal", "foo2"));
            TestPortalContainerConfig.assertEquals((Object)"value", (Object)config.getSetting("myPortal-pcdef", "foo2"));
            TestPortalContainerConfig.assertNull((Object)config.getSetting("foo", "foo3"));
            TestPortalContainerConfig.assertNull((Object)config.getSetting("myPortal", "foo3"));
            TestPortalContainerConfig.assertEquals((Object)"value", (Object)config.getSetting("myPortal-pcdef", "foo3"));
            TestPortalContainerConfig.assertEquals((Object)"-${foo3}-", (Object)config.getSetting("foo", "complex-value3"));
            TestPortalContainerConfig.assertEquals((Object)"-${foo3}-", (Object)config.getSetting("myPortal", "complex-value3"));
            TestPortalContainerConfig.assertEquals((Object)"-value-", (Object)config.getSetting("myPortal-pcdef", "complex-value3"));
            TestPortalContainerConfig.assertNull((Object)config.getSetting("foo", "complex-value4"));
            TestPortalContainerConfig.assertNull((Object)config.getSetting("myPortal", "complex-value4"));
            TestPortalContainerConfig.assertEquals((Object)"-value-", (Object)config.getSetting("myPortal-pcdef", "complex-value4"));
            TestPortalContainerConfig.assertEquals((Object)"-value-", (Object)config.getSetting("foo", "complex-value5"));
            TestPortalContainerConfig.assertEquals((Object)"-value-", (Object)config.getSetting("myPortal", "complex-value5"));
            TestPortalContainerConfig.assertEquals((Object)"-value-", (Object)config.getSetting("myPortal-pcdef", "complex-value5"));
            TestPortalContainerConfig.assertNull((Object)config.getSetting("foo", "complex-value6"));
            TestPortalContainerConfig.assertNull((Object)config.getSetting("myPortal", "complex-value6"));
            TestPortalContainerConfig.assertEquals((Object)"-value-", (Object)config.getSetting("myPortal-pcdef", "complex-value6"));
            TestPortalContainerConfig.assertNull((Object)config.getSetting("foo", "complex-value7"));
            TestPortalContainerConfig.assertNull((Object)config.getSetting("myPortal", "complex-value7"));
            TestPortalContainerConfig.assertEquals((Object)"-value-", (Object)config.getSetting("myPortal-pcdef", "complex-value7"));
            TestPortalContainerConfig.assertEquals((Object)"-${foo6}-", (Object)config.getSetting("foo", "complex-value8"));
            TestPortalContainerConfig.assertEquals((Object)"-${foo6}-", (Object)config.getSetting("myPortal", "complex-value8"));
            TestPortalContainerConfig.assertEquals((Object)"-value-", (Object)config.getSetting("myPortal-pcdef", "complex-value8"));
            TestPortalContainerConfig.assertEquals((Object)"-property_value_1-", (Object)config.getSetting("foo", "complex-value9"));
            TestPortalContainerConfig.assertEquals((Object)"-property_value_1-", (Object)config.getSetting("myPortal", "complex-value9"));
            TestPortalContainerConfig.assertEquals((Object)"-property_value_1-", (Object)config.getSetting("myPortal-pcdef", "complex-value9"));
            TestPortalContainerConfig.assertNull((Object)config.getSetting("foo", "complex-value10"));
            TestPortalContainerConfig.assertNull((Object)config.getSetting("myPortal", "complex-value10"));
            TestPortalContainerConfig.assertEquals((Object)"--value--", (Object)config.getSetting("myPortal-pcdef", "complex-value10"));
            TestPortalContainerConfig.assertNull((Object)config.getSetting("foo", "complex-value11"));
            TestPortalContainerConfig.assertNull((Object)config.getSetting("myPortal", "complex-value11"));
            TestPortalContainerConfig.assertEquals((Object)"-default-", (Object)config.getSetting("myPortal-pcdef", "complex-value11"));
            TestPortalContainerConfig.assertEquals((Object)"-default-", (Object)config.getSetting("foo", "complex-value12"));
            TestPortalContainerConfig.assertEquals((Object)"-default-", (Object)config.getSetting("myPortal", "complex-value12"));
            TestPortalContainerConfig.assertEquals((Object)"-value-", (Object)config.getSetting("myPortal-pcdef", "complex-value12"));
            TestPortalContainerConfig.assertEquals((Object)"-property_value_1-", (Object)config.getSetting("foo", "complex-value13"));
            TestPortalContainerConfig.assertEquals((Object)"-property_value_1-", (Object)config.getSetting("myPortal", "complex-value13"));
            TestPortalContainerConfig.assertEquals((Object)"-property_value_1-", (Object)config.getSetting("myPortal-pcdef", "complex-value13"));
            TestPortalContainerConfig.assertEquals((Object)"-default-", (Object)config.getSetting("foo", "complex-value14"));
            TestPortalContainerConfig.assertEquals((Object)"-default-", (Object)config.getSetting("myPortal", "complex-value14"));
            TestPortalContainerConfig.assertEquals((Object)"-default-", (Object)config.getSetting("myPortal-pcdef", "complex-value14"));
            TestPortalContainerConfig.assertEquals((Object)"-system value-", (Object)config.getSetting("foo", "cpv1"));
            TestPortalContainerConfig.assertEquals((Object)"-system value-", (Object)config.getSetting("myPortal", "cpv1"));
            TestPortalContainerConfig.assertEquals((Object)"-system value-", (Object)config.getSetting("myPortal-pcdef", "cpv1"));
            TestPortalContainerConfig.assertEquals((Object)new Integer(50), (Object)config.getSetting("foo", "cpv2"));
            TestPortalContainerConfig.assertEquals((Object)new Integer(50), (Object)config.getSetting("myPortal", "cpv2"));
            TestPortalContainerConfig.assertEquals((Object)new Integer(50), (Object)config.getSetting("myPortal-pcdef", "cpv2"));
            TestPortalContainerConfig.assertEquals((Object)"-property_value_1-", (Object)config.getSetting("foo", "cpv3"));
            TestPortalContainerConfig.assertEquals((Object)"-property_value_1-", (Object)config.getSetting("myPortal", "cpv3"));
            TestPortalContainerConfig.assertEquals((Object)"-property_value_1-", (Object)config.getSetting("myPortal-pcdef", "cpv3"));
            TestPortalContainerConfig.assertEquals((Object)"-value-", (Object)config.getSetting("foo", "cpv4"));
            TestPortalContainerConfig.assertEquals((Object)"-value-", (Object)config.getSetting("myPortal", "cpv4"));
            TestPortalContainerConfig.assertEquals((Object)"-value-", (Object)config.getSetting("myPortal-pcdef", "cpv4"));
            TestPortalContainerConfig.assertEquals((Object)"-system value-", (Object)config.getSetting("foo", "cpv5"));
            TestPortalContainerConfig.assertEquals((Object)"-system value-", (Object)config.getSetting("myPortal", "cpv5"));
            TestPortalContainerConfig.assertEquals((Object)"-system value-", (Object)config.getSetting("myPortal-pcdef", "cpv5"));
            TestPortalContainerConfig.assertEquals((Object)"new value0", (Object)config.getSetting("foo", "string"));
            TestPortalContainerConfig.assertEquals((Object)new Integer(200), (Object)config.getSetting("foo", "int"));
            TestPortalContainerConfig.assertEquals((Object)new Integer(60), (Object)config.getSetting("foo", "int2"));
            TestPortalContainerConfig.assertEquals((Object)new Long(200L), (Object)config.getSetting("foo", "long"));
            TestPortalContainerConfig.assertEquals((Object)new Double(200.0), (Object)config.getSetting("foo", "double"));
            TestPortalContainerConfig.assertEquals((Object)new Boolean(true), (Object)config.getSetting("foo", "boolean"));
            TestPortalContainerConfig.assertEquals((Object)"new value0", (Object)config.getSetting("myPortal", "string"));
            TestPortalContainerConfig.assertEquals((Object)new Integer(200), (Object)config.getSetting("myPortal", "int"));
            TestPortalContainerConfig.assertEquals((Object)new Integer(60), (Object)config.getSetting("myPortal", "int2"));
            TestPortalContainerConfig.assertEquals((Object)new Long(200L), (Object)config.getSetting("myPortal", "long"));
            TestPortalContainerConfig.assertEquals((Object)new Double(200.0), (Object)config.getSetting("myPortal", "double"));
            TestPortalContainerConfig.assertEquals((Object)new Boolean(true), (Object)config.getSetting("myPortal", "boolean"));
            TestPortalContainerConfig.assertEquals((Object)"new value", (Object)config.getSetting("myPortal-pcdef", "string"));
            TestPortalContainerConfig.assertEquals((Object)new Integer(20), (Object)config.getSetting("myPortal-pcdef", "int"));
            TestPortalContainerConfig.assertEquals((Object)new Integer(60), (Object)config.getSetting("myPortal-pcdef", "int2"));
            TestPortalContainerConfig.assertEquals((Object)new Long(20L), (Object)config.getSetting("myPortal-pcdef", "long"));
            TestPortalContainerConfig.assertEquals((Object)new Double(20.0), (Object)config.getSetting("myPortal-pcdef", "double"));
            TestPortalContainerConfig.assertEquals((Object)new Boolean(false), (Object)config.getSetting("myPortal-pcdef", "boolean"));
            TestPortalContainerConfig.assertEquals((Object)"myPortal", (Object)config.getSetting("foo", "name"));
            TestPortalContainerConfig.assertEquals((Object)"myPortal", (Object)config.getSetting("myPortal", "name"));
            TestPortalContainerConfig.assertEquals((Object)"myPortal-pcdef", (Object)config.getSetting("myPortal-pcdef", "name"));
            TestPortalContainerConfig.assertEquals((Object)"myRest", (Object)config.getSetting("foo", "rest"));
            TestPortalContainerConfig.assertEquals((Object)"myRest", (Object)config.getSetting("myPortal", "rest"));
            TestPortalContainerConfig.assertEquals((Object)"myRest-pcdef", (Object)config.getSetting("myPortal-pcdef", "rest"));
            TestPortalContainerConfig.assertEquals((Object)"my-exo-domain", (Object)config.getSetting("foo", "realm"));
            TestPortalContainerConfig.assertEquals((Object)"my-exo-domain", (Object)config.getSetting("myPortal", "realm"));
            TestPortalContainerConfig.assertEquals((Object)"my-exo-domain-pcdef", (Object)config.getSetting("myPortal-pcdef", "realm"));
        }
        finally {
            System.getProperties().remove("TestPortalContainerConfig-string");
            System.getProperties().remove("TestPortalContainerConfig-int");
            this.clearSystemProperties();
        }
        try {
            rootContainer = this.createRootContainer("portal-container-config-with-invalid-values.xml");
            config = (PortalContainerConfig)rootContainer.getComponentInstanceOfType(PortalContainerConfig.class);
            TestPortalContainerConfig.assertEquals((Object)"value", (Object)config.getSetting("myPortal-pcdef", "internal-empty-value"));
            TestPortalContainerConfig.assertEquals((Object)"", (Object)config.getSetting("myPortal-pcdef", "external-empty-value"));
            TestPortalContainerConfig.assertEquals((Object)"", (Object)config.getSetting("myPortal-pcdef", "fake-value-4-string"));
            TestPortalContainerConfig.assertEquals((Object)new Integer(10), (Object)config.getSetting("myPortal-pcdef", "fake-value-4-int"));
            TestPortalContainerConfig.assertEquals((Object)new Integer(10), (Object)config.getSetting("myPortal-pcdef", "invalid-value-4-int"));
            TestPortalContainerConfig.assertEquals((Object)"myPortal", (Object)config.getSetting("foo", "name"));
            TestPortalContainerConfig.assertEquals((Object)"myPortal", (Object)config.getSetting("myPortal", "name"));
            TestPortalContainerConfig.assertEquals((Object)"myPortal-pcdef", (Object)config.getSetting("myPortal-pcdef", "name"));
            TestPortalContainerConfig.assertEquals((Object)"myRest", (Object)config.getSetting("foo", "rest"));
            TestPortalContainerConfig.assertEquals((Object)"myRest", (Object)config.getSetting("myPortal", "rest"));
            TestPortalContainerConfig.assertEquals((Object)"myRest", (Object)config.getSetting("myPortal-pcdef", "rest"));
            TestPortalContainerConfig.assertEquals((Object)"my-exo-domain", (Object)config.getSetting("foo", "realm"));
            TestPortalContainerConfig.assertEquals((Object)"my-exo-domain", (Object)config.getSetting("myPortal", "realm"));
            TestPortalContainerConfig.assertEquals((Object)"my-exo-domain", (Object)config.getSetting("myPortal-pcdef", "realm"));
        }
        finally {
            System.getProperties().remove("TestPortalContainerConfig-string");
            System.getProperties().remove("TestPortalContainerConfig-int");
            this.clearSystemProperties();
        }
    }

    public void testSimpleSetting() {
        try {
            RootContainer rootContainer = this.createRootContainer("empty-config.xml");
            PortalContainerConfig config = (PortalContainerConfig)rootContainer.getComponentInstanceOfType(PortalContainerConfig.class);
            TestPortalContainerConfig.assertNull((Object)config);
            rootContainer = this.createRootContainer("sample-gtn-configuration.xml");
            config = (PortalContainerConfig)rootContainer.getComponentInstanceOfType(PortalContainerConfig.class);
            TestPortalContainerConfig.assertEquals((Object)"../gatein/data", (Object)config.getSetting("portal", "gatein.data.dir"));
            TestPortalContainerConfig.assertEquals((Object)"../gatein/data/db", (Object)config.getSetting("portal", "gatein.db.data.dir"));
            TestPortalContainerConfig.assertEquals((Object)"jdbc:hsqldb:file:../gatein/data/db/data/jdbcjcr_portal", (Object)config.getSetting("portal", "gatein.jcr.datasource.url"));
        }
        finally {
            this.clearSystemProperties();
        }
    }

    private void clearSystemProperties() {
        System.getProperties().remove("_default.portal.container");
        System.getProperties().remove("_default.rest.context");
        System.getProperties().remove("_default.realm.name");
        System.getProperties().remove("_portal.container");
        System.getProperties().remove("_rest.context");
        System.getProperties().remove("_realm.name");
        PropertyManager.refresh();
    }

    public static class TestPortalContainerDefinitionChange
    implements PortalContainerDefinitionChange {
        public String name;
        public static Map<String, Set<String>> NAMES = new HashMap<String, Set<String>>();

        public void apply(PortalContainerDefinition pcd) {
            Set<String> names = NAMES.get(this.name);
            if (names == null) {
                names = new HashSet<String>();
                NAMES.put(this.name, names);
            }
            names.add(pcd.getName());
        }
    }
}

