/**
 * This file is part of the Meeds project (https://meeds.io/).
 *
 * Copyright (C) 2020 - 2025 Meeds Association contact@meeds.io
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */
package org.exoplatform.services.log.impl;

import org.exoplatform.services.log.AbstractLogConfigurator;

import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

/**
 * Created by The eXo Platform SAS. <br> Simple commons configurator. See
 * org.apache.commons.logging.impl.SimpleLog javadoc for details.
 * 
 */
public class SimpleExoLogConfigurator extends AbstractLogConfigurator
{

   public void configure(Properties properties)
   {

      // it is ok in AS env, but maven test throws something not understandable
      // System.setProperties(properties);

      for (Iterator it = properties.entrySet().iterator(); it.hasNext();)
      {
         Map.Entry entry = (Map.Entry)it.next();
         System.setProperty((String)entry.getKey(), (String)entry.getValue());
      }

      this.properties = properties;
   }
}
