/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.kudos.service;

import io.meeds.kudos.model.AccountSettings;
import io.meeds.kudos.model.GlobalSettings;
import io.meeds.kudos.model.Kudos;
import io.meeds.kudos.model.KudosEntityType;
import io.meeds.kudos.model.KudosPeriod;
import io.meeds.kudos.model.KudosPeriodType;
import io.meeds.kudos.model.exception.KudosAlreadyLinkedException;
import io.meeds.kudos.service.utils.Utils;
import io.meeds.kudos.storage.KudosStorage;
import jakarta.annotation.PostConstruct;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rpc.RPCService;
import org.exoplatform.services.rpc.RemoteCommand;
import org.exoplatform.services.security.Identity;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class KudosService {
    private static final Log LOG = ExoLogger.getLogger(KudosService.class);
    private static final String CLUSTER_GLOBAL_SETTINGS_UPDATED = "KudosService-GlobalSettings-Updated";
    private static final String CLUSTER_NODE_ID = UUID.randomUUID().toString();
    @Autowired
    private ActivityManager activityManager;
    @Autowired
    private IdentityManager identityManager;
    @Autowired
    private ListenerService listenerService;
    @Autowired
    private KudosStorage kudosStorage;
    @Autowired
    private SpaceService spaceService;
    @Autowired
    private SettingService settingService;
    @Autowired(required=false)
    private RPCService rpcService;
    private GlobalSettings globalSettings;
    @Value(value="${kudos.defaultAccessPermission:}")
    private String defaultAccessPermission;
    @Value(value="${kudos.defaultKudosPerPeriod:3}")
    private long defaultKudosPerPeriod;
    private RemoteCommand reloadSettingsCommand;

    @PostConstruct
    public void init() {
        GlobalSettings loadedGlobalSettings = this.loadGlobalSettings();
        if (loadedGlobalSettings == null) {
            this.globalSettings = new GlobalSettings();
            this.globalSettings.setKudosPerPeriod(this.defaultKudosPerPeriod);
        } else {
            this.globalSettings = loadedGlobalSettings;
        }
        this.installClusterListener();
    }

    public GlobalSettings getGlobalSettings() {
        if (this.globalSettings == null) {
            this.globalSettings = this.loadGlobalSettings();
        }
        return this.globalSettings;
    }

    public void saveGlobalSettings(GlobalSettings settings) {
        this.settingService.set(Utils.KUDOS_CONTEXT, Utils.KUDOS_SCOPE, "ADDONS_KUDOS_SETTINGS", SettingValue.create((String)settings.toStringToPersist()));
        this.globalSettings = null;
        this.clearCacheClusterWide();
    }

    public AccountSettings getAccountSettings(String username) {
        AccountSettings accountSettings = new AccountSettings();
        org.exoplatform.social.core.identity.model.Identity senderIdentity = (org.exoplatform.social.core.identity.model.Identity)this.checkStatusAndGetReceiver("organization", username);
        long senderIdentityId = Long.parseLong(senderIdentity.getId());
        long sentKudos = this.kudosStorage.countKudosByPeriodAndSender(this.getCurrentKudosPeriod(), senderIdentityId);
        accountSettings.setRemainingKudos(this.getAllowedKudosPerPeriod() - sentKudos);
        return accountSettings;
    }

    public Kudos createKudos(Kudos kudos, String currentUser) throws IllegalAccessException {
        org.exoplatform.social.core.identity.model.Identity senderIdentity;
        long senderIdentityId;
        KudosPeriod currentPeriod;
        if (!StringUtils.equals((CharSequence)currentUser, (CharSequence)kudos.getSenderId())) {
            throw new IllegalAccessException("User with id '" + currentUser + "' is not authorized to send kudos on behalf of " + kudos.getSenderId());
        }
        if (StringUtils.equals((CharSequence)currentUser, (CharSequence)kudos.getReceiverId())) {
            throw new IllegalAccessException("User with username '" + currentUser + "' is not authorized to send kudos to himseld!");
        }
        if (StringUtils.isNotBlank((CharSequence)kudos.getSpacePrettyName())) {
            Space space = Utils.getSpace(kudos.getSpacePrettyName());
            if (space == null) {
                throw new ObjectNotFoundException("Space not found");
            }
            if (!this.canSendKudosInSpace(kudos, space, currentUser)) {
                throw new IllegalAccessException("User cannot redact on space");
            }
        }
        if (this.kudosStorage.countKudosByPeriodAndSender(currentPeriod = this.getCurrentKudosPeriod(), senderIdentityId = Long.parseLong((senderIdentity = (org.exoplatform.social.core.identity.model.Identity)this.checkStatusAndGetReceiver("organization", currentUser)).getId())) >= this.getAllowedKudosPerPeriod()) {
            throw new IllegalAccessException("User having username'" + currentUser + "' is not authorized to send more kudos");
        }
        if (kudos.getSenderIdentityId() == null) {
            kudos.setSenderIdentityId(senderIdentity.getId());
        }
        Object receiverObject = this.checkStatusAndGetReceiver(kudos.getReceiverType(), kudos.getReceiverId());
        if (kudos.getReceiverIdentityId() == null) {
            if (receiverObject instanceof org.exoplatform.social.core.identity.model.Identity) {
                org.exoplatform.social.core.identity.model.Identity identity = (org.exoplatform.social.core.identity.model.Identity)receiverObject;
                kudos.setReceiverIdentityId(identity.getId());
            } else if (receiverObject instanceof Space) {
                Space space = (Space)receiverObject;
                if (this.canSendKudosInSpace(kudos, space, currentUser)) {
                    kudos.setReceiverIdentityId(space.getId());
                } else {
                    throw new IllegalAccessException("User cannot redact on space");
                }
            }
        }
        kudos.setTimeInSeconds(Utils.timeToSeconds(LocalDateTime.now()));
        Kudos createdKudos = this.kudosStorage.createKudos(kudos);
        createdKudos.setSpacePrettyName(kudos.getSpacePrettyName());
        this.listenerService.broadcast("exo.kudos.sent", (Object)this, (Object)createdKudos);
        return this.kudosStorage.getKudoById(createdKudos.getTechnicalId());
    }

    public boolean canSendKudosInSpace(Kudos kudos, Space space, String username) {
        return this.isActivityComment(kudos) && this.spaceService.canViewSpace(space, username) || this.spaceService.canRedactOnSpace(space, username);
    }

    public void deleteKudosById(long kudosId, String username) throws IllegalAccessException, ObjectNotFoundException, KudosAlreadyLinkedException {
        if (username == null) {
            throw new IllegalArgumentException("Username is mandatory");
        }
        if (kudosId <= 0L) {
            throw new IllegalArgumentException("Kudos id has to be positive integer");
        }
        Kudos kudos = this.kudosStorage.getKudoById(kudosId);
        if (kudos == null) {
            throw new ObjectNotFoundException("Kudos with id " + kudosId + " wasn't found");
        }
        if (!kudos.getSenderId().equals(username)) {
            throw new IllegalAccessException("user " + username + " is not allowed to delete kudos with id " + kudosId);
        }
        long kudosOfActivityCount = this.kudosStorage.countKudosOfActivity(kudos.getActivityId());
        if (kudosOfActivityCount > 1L) {
            throw new KudosAlreadyLinkedException("kudos with id " + kudosId + "already linked to kudos entities");
        }
        this.deleteKudosById(kudosId);
        this.listenerService.broadcast("kudos.cancel.activity", (Object)this, (Object)kudos);
    }

    public void deleteKudosById(long kudosId) throws ObjectNotFoundException {
        if (kudosId <= 0L) {
            throw new IllegalArgumentException("Kudos id has to be positive integer");
        }
        Kudos kudos = this.kudosStorage.getKudoById(kudosId);
        if (kudos == null) {
            throw new ObjectNotFoundException("Kudos with id " + kudosId + " wasn't found");
        }
        this.kudosStorage.deleteKudosById(kudosId);
    }

    public boolean isActivityComment(Kudos kudos) {
        return KudosEntityType.valueOf(kudos.getEntityType()) == KudosEntityType.ACTIVITY || KudosEntityType.valueOf(kudos.getEntityType()) == KudosEntityType.COMMENT;
    }

    public void updateKudosGeneratedActivityId(long kudosId, long activityId) {
        this.kudosStorage.saveKudosActivityId(kudosId, activityId);
        Kudos kudos = this.kudosStorage.getKudoById(kudosId);
        this.listenerService.broadcast("exo.kudos.activity", (Object)this, (Object)kudos);
    }

    public Kudos getKudosByActivityId(Long activityId, Identity currentUser) throws IllegalAccessException {
        Kudos kudos = this.kudosStorage.getKudosByActivityId(activityId);
        if (kudos == null) {
            return null;
        }
        if (StringUtils.equals((CharSequence)kudos.getSenderId(), (CharSequence)currentUser.getUserId()) || StringUtils.equals((CharSequence)kudos.getReceiverId(), (CharSequence)currentUser.getUserId())) {
            return kudos;
        }
        ExoSocialActivity activity = this.activityManager.getActivity(String.valueOf(activityId));
        if (activity == null) {
            return null;
        }
        if (!this.activityManager.isActivityViewable(activity, currentUser)) {
            throw new IllegalAccessException("User " + currentUser.getUserId() + " isn't allowed to access kudos of activity with id " + activityId);
        }
        return kudos;
    }

    public Kudos getKudosByActivityId(Long activityId) {
        return this.kudosStorage.getKudosByActivityId(activityId);
    }

    public Kudos updateKudos(Kudos kudos) {
        return this.kudosStorage.updateKudos(kudos);
    }

    public List<Kudos> getKudosByPeriod(long startDateInSeconds, long endDateInSeconds, int limit) {
        KudosPeriod period = new KudosPeriod(startDateInSeconds, endDateInSeconds);
        return this.kudosStorage.getKudosByPeriod(period, limit);
    }

    public List<Kudos> getKudosByPeriod(long dateInSeconds, KudosPeriodType periodType, int limit) {
        if (periodType == null) {
            throw new IllegalArgumentException("'periodType' is mandatory");
        }
        KudosPeriod period = periodType.getPeriodOfTime(Utils.timeFromSeconds(dateInSeconds));
        return this.kudosStorage.getKudosByPeriod(period, limit);
    }

    public List<Kudos> getKudosByPeriodOfDate(long dateInSeconds, int limit) {
        KudosPeriod period = this.getKudosPeriodOfTime(dateInSeconds);
        return this.kudosStorage.getKudosByPeriod(period, limit);
    }

    public List<Kudos> getKudosByEntity(String entityType, String entityId, int limit) {
        return this.kudosStorage.getKudosByEntity(entityType, entityId, limit);
    }

    public long countKudosByEntity(String entityType, String entityId) {
        return this.kudosStorage.countKudosByEntity(entityType, entityId);
    }

    public long countKudosByEntityAndSender(String entityType, String entityId, String senderIdentityId) {
        return this.kudosStorage.countKudosByEntityAndSender(entityType, entityId, senderIdentityId);
    }

    public long countKudosByPeriodAndSender(long senderIdentityId, long startDateInSeconds, long endDateInSeconds) {
        KudosPeriod kudosPeriod = new KudosPeriod(startDateInSeconds, endDateInSeconds);
        return this.kudosStorage.countKudosByPeriodAndSender(kudosPeriod, senderIdentityId);
    }

    public List<Kudos> getKudosByPeriodAndSender(long senderIdentityId, long startDateInSeconds, long endDateInSeconds, int limit) {
        KudosPeriod kudosPeriod = new KudosPeriod(startDateInSeconds, endDateInSeconds);
        return this.kudosStorage.getKudosByPeriodAndSender(kudosPeriod, senderIdentityId, limit);
    }

    public long countKudosByPeriodAndReceiver(long identityId, long startDateInSeconds, long endDateInSeconds) {
        KudosPeriod kudosPeriod = new KudosPeriod(startDateInSeconds, endDateInSeconds);
        org.exoplatform.social.core.identity.model.Identity identity = this.identityManager.getIdentity(String.valueOf(identityId));
        if (identity == null) {
            return 0L;
        }
        return this.kudosStorage.countKudosByPeriodAndReceiver(kudosPeriod, identity.getProviderId(), identity.getRemoteId());
    }

    public Map<Long, Long> countKudosByPeriodAndReceivers(List<Long> identitiesId, long startDateInSeconds, long endDateInSeconds) {
        KudosPeriod kudosPeriod = new KudosPeriod(startDateInSeconds, endDateInSeconds);
        return this.kudosStorage.countKudosByPeriodAndReceivers(kudosPeriod, identitiesId);
    }

    public List<Kudos> getKudosByPeriodAndReceiver(long identityId, long startDateInSeconds, long endDateInSeconds, int limit) {
        KudosPeriod kudosPeriod = new KudosPeriod(startDateInSeconds, endDateInSeconds);
        org.exoplatform.social.core.identity.model.Identity identity = this.identityManager.getIdentity(String.valueOf(identityId));
        if (identity == null) {
            return Collections.emptyList();
        }
        return this.kudosStorage.getKudosByPeriodAndReceiver(kudosPeriod, identity.getProviderId(), identity.getRemoteId(), limit);
    }

    public List<Kudos> getKudosListOfActivity(String activityId, Identity currentUser) throws IllegalAccessException {
        if (currentUser == null) {
            throw new IllegalArgumentException("User is mandatory");
        }
        ExoSocialActivity activity = this.activityManager.getActivity(activityId);
        if (activity == null) {
            return Collections.emptyList();
        }
        if (!this.activityManager.isActivityViewable(activity, currentUser)) {
            throw new IllegalAccessException("User " + currentUser.getUserId() + " isn't allowed to access kudos of activity with id " + activityId);
        }
        return this.getKudosListOfActivity(activityId);
    }

    public List<Kudos> getKudosListOfActivity(String activityId) {
        return this.kudosStorage.getKudosListOfActivity(Utils.getActivityId(activityId));
    }

    public KudosPeriodType getDefaultKudosPeriodType() {
        return Utils.getPeriodType(this.getGlobalSettings());
    }

    public KudosPeriod getCurrentKudosPeriod() {
        return Utils.getCurrentPeriod(this.getGlobalSettings());
    }

    public KudosPeriod getKudosPeriodOfTime(long dateInSeconds) {
        return Utils.getPeriodOfTime(this.getGlobalSettings(), Utils.timeFromSeconds(dateInSeconds));
    }

    public KudosPeriod getKudosPeriodOfTime(KudosPeriodType periodType, long dateInSeconds) {
        return periodType.getPeriodOfTime(Utils.timeFromSeconds(dateInSeconds));
    }

    private Object checkStatusAndGetReceiver(String type, String id) {
        if ("user".equals(type) || "organization".equals(type)) {
            org.exoplatform.social.core.identity.model.Identity identity = this.identityManager.getOrCreateIdentity("organization", id);
            if (identity == null || !identity.isEnable() || identity.isDeleted()) {
                throw new IllegalStateException("User with identity id '" + id + "' doesn't have a valid and enabled social identity");
            }
            return identity;
        }
        Space space = Utils.getSpace(id);
        if (space == null) {
            throw new IllegalStateException("Space with id '" + id + "' wasn't found, thus it can't receive/send kudos");
        }
        return space;
    }

    private long getAllowedKudosPerPeriod() {
        GlobalSettings storedGlobalSettings = this.getGlobalSettings();
        return storedGlobalSettings == null ? 0L : storedGlobalSettings.getKudosPerPeriod();
    }

    private GlobalSettings loadGlobalSettings() {
        SettingValue globalSettingsValue = this.settingService.get(Utils.KUDOS_CONTEXT, Utils.KUDOS_SCOPE, "ADDONS_KUDOS_SETTINGS");
        if (globalSettingsValue == null || StringUtils.isBlank((CharSequence)globalSettingsValue.getValue().toString())) {
            return null;
        }
        return GlobalSettings.parseStringToObject(globalSettingsValue.getValue().toString());
    }

    private void installClusterListener() {
        if (this.rpcService != null) {
            this.reloadSettingsCommand = this.rpcService.registerCommand(new RemoteCommand(){

                public String getId() {
                    return KudosService.CLUSTER_GLOBAL_SETTINGS_UPDATED;
                }

                public Serializable execute(Serializable[] args) throws Throwable {
                    if (!CLUSTER_NODE_ID.equals(args[0])) {
                        KudosService.this.globalSettings = null;
                    }
                    return Boolean.valueOf(true);
                }
            });
        }
    }

    private void clearCacheClusterWide() {
        if (this.reloadSettingsCommand != null) {
            try {
                this.rpcService.executeCommandOnAllNodes(this.reloadSettingsCommand, false, new Serializable[]{CLUSTER_NODE_ID});
            }
            catch (Exception e) {
                LOG.warn((Object)"An error occurred while clearing global settings cache on other nodes", (Throwable)e);
            }
        }
    }
}

