/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.kudos.dao;

import io.meeds.kudos.entity.KudosEntity;
import io.meeds.kudos.entity.KudosReceiverResult;
import java.util.List;
import org.springframework.data.domain.Limit;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;

public interface KudosDAO
extends JpaRepository<KudosEntity, Long> {
    public List<KudosEntity> findByCreatedDateBetweenOrderByCreatedDateDesc(long var1, long var3, Limit var5);

    public List<KudosEntity> findByCreatedDateBetweenAndEntityTypeOrderByCreatedDateDesc(long var1, long var3, int var5, Limit var6);

    public List<KudosEntity> findByEntityTypeAndEntityIdOrderByCreatedDateDesc(int var1, long var2, Limit var4);

    public List<KudosEntity> findByCreatedDateBetweenAndReceiverIdAndIsReceiverUserOrderByCreatedDateDesc(long var1, long var3, long var5, boolean var7, Limit var8);

    public List<KudosEntity> findByCreatedDateBetweenAndSenderIdOrderByCreatedDateDesc(long var1, long var3, long var5, Limit var7);

    public KudosEntity findByActivityId(Long var1);

    @Query(value="    SELECT k FROM Kudos k\n    WHERE\n      k.activityId = ?1\n        OR\n      (k.entityType in (?2) AND (k.parentEntityId = ?1 OR k.entityId in ?1))\n")
    public List<KudosEntity> findKudosListOfActivity(Long var1, List<Integer> var2);

    public long countByEntityTypeAndEntityId(int var1, long var2);

    public long countByEntityTypeAndEntityIdAndSenderId(int var1, long var2, long var4);

    public long countByCreatedDateBetweenAndReceiverIdAndIsReceiverUser(long var1, long var3, long var5, boolean var7);

    @Query(value="    SELECT COUNT(k.id) FROM Kudos k\n    WHERE\n      k.activityId = ?1\n        OR\n      (k.entityType in (?2) AND (k.parentEntityId = ?1 OR k.entityId in ?1))\n")
    public long countKudosListOfActivity(Long var1, List<Integer> var2);

    public long countByCreatedDateBetweenAndSenderId(long var1, long var3, long var5);

    @Query(value="   SELECT new io.meeds.kudos.entity.KudosReceiverResult(k.receiverId, COUNT(k)) from Kudos k\n   WHERE k.createdDate >= ?1\n   AND k.createdDate < ?2\n   AND k.receiverId IN ?3\n   GROUP BY k.receiverId\n")
    public List<KudosReceiverResult> countByCreatedDateBetweenAndReceiverIdIn(long var1, long var3, List<Long> var5);
}

