/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.kudos.listener;

import io.meeds.kudos.model.Kudos;
import io.meeds.kudos.service.KudosService;
import io.meeds.kudos.service.utils.Utils;
import jakarta.annotation.PostConstruct;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.activity.ActivityLifeCycleEvent;
import org.exoplatform.social.core.activity.ActivityListenerPlugin;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class KudosActivityListener
extends ActivityListenerPlugin {
    private static final Log LOG = ExoLogger.getLogger(KudosActivityListener.class);
    @Autowired
    private ActivityManager activityManager;
    @Autowired
    private KudosService kudosService;

    @PostConstruct
    public void init() {
        this.activityManager.addActivityEventListener((ActivityListenerPlugin)this);
    }

    public void updateActivity(ActivityLifeCycleEvent activityLifeCycleEvent) {
        long activityId;
        Kudos kudos;
        ExoSocialActivity activity = (ExoSocialActivity)activityLifeCycleEvent.getSource();
        if (activity != null && StringUtils.equals((CharSequence)activity.getType(), (CharSequence)"exokudos:activity") && (kudos = this.kudosService.getKudosByActivityId(activityId = Utils.getActivityId(activity.getId()))) != null) {
            String newMessage = activity.getTitle();
            kudos.setMessage(newMessage);
            this.kudosService.updateKudos(kudos);
            Utils.computeKudosActivityProperties(activity, kudos);
            this.activityManager.updateActivity(activity, false);
        }
    }

    public void deleteActivity(ActivityLifeCycleEvent activityLifeCycleEvent) {
        ExoSocialActivity activity = (ExoSocialActivity)activityLifeCycleEvent.getSource();
        List<Kudos> linkedKudosList = this.kudosService.getKudosListOfActivity(activity.getId());
        if (!linkedKudosList.isEmpty()) {
            this.deleteLinkedKudos(linkedKudosList);
        }
    }

    public void deleteComment(ActivityLifeCycleEvent activityLifeCycleEvent) {
        this.deleteActivity(activityLifeCycleEvent);
    }

    public void updateComment(ActivityLifeCycleEvent activityLifeCycleEvent) {
        this.updateActivity(activityLifeCycleEvent);
    }

    private void deleteLinkedKudos(List<Kudos> linkedKudosList) {
        linkedKudosList.forEach(kudos -> {
            try {
                this.kudosService.deleteKudosById(kudos.getTechnicalId());
            }
            catch (ObjectNotFoundException e) {
                LOG.debug("Kudos with id {} wasn't found", new Object[]{kudos.getTechnicalId(), e});
            }
        });
    }
}

