/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.kudos.rest;

import io.meeds.kudos.model.GlobalSettings;
import io.meeds.kudos.service.KudosService;
import io.meeds.kudos.service.utils.Utils;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.time.LocalDateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.annotation.Secured;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"settings"})
@Tag(name="/kudos/rest/settings", description="Manages Kudos global settings")
public class KudosSettingsREST {
    @Autowired
    private KudosService kudosService;

    @GetMapping
    @Secured(value={"users"})
    @Operation(summary="Get Kudos global settings", method="GET", description="Get Kudos global settings")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="403", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public GlobalSettings getSettings() {
        GlobalSettings globalSettings = this.kudosService.getGlobalSettings();
        globalSettings.setStartPeriodDateInSeconds(Utils.getPeriodOfTime(globalSettings, LocalDateTime.now()).getStartDateInSeconds());
        globalSettings.setEndPeriodDateInSeconds(Utils.getPeriodOfTime(globalSettings, LocalDateTime.now()).getEndDateInSeconds());
        return globalSettings;
    }

    @PostMapping
    @Secured(value={"administrators"})
    @Operation(summary="Saves Kudos global settings", method="POST", description="Saves Kudos global settings and returns an empty response")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Request fulfilled"), @ApiResponse(responseCode="403", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public void saveSettings(@RequestBody GlobalSettings settings) {
        this.kudosService.saveGlobalSettings(settings);
    }
}

